VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "ComDlg32.OCX"
Begin VB.Form CameraForm 
   BackColor       =   &H00E0E0E0&
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   "Camera Test"
   ClientHeight    =   7110
   ClientLeft      =   45
   ClientTop       =   285
   ClientWidth     =   6075
   ControlBox      =   0   'False
   Icon            =   "CameraForm.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   7110
   ScaleWidth      =   6075
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox tbxTileRows 
      Height          =   285
      Left            =   1560
      TabIndex        =   49
      Text            =   "4"
      Top             =   6000
      Width           =   1335
   End
   Begin VB.TextBox tbxTileColumns 
      Height          =   285
      Left            =   120
      TabIndex        =   48
      Text            =   "2"
      Top             =   6000
      Width           =   1335
   End
   Begin VB.CommandButton btnPhotoMultipleTiles 
      Caption         =   "Photo All Tiles and Save PNG"
      Height          =   495
      Left            =   120
      TabIndex        =   46
      Top             =   6480
      Width           =   2775
   End
   Begin VB.CommandButton btnSavePNG 
      Caption         =   "Save PNG"
      Height          =   495
      Left            =   1560
      TabIndex        =   45
      Top             =   5040
      Width           =   1335
   End
   Begin VB.CommandButton btnCorners 
      Caption         =   "Corners"
      Height          =   495
      Left            =   120
      TabIndex        =   44
      Top             =   5040
      Width           =   1335
   End
   Begin VB.CommandButton btnMove 
      Caption         =   "Move to Slide"
      Height          =   495
      Left            =   3120
      TabIndex        =   43
      Top             =   6480
      Width           =   1335
   End
   Begin VB.Frame Frame1 
      BackColor       =   &H00E0E0E0&
      Caption         =   "Feature Information"
      Height          =   2295
      Left            =   3120
      TabIndex        =   33
      Top             =   3240
      Width           =   2775
      Begin VB.TextBox tbxFeatureX 
         Height          =   285
         Left            =   240
         TabIndex        =   36
         Text            =   "1"
         Top             =   600
         Width           =   1095
      End
      Begin VB.TextBox tbxFeatureY 
         Height          =   285
         Left            =   1440
         TabIndex        =   35
         Text            =   "1"
         Top             =   600
         Width           =   1095
      End
      Begin VB.CommandButton btnDisplayFeature 
         Caption         =   "Display"
         Height          =   495
         Left            =   240
         TabIndex        =   34
         Top             =   1560
         Width           =   2295
      End
      Begin VB.Label Label10 
         BackStyle       =   0  'Transparent
         Caption         =   "X:"
         Height          =   255
         Left            =   240
         TabIndex        =   42
         Top             =   360
         Width           =   1215
      End
      Begin VB.Label Label11 
         BackStyle       =   0  'Transparent
         Caption         =   "Y:"
         Height          =   255
         Left            =   1680
         TabIndex        =   41
         Top             =   360
         Width           =   1215
      End
      Begin VB.Label lblDeltaX 
         BackStyle       =   0  'Transparent
         Caption         =   "dX=*"
         Height          =   255
         Left            =   240
         TabIndex        =   40
         Top             =   960
         Width           =   1215
      End
      Begin VB.Label lblDeltaY 
         BackStyle       =   0  'Transparent
         Caption         =   "dY=*"
         Height          =   255
         Left            =   1440
         TabIndex        =   39
         Top             =   960
         Width           =   1215
      End
      Begin VB.Label lblArea 
         BackStyle       =   0  'Transparent
         Caption         =   "Area=*"
         Height          =   255
         Left            =   240
         TabIndex        =   38
         Top             =   1200
         Width           =   1215
      End
      Begin VB.Label lblQuality 
         BackStyle       =   0  'Transparent
         Caption         =   "Quality=*"
         Height          =   255
         Left            =   1440
         TabIndex        =   37
         Top             =   1200
         Width           =   1215
      End
   End
   Begin VB.ComboBox cmbWhere 
      Height          =   315
      ItemData        =   "CameraForm.frx":144A
      Left            =   3120
      List            =   "CameraForm.frx":149F
      TabIndex        =   32
      Text            =   "Slide 01"
      Top             =   6000
      Width           =   1335
   End
   Begin VB.Frame fraZoom 
      BackColor       =   &H00E0E0E0&
      Caption         =   "Zoom factor  (Display size)"
      Height          =   1935
      Left            =   3120
      TabIndex        =   27
      Top             =   1200
      Width           =   2775
      Begin VB.OptionButton optZoom 
         BackColor       =   &H00E0E0E0&
         Caption         =   "1:4  (Smallest)"
         Height          =   255
         Index           =   4
         Left            =   600
         TabIndex        =   31
         Top             =   1440
         Width           =   1335
      End
      Begin VB.OptionButton optZoom 
         BackColor       =   &H00E0E0E0&
         Caption         =   "1:3"
         Height          =   255
         Index           =   3
         Left            =   600
         TabIndex        =   30
         Top             =   1080
         Width           =   1335
      End
      Begin VB.OptionButton optZoom 
         BackColor       =   &H00E0E0E0&
         Caption         =   "1:2 (Default)"
         Height          =   255
         Index           =   2
         Left            =   600
         TabIndex        =   29
         Top             =   720
         Value           =   -1  'True
         Width           =   1215
      End
      Begin VB.OptionButton optZoom 
         BackColor       =   &H00E0E0E0&
         Caption         =   "1:1 (Biggest)"
         Height          =   255
         Index           =   1
         Left            =   600
         TabIndex        =   28
         Top             =   360
         Width           =   1215
      End
   End
   Begin VB.CommandButton btnClosePhoto 
      Caption         =   "Close Photo"
      Height          =   495
      Left            =   1560
      TabIndex        =   26
      Top             =   4440
      Width           =   1335
   End
   Begin VB.TextBox tbxSquash 
      Height          =   285
      Left            =   120
      TabIndex        =   8
      Text            =   "50"
      Top             =   3960
      Width           =   1335
   End
   Begin VB.TextBox tbxGamma 
      Height          =   285
      Left            =   1560
      TabIndex        =   9
      Text            =   "1"
      Top             =   3960
      Width           =   1335
   End
   Begin VB.TextBox tbxMinR 
      Height          =   285
      Left            =   120
      TabIndex        =   6
      Text            =   "3"
      Top             =   3360
      Width           =   1335
   End
   Begin VB.TextBox tbxMaxR 
      Height          =   285
      Left            =   1560
      TabIndex        =   7
      Text            =   "8"
      Top             =   3360
      Width           =   1335
   End
   Begin VB.CheckBox chkTestMode 
      BackColor       =   &H00E0E0E0&
      Caption         =   "Camera disconnected - test mode"
      Enabled         =   0   'False
      Height          =   255
      Left            =   3120
      TabIndex        =   10
      Top             =   840
      Value           =   1  'Checked
      Width           =   2775
   End
   Begin VB.TextBox tbxBRY 
      Height          =   285
      Left            =   1560
      TabIndex        =   5
      Text            =   "110"
      Top             =   2520
      Width           =   1335
   End
   Begin VB.TextBox tbxBRX 
      Height          =   285
      Left            =   120
      TabIndex        =   4
      Text            =   "110"
      Top             =   2520
      Width           =   1335
   End
   Begin VB.TextBox tbxTLY 
      Height          =   285
      Left            =   1560
      TabIndex        =   3
      Text            =   "20"
      Top             =   1680
      Width           =   1335
   End
   Begin VB.TextBox tbxTLX 
      Height          =   285
      Left            =   120
      TabIndex        =   2
      Text            =   "20"
      Top             =   1680
      Width           =   1335
   End
   Begin VB.TextBox tbxHeight 
      Height          =   285
      Left            =   1560
      TabIndex        =   1
      Text            =   "8"
      Top             =   840
      Width           =   1335
   End
   Begin VB.TextBox tbxWidth 
      Height          =   285
      Left            =   120
      TabIndex        =   0
      Text            =   "10"
      Top             =   840
      Width           =   1335
   End
   Begin VB.CommandButton btnPhotoOneTile 
      Caption         =   "Photo One Tile"
      Height          =   495
      Left            =   120
      TabIndex        =   11
      Top             =   4440
      Width           =   1335
   End
   Begin VB.CommandButton btnClose 
      Caption         =   "Close"
      Default         =   -1  'True
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   4560
      TabIndex        =   13
      Top             =   6480
      Width           =   1335
   End
   Begin MSComDlg.CommonDialog cdlgSavePNG 
      Left            =   5400
      Top             =   360
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      CancelError     =   -1  'True
      DefaultExt      =   "*.png"
      FileName        =   "pogo.png"
      Filter          =   "Portable Network Graphics (*.png)"
   End
   Begin VB.Label Label18 
      BackStyle       =   0  'Transparent
      Caption         =   "Tile Rows"
      Height          =   255
      Left            =   1560
      TabIndex        =   51
      Top             =   5760
      Width           =   1215
   End
   Begin VB.Label Label17 
      BackStyle       =   0  'Transparent
      Caption         =   "Tile Columns"
      Height          =   255
      Left            =   120
      TabIndex        =   50
      Top             =   5760
      Width           =   1215
   End
   Begin VB.Label Label9 
      BackStyle       =   0  'Transparent
      Caption         =   $"CameraForm.frx":15B1
      ForeColor       =   &H00FF0000&
      Height          =   495
      Left            =   120
      TabIndex        =   47
      Top             =   0
      Width           =   5655
   End
   Begin VB.Label Label16 
      BackStyle       =   0  'Transparent
      Caption         =   "Squash factor"
      Height          =   255
      Left            =   120
      TabIndex        =   25
      Top             =   3720
      Width           =   1215
   End
   Begin VB.Label Label15 
      BackStyle       =   0  'Transparent
      Caption         =   "Gamma"
      Height          =   255
      Left            =   1560
      TabIndex        =   24
      Top             =   3720
      Width           =   1215
   End
   Begin VB.Label Label14 
      BackStyle       =   0  'Transparent
      Caption         =   "Spot finding and display parameters"
      Height          =   255
      Left            =   120
      TabIndex        =   23
      Top             =   2880
      Width           =   2775
   End
   Begin VB.Label Label13 
      BackStyle       =   0  'Transparent
      Caption         =   "Minimum Radius"
      Height          =   255
      Left            =   120
      TabIndex        =   22
      Top             =   3120
      Width           =   1215
   End
   Begin VB.Label Label12 
      BackStyle       =   0  'Transparent
      Caption         =   "Maximum Radius"
      Height          =   255
      Left            =   1560
      TabIndex        =   21
      Top             =   3120
      Width           =   1215
   End
   Begin VB.Label Label8 
      BackStyle       =   0  'Transparent
      Caption         =   "Y:"
      Height          =   255
      Left            =   1560
      TabIndex        =   20
      Top             =   2280
      Width           =   1215
   End
   Begin VB.Label Label7 
      BackStyle       =   0  'Transparent
      Caption         =   "X:"
      Height          =   255
      Left            =   120
      TabIndex        =   19
      Top             =   2280
      Width           =   1215
   End
   Begin VB.Label Label6 
      BackStyle       =   0  'Transparent
      Caption         =   "Bottom Right Feature Coordinates"
      Height          =   255
      Left            =   120
      TabIndex        =   18
      Top             =   2040
      Width           =   2775
   End
   Begin VB.Label Label5 
      BackStyle       =   0  'Transparent
      Caption         =   "Y:"
      Height          =   255
      Left            =   1560
      TabIndex        =   17
      Top             =   1440
      Width           =   1215
   End
   Begin VB.Label Label4 
      BackStyle       =   0  'Transparent
      Caption         =   "X:"
      Height          =   255
      Left            =   120
      TabIndex        =   16
      Top             =   1440
      Width           =   1215
   End
   Begin VB.Label Label3 
      BackStyle       =   0  'Transparent
      Caption         =   "Top Left Feature Coordinates"
      Height          =   375
      Left            =   120
      TabIndex        =   15
      Top             =   1200
      Width           =   2775
   End
   Begin VB.Label Label2 
      BackStyle       =   0  'Transparent
      Caption         =   "Rows"
      Height          =   255
      Left            =   1560
      TabIndex        =   14
      Top             =   600
      Width           =   1095
   End
   Begin VB.Label Label1 
      BackStyle       =   0  'Transparent
      Caption         =   "Columns"
      Height          =   255
      Left            =   120
      TabIndex        =   12
      Top             =   600
      Width           =   1335
   End
End
Attribute VB_Name = "CameraForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'CameraForm form/class.
'18 Oct 2004
'Copyright
'C Lausted, Institute for Systems Biology
'
'This form is probably not going to be shown by Pogo except for testing.
'This form is used to image an array of droplets on a clear glass surface.
'Multiple images will need to be photographed to analyze all of the droplets.
'Metaimage refers to all the images (tiles) needed to see the whole droplet array surface.
'We use PogoMain.Move*() functions for motion control.
'
'TODO: Error checking of properties after user edits tbx.  Height and width reversed?
'
'Properties:
'  bTest => Set to TRUE when testing with no camera attached.
'  GColumns, GRows => Number of columns, rows of droplets in one tile image.
'  TLX, TLY, BRX, BRY => left, top, right, bottom droplet array coordinates.
'  Minr, MaxR => Range of droplet radii
'  Gamma => Image gamma correction factor. Usually 1. Tweak for best spotfinding.
'  Zoom => Display image 1 (100%), 2 (50%), 3 (33%) or 4 (25%)
'  TColumns, TRows => Number of columns, rows of tiles in metaimage. Less than 10x10.
'
'Public Functions:
'  sErr = SnapMultipleTiles(iRows, iCols, bAnalyze, bSave, sFilename)
'  sErr = GetMetaFeature(x, y, *dx, *dy, *area, *quality)     *Pass by reference
'
'
'Dependencies: PogoMain, ErrorMessage.
'              vision.dll (which uses Micropix IEEE1394 CCD and the
'              C:\WINNT\System32\1394camera.dll from CMU Robotics Institute).
'/////////////////////////////////////////////////////////////////////////////////////

Option Base 1
Private Const CMAXWIDTH As Integer = 512  'Maximum columns of features in a grid.
Private Const CMAXHEIGHT As Integer = 512 'Maximum rows of features in a grid.
Private Const CPIXELSX As Integer = 1024  'Image width.
Private Const CPIXELSY As Integer = 768   'Image height.
Private Const CMAXTILES As Integer = 10   'Maximum number of tiles vert or horiz.
Private Const CCOMPRESSION As Integer = 1 'PNG compression.

'DLL DECLARATIONS.
'  The alias names are given because the compiled dll uses the _stdcall convention, which mangles
'  the names of the functions. In general the mangled name is the function name preceded by an "_"
'  and proceded by "@<num bytes in parameter>".
'
'The METAIMAGE FUNCTIONS allow us to stitch multiple image tiles into a big image to save as PNG.
'Initialize height, width, and number of channels (mono = 1, RGB = 2 or 3).
Private Declare Function SetupMetaImage Lib "vision.dll" _
    Alias "_SetupMetaImage@12" (ByVal rows As Long, ByVal cols As Long, _
    ByVal channels As Long) As Long
'Insert the current image as one tile into the metaimage.
Private Declare Function InsertTile Lib "vision.dll" _
    Alias "_InsertTile@12" (ByVal row As Long, ByVal col As Long, _
    ByVal channel As Long) As Long
'Save the metaimage as a PNG file.
Private Declare Function SaveMetaImage Lib "vision.dll" _
    Alias "_SaveMetaImage@8" (ByVal filename As String, _
    ByVal compression As Long) As Long
'Deallocate metaimage memory.
Private Declare Function DestroyMetaImage Lib "vision.dll" _
    Alias "_DestroyMetaImage@0" () As Long
'
'The INDIVIDUAL IMAGE functions.
'Take a photo, overwriting previous photo.
Private Declare Function PhotographSpots Lib "vision.dll" _
    Alias "_PhotographSpots@0" () As Long
'Photograph the slide that will be used for field flattening.
Private Declare Function PhotographBlank Lib "vision.dll" _
    Alias "_PhotographBlank@0" () As Long
'Apply Y2=Y1&gammma to the image.
Private Declare Function ApplyGamma Lib "vision.dll" _
    Alias "_ApplyGamma@4" (ByVal Gamma As Single) As Long
'Flip the image.
Private Declare Function FlipSpots Lib "vision.dll" _
    Alias "_FlipSpots@8" (ByVal flipHorz As Long, flipVert As Long) As Long
'Apply field flattening using Blank image.
Private Declare Function ApplyFlattening Lib "vision.dll" _
    Alias "_ApplyFlattening@0" () As Long
'Set the geometery of the droplet array.
Private Declare Function SetRegion Lib "vision.dll" _
    Alias "_SetRegion@24" (ByVal top As Long, _
    ByVal left As Long, ByVal bottom As Long, ByVal right As Long, _
    ByVal numSpotsX As Long, ByVal numSpotsY As Long) As Integer
'NOTE: Gamma is not currently implemented.
Private Declare Function SetSpotFinderParameters Lib "vision.dll" _
    Alias "_SetSpotFinderParameters@12" (ByVal minRadius As Long, ByVal maxRadius As Long, _
    ByVal SquashFactor As Long) As Long
'Return attributes of the droplet.
Private Declare Function GetFeatureInfo Lib "vision.dll" _
    Alias "_GetFeatureInfo@24" (ByVal row As Long, _
    ByVal col As Long, ByRef dx As Long, ByRef dy As Long, _
    ByRef area As Long, ByRef quality As Long) As Long
'Begins a new thread that is a display of the spots.
'Note: this function can potentially crash the system if concurent modifications to the image are done without first closing the window.
Private Declare Function ShowSpots Lib "vision.dll" _
    Alias "_ShowSpots@4" (ByVal imagereduction As Long) As Long
'Close the window if it is open.
Private Declare Function CloseWindow Lib "vision.dll" _
    Alias "_CloseSpotWindow@0" () As Long
'Sets wether or not the grid is show when the spots are displayed.
Private Declare Function GridShown Lib "vision.dll" _
    Alias "_GridShown@4" (ByVal shown As Long) As Long
Private Declare Function GetUserCreatedRectangle Lib "vision.dll" _
    Alias "_GetUserCreatedRectangle@16" (ByRef top As Long, _
    ByRef left As Long, ByRef bottom As Long, ByRef right As Long) As Long

'TYPES.
Private Type Feature
    dx As Integer       'X placement error of droplet feature.
    dy As Integer       'Y placement error of droplet feature.
    area As Integer     'Area of feature.
    quality As Integer  'Quality of feature.
End Type


'VARIABLES, module and public.
Dim lstat As Long
Dim features() As Feature    'Array (probably 70*140) of feature information.



'STARTUP & SHUTDOWN SUBROUTINES.
'----------------------------------------------------------------------------
Private Sub Form_Load()
    '20 July 2004 CGL.
    'This form should be loaded at Pogo startup.
    'Set up a meta image to hold all of the tiles thate make up a whole array image.
    'For now, just one row, one column, one color.
    'Check if camera works by snapping one photo.
    On Error GoTo ErrorHandler
    bTest = False
    lstat = PhotographSpots
    If (lstat = 0) Then Exit Sub 'No error so exit now.
ErrorHandler:
    bTest = True
    ErrorMessage.Log "CameraForm was unable to use the IEEE1394 camera."
End Sub


Private Sub Form_Unload(iCancel As Integer)
    '18 August 2004 CGL
    'Just deallocate the metaimage memory.
    Dim sErr As String
    Rem sErr = MyDestroyMetaImage
    sErr = MyCloseWindow()
End Sub


Private Sub btnClose_Click()
    '18 August 2004 CGL
    Hide
End Sub


'WRAPPERS FOR DLL FUNCTIONS TO ALLOW TEST MODE.
'----------------------------------------------------------------------------
Private Function MySetupMetaImage(rows As Long, cols As Long, channels As Long) As String
    '24 Aug 2004 CGL.
    Dim lErr As Long, sErr As String
    If bTest Then Exit Function
    lErr = SetupMetaImage(rows, cols, channels)
    If (lErr <> 0) Then
        sErr = "Error in CameraForm.MySetupMetaImage: " & ErrDesc(lErr)
        ErrorMessage.Display sErr, 5
        MySetupMetaImage = sErr
    End If
End Function

Private Function MyInsertTile(row As Long, col As Long, channel As Long) As String
    '26 Aug 2004 CGL.
    'Insert a tile into metaimage.  DLL is base 0 but this is base 1.
    Dim lErr As Long, sErr As String
    If bTest Then Exit Function
    lErr = InsertTile(row - 1, col - 1, channel)
    If (lErr <> 0) Then
        sErr = "Error in CameraForm.MyInsertTile: " & ErrDesc(lErr)
        ErrorMessage.Display sErr, 5
        MyInsertTile = sErr
    End If
End Function

Private Function MySaveMetaImage(filename As String, compression As Long) As String
    '24 Aug 2004 CGL.
    Dim lErr As Long, sErr As String, fileNo
    If bTest Then
        'Create a dummy file.
        On Error GoTo ErrorHandler
        fileNo = FreeFile
        Open (filename & ".txt") For Output As #fileNo
        Write #fileNo, "This is a test of Pogo camera functions."
        Close #fileNo
    Else
        'Save a real PNG file.
        lErr = SaveMetaImage(filename, compression)
        If (lErr <> 0) Then
            sErr = "Error in CameraForm.MySaveMetaImage: " & ErrDesc(lErr)
            ErrorMessage.Display sErr, 5
            MySaveMetaImage = sErr
        End If
    End If
    Exit Function
ErrorHandler:
    MySaveMetaImage = "Error creating file " & filename
End Function

Private Function MyDestroyMetaImage() As String
    '24 Aug 2004 CGL.
    Dim lErr As Long, sErr As String
    If bTest Then Exit Function
    lErr = DestroyMetaImage()
    If (lErr <> 0) Then
        sErr = "Error in CameraForm.MyDestroyMetaImage: " & ErrDesc(lErr)
        ErrorMessage.Display sErr, 5
        MyDestroyMetaImage = sErr
    End If
End Function

Private Function MyPhotographSpots() As String
    '24 Aug 2004 CGL.
    'Here we roll PhotographSpots(), ApplyGamma(), and FlipSpots() together.
    'Take a two pictures so that contrast is better adjusted.
    'TODO: Add ApplyFlattening before rotation. First need PhotographBlank.
    Dim lErr As Long, sErr As String
    If bTest Then Exit Function
    lErr = PhotographSpots()
    lErr = PhotographSpots()
    If (lErr <> 0) Then sErr = sErr & ErrDesc(lErr) & vbCrLf
    lErr = ApplyGamma(Gamma)
    If (lErr <> 0) Then sErr = sErr & ErrDesc(lErr) & vbCrLf
    lErr = FlipSpots(1, 1) 'Rotate image 180 degrees.
    If (lErr <> 0) Then sErr = sErr & ErrDesc(lErr) & vbCrLf
    If (Len(sErr) > 0) Then
        sErr = "Error in CameraForm.MyPhotographSpots: " & sErr
        ErrorMessage.Display sErr, 5
        MyPhotographSpots = sErr
    End If
End Function

Private Function MySetRegion() As String
    '24 Aug 2004 CGL.
    'Use properties TLX (left), TLY (top), BRX (right), BRY (bottom),
    '  GColumns, and GRows rather than parameters.
    Dim lErr As Long, sErr As String
    If bTest Then Exit Function
    lErr = SetRegion(TLY, TLX, BRY, BRX, GColumns, GRows)
    If (lErr <> 0) Then
        sErr = "Error in CameraForm.MySetRegion: " & ErrDesc(lErr)
        ErrorMessage.Display sErr, 5
        MySetRegion = sErr
    End If
End Function

Private Function MySetSpotFinderParameters() As String
    '24 Aug 2004 CGL.
    'User properties MinR, MaxR, Squash rather than parameters.
    Dim lErr As Long, sErr As String
    If bTest Then Exit Function
    lErr = SetSpotFinderParameters(MinR, MaxR, Squash)
    If (lErr <> 0) Then
        sErr = "Error in CameraForm.MySetSpotFinderParameters: " & ErrDesc(lErr)
        ErrorMessage.Display sErr, 5
        MySetSpotFinderParameters = sErr
    End If
End Function

Private Function MyGetFeatureInfo(row As Long, col As Long, _
    dx As Long, dy As Long, area As Long, quality As Long) As String
    '24 Aug 2004 CGL.
    'Return parameters dx, dy, area, & quality are passed by reference.
    Dim lErr As Long, sErr As String
    'Check feature array bounds.
    If (row < 1 Or row > GRows Or col < 1 Or col > GColumns) Then
        MyGetFeatureInfo = "Error in CameraForm.MyGetFeatureInfo: array element out of range."
        Exit Function
    End If
    'If not in test mode, access the DLL.
    If bTest Then Exit Function
    lErr = GetFeatureInfo(row, col, dx, dy, area, quality)
    If (lErr <> 0) Then
        sErr = "Error in CameraForm.MyGetFeatureInfo: " & ErrDesc(lErr)
        ErrorMessage.Display sErr, 5
        MyGetFeatureInfo = sErr
    End If
End Function

Private Function MyShowSpots() As String
    '24 Aug 2004 CGL.
    'Use Zoom property rather than take a parameter.
    Dim lErr As Long, sErr As String
    If bTest Then Exit Function
    lErr = ShowSpots(Zoom)
    If (lErr <> 0) Then
        sErr = "Error in CameraForm.MyShowSpots: " & ErrDesc(lErr)
        ErrorMessage.Display sErr, 5
        MyShowSpots = sErr
    End If
End Function

Private Function MyCloseWindow() As String
    '24 Aug 2004 CGL.
    Dim lErr As Long, sErr As String
    If bTest Then Exit Function
    lErr = CloseWindow()
    If (lErr <> 0) Then
        sErr = "Error in CameraForm.MyCloseWindow: " & ErrDesc(lErr)
        ErrorMessage.Display sErr, 5
        MyCloseWindow = sErr
    End If
End Function

Private Function MyGridShown(bShown As Boolean) As String
    '24 Aug 2004 CGL.
    Dim lErr As Long, sErr As String
    If bTest Then Exit Function
    If bShown Then lErr = GridShown(1) Else lErr = GridShown(0)
    If (lErr <> 0) Then
        sErr = "Error in CameraForm.MyGridShown: " & ErrDesc(lErr)
        ErrorMessage.Display sErr, 5
        MyGridShown = sErr
    End If
End Function

Private Function MyGetUserCreatedRectangle(top As Long, left As Long, _
    bottom As Long, right As Long) As String
    '24 Aug 2004 CGL.
    'Return parameters top, left, bottom, & right are passed by reference.
    Dim lErr As Long, sErr As String
    If bTest Then Exit Function
    lErr = GetUserCreatedRectangle(top, left, bottom, right)
    If (lErr <> 0) Then
        sErr = "Error in CameraForm.MyGetUserCreatedRectangle: " & ErrDesc(lErr)
        ErrorMessage.Display sErr, 5
        MyGetUserCreatedRectangle = sErr
    End If
End Function

Private Function ErrDesc(lErr As Long) As String
    '30 June 2004 CGL.
    'Describe error code from vision.dll.
    Dim sErr As String
    sErr = "Undefined error."
    If (lErr = &H1) Then sErr = "Bad argument."
    If (lErr = &H2) Then sErr = "Internal data not defined."
    If (lErr = &H4) Then sErr = "Internal data not consistent."
    If (lErr = &H10) Then sErr = "Cannot close window."
    If (lErr = &H100) Then sErr = "Unadvised range of data."
    If (lErr = &H1000) Then sErr = "File IO error."
    If (lErr = &H2000) Then sErr = "Camera error."
    If (lErr = &H4000) Then sErr = "Camera not found."
    If (lErr = &H8000) Then sErr = "Unknown error."
    ErrDesc = sErr
End Function



'PROPERTIES.
'----------------------------------------------------------------------------
Public Property Get bTest() As Boolean
    '26 July 2004 CGL.
    'TRUE if we camera not connected.
    bTest = (chkTestMode.value = vbChecked)
End Property
Private Property Let bTest(newvalue As Boolean)
    '26 July 2004 CGL.
    If newvalue Then chkTestMode.value = vbChecked Else chkTestMode.value = vbUnchecked
End Property

Public Property Get GColumns() As Long
    '26 July 2004 CGL.
    'Get the width of grid (in columns of features).
    GColumns = Int(Val(tbxWidth.Text))
End Property
Public Property Let GColumns(ByVal x As Long)
    '26 July 2004 CGL.
    'Change the width of grid (in columns of features).
    If (x < 1) Then x = 1
    If (x > CMAXWIDTH) Then x = CMAXWIDTH
    tbxWidth.Text = x
End Property

Public Property Get GRows() As Long
    '26 July 2004 CGL.
    'Get the height of grid (in rows of features).
    GRows = Int(Val(tbxHeight.Text))
End Property
Public Property Let GRows(ByVal y As Long)
    '26 July 2004 CGL.
    'Change the height of grid (in rows of features).
    If (y < 1) Then y = 1
    If (y > CMAXHEIGHT) Then y = CMAXHEIGHT
    tbxHeight.Text = y
End Property

Public Property Get TLX() As Long
    '26 July 2004 CGL.
    'Get the x coordinate of top left feature.
    TLX = Int(Val(tbxTLX.Text))
End Property
Public Property Let TLX(ByVal x As Long)
    '26 July 2004 CGL.
    'Change the x coordinate of top left feature.
    If (x < 1) Then x = 1
    If (x > CPIXELSX) Then x = CPIXELSX
    tbxTLX.Text = x
End Property

Public Property Get TLY() As Long
    '26 July 2004 CGL.
    'Get the y coordinate of top left feature.
    TLY = Int(Val(tbxTLY.Text))
End Property
Public Property Let TLY(ByVal y As Long)
    '26 July 2004 CGL.
    'Set the y coordinate of top left feature.
    If (y < 1) Then y = 1
    If (y > CPIXELSY) Then y = CPIXELSY
    tbxTLY.Text = y
End Property

Public Property Get BRX() As Long
    '26 July 2004 CGL.
    'Get the x coordinate of bottom right feature.
    BRX = Int(Val(tbxBRX.Text))
End Property
Public Property Let BRX(ByVal x As Long)
    '26 July 2004 CGL.
    'Change the x coordinate of bottom right feature.
    If (x < 1) Then x = 1
    If (x > CPIXELSX) Then x = CPIXELSX
    tbxBRX.Text = x
End Property

Public Property Get BRY() As Long
    '26 July 2004 CGL.
    'Get the y coordinate of bottom right feature.
    BRY = Int(Val(tbxBRY.Text))
End Property
Public Property Let BRY(ByVal y As Long)
    '26 July 2004 CGL.
    'Set the y coordinate of bottom right feature.
    If (y < 1) Then y = 1
    If (y > CPIXELSY) Then y = CPIXELSY
    tbxBRY.Text = y
End Property

Public Property Get MinR() As Long
    '26 July 2004 CGL.
    'Get the minimum radius of a feature.
    MinR = Int(Val(tbxMinR.Text))
End Property
Public Property Let MinR(ByVal R As Long)
    '26 July 2004 CGL.
    If (R < 1) Then R = 1
    If (R > CPIXELSX) Then R = CPIXELSX
    tbxMinR.Text = R
End Property

Public Property Get MaxR() As Long
    '26 July 2004 CGL.
    'Get the maximum radius of a feature.
    MaxR = Int(Val(tbxMaxR.Text))
End Property
Public Property Let MaxR(ByVal R As Long)
    '26 July 2004 CGL.
    If (R < 1) Then R = 1
    If (R > CPIXELSX) Then R = CPIXELSX
    tbxMaxR.Text = R
End Property

Public Property Get Squash() As Long
    '26 July 2004 CGL.
    Squash = Int(Val(tbxSquash.Text))
End Property
Public Property Let Squash(ByVal newvalue As Long)
    '26 July 2004 CGL.
    tbxSquash.Text = newvalue
End Property

Public Property Get Gamma() As Long
    '26 July 2004 CGL.
    'Get the gamma (Y2=Y1^Gamma) applied to the image buffer.
    Gamma = Int(Val(tbxGamma.Text))
End Property
Public Property Let Gamma(ByVal newvalue As Long)
    '26 July 2004 CGL.
    tbxGamma.Text = newvalue
End Property

Public Property Get Zoom() As Long
    '30 July 2004 CGL.
    'Get the image Zoom out factor 1:N (so display window smaller/faster).
    Zoom = 1
    If (optZoom(1).value = True) Then Zoom = 1
    If (optZoom(2).value = True) Then Zoom = 2
    If (optZoom(3).value = True) Then Zoom = 3
    If (optZoom(4).value = True) Then Zoom = 4
End Property
Public Property Let Zoom(ByVal newvalue As Long)
    '27 Aug 2004 CGL.
    If (newvalue < 1) Then newvalue = 1
    If (newvalue > 4) Then newvalue = 4
    optZoom(newvalue).value = True
End Property

Public Property Get TColumns() As Long
    '27 Aug 2004 CGL.
    'Get the number of tiles horizontally in the metaimage.
    TColumns = Int(Val(tbxTileColumns.Text))
End Property
Public Property Let TColumns(ByVal x As Long)
    '27 Aug 2004 CGL.
    'Change the number of tiles horizontally in the metaimage.
    If (x < 1) Then x = 1
    If (x > CMAXTILES) Then x = CMAXTILES
    tbxTileColumns.Text = x
End Property

Public Property Get TRows() As Long
    '27 Aug 2004 CGL.
    'Get the number of tiles vertically in the metaimage.
    TRows = Int(Val(tbxTileRows.Text))
End Property
Public Property Let TRows(ByVal y As Long)
    '27 Aug 2004 CGL.
    'Change the number of tiles vertically in the metaimage.
    If (y < 1) Then y = 1
    If (y > CMAXTILES) Then y = CMAXTILES
    tbxTileRows.Text = y
End Property


'SUBROUTINES AND FUNCTIONS.
'----------------------------------------------------------------------------
Private Sub btnPhotoOneTile_Click()
    '26 Aug 2004 CGL
    'User clicked button requesting a photo.
    Dim sErr As String
    sErr = SnapPhoto()
End Sub


Public Function SnapPhoto() As String
    '18 Oct 2004 CGL
    'Take a photo and show it in a new window with green overlay grid.
    Dim sErr As String
    Dim mousept0
    mousept0 = Screen.MousePointer
    Screen.MousePointer = vbHourglass
    Rem sErr = MyCloseWindow()
    sErr = sErr & MyPhotographSpots()
    sErr = sErr & MySetRegion()
    sErr = sErr & MyGridShown(True)
    sErr = sErr & MyShowSpots()
    sErr = sErr & MySetSpotFinderParameters()
    Screen.MousePointer = mousept0
    SnapPhoto = sErr
End Function


Private Sub btnClosePhoto_Click()
    '26 Aug 2004 CGL
    'Close the window created by vision.dll.
    Dim sErr As String
    Dim mousept0
    mousept0 = Screen.MousePointer
    Screen.MousePointer = vbHourglass
    sErr = MyCloseWindow()
    Screen.MousePointer = mousept0
End Sub


Private Sub btnDisplayFeature_Click()
    '26 Aug 2004 CGL
    'Show the user the properties of this droplet feature.
    'If in test mode, just use zero values.
    Dim sErr As String
    Dim x As Long, y As Long
    Dim dx As Long, dy As Long, area As Long, quality As Long
    x = Int(Val(tbxFeatureX.Text))
    y = Int(Val(tbxFeatureY.Text))
    'Call function and update display.
    sErr = MyGetFeatureInfo(x, y, dx, dy, area, quality)
    lblDeltaX.Caption = "dX=" & dx
    lblDeltaY.Caption = "dY=" & dy
    lblArea.Caption = "Area=" & area
    lblQuality.Caption = "Quality=" & quality
End Sub


Private Sub btnCorners_Click()
    '26 Aug 2004 CGL
    'Get the droplet array top-left and bottom right corners from the user's crosshairs.
    Dim sErr As String, txt As String
    Dim x1 As Long, y1 As Long, x2 As Long, y2 As Long
    'Prompt user with instructions.
    txt = txt & "To set the coordinates of the droplet array, click in the center of the" & vbCrLf
    txt = txt & "corner droplets.  Left-click on the top-left drop and right-click on " & vbCrLf
    txt = txt & "the bottom right droplet.  Press the OK button once you have done " & vbCrLf
    txt = txt & "this and the crosshairs are visible.  If you have not yet taken an image, " & vbCrLf
    txt = txt & " press the Cancel button." & vbCrLf
    If (MsgBox(txt, vbOKCancel) = vbCancel) Then Exit Sub
    'Get the corner coordinates.
    sErr = MyGetUserCreatedRectangle(y1, x1, y2, x2)
    TLX = x1 * Zoom:  TLY = y1 * Zoom
    BRX = x2 * Zoom:    BRY = y2 * Zoom
End Sub


Private Function AskForFilename() As String
    '27 Aug 2004 CGL
    'Use a Save As dialog box to let user choose file name.
    Dim fname As String
    On Error GoTo ErrorHandler
    cdlgSavePNG.ShowSave
    fname = cdlgSavePNG.filename
    If (Len(dir(fname)) > 0) Then
        If (MsgBox(fname & " already exists.  Do you wish to overwrite it?", vbYesNo) = vbNo) Then GoTo ErrorHandler
    End If
    AskForFilename = fname  'Extra space was hack around vision.dll bug.
    Exit Function
ErrorHandler:
    'User clicked cancel button so return empty string.
    AskForFilename = ""
End Function


Private Sub btnSavePNG_Click()
    '26 Aug 2004 CGL
    Dim sErr As String, fname As String
    fname = AskForFilename()
    If (fname = "") Then Exit Sub
    'Save.
    sErr = MySetupMetaImage(1, 1, 1)
    sErr = MyInsertTile(1, 1, 1)
    sErr = MySaveMetaImage(fname, CLng(CCOMPRESSION))
    sErr = MyDestroyMetaImage()
End Sub


Private Sub btnPhotoMultipleTiles_Click()
    '26 Aug 2004 CGL.
    'User wishes to photograph and save microarray.
    Dim sErr As String, fname As String
    Dim bAnalyze As Boolean, bSavePng As Boolean
    bAnalyze = True
    bSavePng = True
    fname = AskForFilename()
    If (fname = "") Then Exit Sub
    sErr = PhotoMultipleTiles(0, 0, bAnalyze, bSavePng, fname)  'Zero values indicate default values.
End Sub


Public Function PhotoMultipleTiles(ByVal iRows As Long, ByVal iCols As Long, _
    ByVal bAnalyze As Boolean, ByVal bSave As Boolean, ByVal fname As String) As String
    '27 Aug 2004 CGL
    'Photograph an area larger than the camera's field of view.
    'This metaimage is made of iRows x iCols image tiles.  Specify 0x0 for default values.
    'Optionally, analyze the features and/or save a PNG.
    Dim sErr As String          'Error return value. Use for all types: strings, longs, integers.
    Dim i As Long, j As Long    'Next tile.
    Dim i0 As Long, j0 As Long  'Last tile.
    Dim x As Long, y As Long    'feature indexes, single tile image.
    Dim x1 As Long, y1 As Long  'feature indexes, metaimage.
    Dim dx As Long, dy As Long, area As Long, quality As Long
    Dim mousept0
    
    'Check bounds of metaimage.
    If (iRows < 0 Or iRows > CMAXTILES Or iCols < 0 Or iCols > CMAXTILES) Then
        sErr = "Error in CameraForm.SnapAndSave: invalid parameter."
        ErrorMessage.Display sErr, 5
        SnapMultipleTiles = sErr
        Exit Function
    End If
    If (iRows = 0) Then iRows = TRows
    If (iCols = 0) Then iCols = TColumns
    
    'Allocate feature memory and image memory, if necessary.
    If bAnalyze Then ReDim features(GColumns * iCols, GRows * iRows)
    sErr = MySetupMetaImage(iRows, iCols, 1) 'Usually 4 rows, 2 col, 1 color.
    
    'Iterate through the tiles, moving and photographing.
    mousept0 = Screen.MousePointer
    Screen.MousePointer = vbHourglass
    For j = 0 To (iRows - 1)
        For i = 0 To (iCols - 1)
            sErr = PogoMain.MoveCameraTile(i - i0, -(j - j0))
            i0 = i: j0 = j
            Rem PogoMain.sw.Wait (0.01) 'Temporary--hope its not necessary.
            sErr = MyPhotographSpots()
            sErr = MySetRegion()
            sErr = MySetSpotFinderParameters()
            sErr = MyGridShown(True)
            sErr = MyShowSpots()
            'Insert this tile into metaimage, if necessary.
            If bSave Then sErr = MyInsertTile(j + 1, i + 1, 1)
            'Save these features to larger array called features.
            If bAnalyze Then
                For x = 1 To GColumns
                    For y = 1 To GRows
                        sErr = MyGetFeatureInfo(x, y, dx, dy, area, quality)
                        x1 = i * GColumns + x
                        y1 = j * GRows + y
                        features(x1, y1).dx = CInt(dx)
                        features(x1, y1).dy = CInt(dy)
                        features(x1, y1).area = CInt(area)
                        If (quality > 32767) Then quality = 32767
                        features(x1, y1).quality = CInt(quality)
                    Next y
                Next x
            End If
        Next i
    Next j
    sErr = PogoMain.MoveCameraTile(0 - i0, -(0 - j0))
    
    'Write the file, if necessary.  Close image viewer window.
    If bSave Then
        sErr = MySaveMetaImage(fname, CLng(CCOMPRESSION))
        sErr = MyDestroyMetaImage()
    End If
    sErr = MyCloseWindow()
    Screen.MousePointer = mousept0
    
ErrorHandler:
    'User clicked cancel button.
End Function


Public Function GetMetaFeature(ByVal x As Long, ByVal y As Long, _
    ByRef dx As Long, ByRef dy As Long, ByRef area As Long, ByRef quality As Long) As String
    '26 Aug 2004 CGL
    'Get feature information from the metaimage.  For example, the 36th feature
    'might be the first feature on the second tile.
    If (x < 1 Or x > FeaturesUboundX Or y < 1 Or y > FeaturesUboundY) Then
        GetMetaFeature = "Error in CameraForm.GetMetaFeature: array bound out of range."
        Exit Function
    End If
    dx = features(x, y).dx
    dy = features(x, y).dy
    area = features(x, y).area
    quality = features(x, y).quality
End Function

Public Function FeaturesUboundX() As Long
    '26 Aug 2004 CGL
    FeaturesUboundX = UBound(features, 1)
End Function

Public Function FeaturesUboundY() As Long
    '26 Aug 2004 CGL
    FeaturesUboundY = UBound(features, 2)
End Function


Private Sub btnMove_Click()
    '11 Aug 2004 CGL.
    'Move camera over selected slide.
    Dim sErr As String
    sErr = PogoMain.MoveCameraOverSlide(Int(Val(right(cmbWhere.Text, 2))), 0, 0)
End Sub


Property Let ButtonsEnabled(ByVal bEnabled As Boolean)
    '17 Nov 2004 CGL.
    'Activate or deactivate buttons on this form.
    For Each obj In CameraForm
        If (left(obj.Name, 3) = "btn") Then obj.Enabled = bEnabled
    Next
    CameraForm.Refresh
End Property
