VERSION 5.00
Begin VB.Form ErrorMessage 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Pogo Message"
   ClientHeight    =   2370
   ClientLeft      =   2760
   ClientTop       =   3750
   ClientWidth     =   6030
   ControlBox      =   0   'False
   Icon            =   "ErrorMessage.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2370
   ScaleWidth      =   6030
   ShowInTaskbar   =   0   'False
   Begin VB.CommandButton btnShutdown 
      Caption         =   "Exit Pogo"
      Height          =   375
      Left            =   4560
      TabIndex        =   4
      Top             =   120
      Width           =   1335
   End
   Begin VB.CommandButton btnStopProgram 
      Caption         =   "Stop Synthesis"
      Height          =   375
      Left            =   4560
      TabIndex        =   3
      Top             =   600
      Width           =   1335
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   1000
      Left            =   120
      Top             =   1320
   End
   Begin VB.CommandButton ContinueButton 
      Caption         =   "OK"
      Default         =   -1  'True
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   4560
      TabIndex        =   0
      Top             =   1680
      Width           =   1335
   End
   Begin VB.Label TimeoutLabel 
      Caption         =   "Press a button to continue or exit."
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   1920
      Width           =   4335
   End
   Begin VB.Label ErrorMessageLabel 
      Caption         =   "An error was encountered with the Inkjet Arrayer program."
      Height          =   1575
      Left            =   240
      TabIndex        =   1
      Top             =   240
      Width           =   4095
   End
End
Attribute VB_Name = "ErrorMessage"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'ErrorMessage form.
'20 Oct 2004
'Copyright
'C Lausted, Institute for Systems Biology
'
'This object allows Arrayer to display and log errors.
'It includes a Timeout feature that allows inkjet synthesis to
'continue if the error is not critical.  A Timeout of zero
'seconds means infinity, or no timeout, and to shut off dryer gas.
'Access error log filename with property "Filename."
'
'I will use btnStopProgram.Enabled = False to stop synthesis.
'
'Dependencies: ReagentsForm.
'//////////////////////////////////////////////////////////////////


Option Base 1

Const CMAXTIMEOUT As Single = 600

Private sglDuration As Single    'How long to show dialog box.
Private sglStart As Single       'Time that dialog box was shown.
Private sErrorLog As String      'Name of the error log file.
Private bDryerWasOn As Boolean   'Whether to turn inert gas back on after message.
Private sFilename As String      'Access this through property Filename.


Private Sub Form_Load()
    '18 Oct 2004 CGL.
    btnShutdown.Enabled = True
    btnStopProgram.Enabled = False
    sErrorLog = CERRORLOGNAME
    sFilename = CurDir & "\pogo-" & Format(Now, "yymmdd") & ".log"  'Default full filename.
End Sub


Public Sub Display(strMessage As String, sglTimeout As Single)
    'CGL 12 Jan 2004.
    'Use this sub like MsgBox, but with a timeout feature.
    'Show dialog box and prepare a timer.
    'Timer1 object is used to update status of my timer variables and display.
    Dim txt As String
    
    'Show error message on a modal dialog box.
    ErrorMessageLabel.Caption = strMessage
    
    'Setup timeout, if desired.
    'For no timeout, use zero or negative value.
    If (sglTimeout <= 0) Then sglTimeout = 0
    If (sglTimeout > CMAXTIMEOUT) Then sglTimeout = CMAXTIMEOUT
    bDryerWasOn = ReagentsForm.BoxDryerOn
    If sglTimeout > 0 Then
        'Setup timer.
        Timer1.Enabled = True
        sglStart = Timer
        sglDuration = sglTimeout
        txt = "This dialog box will timeout in " & Format(sglDuration, "0") & " seconds."
        TimeoutLabel.Caption = txt
        TimeoutLabel.Refresh
    Else
        'No timer needed.  Shut off dryer.
        Timer1.Enabled = False
        ReagentsForm.BoxDryerOn = False
    End If
    
    'Error log.
    ErrorMessage.Log (strMessage)
    
    'Show error message dialog box.
    If (ErrorMessage.Visible) Then Beep: Exit Sub 'Error: already shown.
    ErrorMessage.Show vbModal
End Sub


Public Sub Log(strMessage As String)
    '20 Oct 2004 CGL.
    'Append this message to the log file.
    'Use timestamp format like [Mon 041018 11:19:42] for morning of 14 October 2004.
    Dim fnum As Integer  'file number.
    fnum = FreeFile
    Open filename For Append As #fnum
    Print #fnum, ("[" & Format(Now, "ddd yymmdd hh:mm:ss") & "] " & strMessage)
    Close #fnum
End Sub



Private Sub Timer1_Timer()
    'CGL 12 Jan 2004.
    'Update the time remaining display text.
    'When time is up, click Continue for the user.
    Dim remain As Single
    Dim txt As String
    remain = sglStart + sglDuration - Timer
    txt = "This dialogbox will timeout in " & Format(remain, "0") & " seconds."
    TimeoutLabel.Caption = txt
    TimeoutLabel.Refresh
    If remain < 0 Then ContinueButton_Click
End Sub


Private Sub btnStopProgram_Click()
    'CGL 14 Oct 2004.
    'Stop execution of synthesis script but keep Pogo running.
    btnStopProgram.Enabled = False
    ContinueButton_Click
    ReagentsForm.BoxDryerOn = bDryerWasOn
End Sub


Private Sub ContinueButton_Click()
    'CGL 14 Oct 2004.
    'Restore the default messages on this dialog box.  Unimportant.
    ErrorMessageLabel.Caption = "An error was encountered with the Inkjet Arrayer program."
    TimeoutLabel.Caption = "Press a button to continue or exit."
    'Shut the timer off.
    Timer1.Enabled = False
    'Dismiss this box.
    ErrorMessage.Hide
    ReagentsForm.BoxDryerOn = bDryerWasOn
End Sub


Private Sub btnShutdown_Click()
    '23 June 2004 CGL.
    'Exit Pogo.
    Dim txt As String
    txt = "Are you sure that you really wish to exit Pogo?"
    If (MsgBox(txt, vbYesNo) = vbYes) Then Unload MainForm
End Sub


Property Let filename(ByVal newvalue As String)
    '18 Oct 2004 CGL
    'Check that the path exists before updating property.
    If (dir(PathFromFilename(newvalue), vbDirectory) = "") Then
        MsgBox "Invalid path or filename"
    Else
        sFilename = newvalue
    End If
End Property


Property Get filename() As String
    '18 Oct 2004 CGL.
    filename = sFilename
End Property


Private Function PathFromFilename(ByVal x As String) As String
    '18 Oct 2004 CGL.
    'Given "C:\mydir\myfile.log" return just "C:\mydir"
    Dim i As Integer
    For i = Len(x) To 1 Step -1
        If (Mid(x, i, 1) = "\") Then Exit For
    Next i
    i = i - 1
    PathFromFilename = left(x, i)
End Function
