VERSION 5.00
Begin VB.Form InkjetForm 
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   "Inkjet Printing"
   ClientHeight    =   4320
   ClientLeft      =   45
   ClientTop       =   285
   ClientWidth     =   9390
   ControlBox      =   0   'False
   Icon            =   "InkjetForm.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4320
   ScaleWidth      =   9390
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "Cancel Printing"
      Default         =   -1  'True
      Height          =   615
      Left            =   120
      TabIndex        =   1
      Top             =   600
      Width           =   1695
   End
   Begin VB.PictureBox pbxMain 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00404040&
      FillStyle       =   0  'Solid
      Height          =   2775
      Left            =   120
      MousePointer    =   2  'Cross
      ScaleHeight     =   181
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   605
      TabIndex        =   0
      Top             =   1440
      Width           =   9135
   End
   Begin VB.Label lblStatus 
      BackStyle       =   0  'Transparent
      Caption         =   "Idle."
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   615
      Left            =   2040
      TabIndex        =   3
      Top             =   600
      Width           =   7095
   End
   Begin VB.Label lblRow 
      BackStyle       =   0  'Transparent
      Caption         =   "lblRow: Printing Top Row (Slides 1..9)"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   120
      TabIndex        =   2
      Top             =   120
      Width           =   4095
   End
End
Attribute VB_Name = "InkjetForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'InkjetForm
'14 Feb 2005
'Copyright
'C Lausted, Institute for Systems Biology
'
'This form does the actual inkjet printing. It moves the servos and jets the piezo
'while graphically informing the user of the progress. Graphic scale is 0.5*0.5.
'Printing can be cancelled.
'
'Dependencies:  MainForm, PogoMain, ServoForm, SlideForm,
'               PogoDIO, PogoMIO, PogoMisc, ErrorMessage
'
'Usage:
'  InkjetForm.slideX(1..9) = AbsCoordinates
'  InkjetForm.slideY(1..3) = AbsCoordinates
'  InkjetForm.slideZ(1..9) = AbsCoordinates
'  InkjetForm.BankOffset(1..6) = RelCoordinates
'  sErr = InkjetForm.ApplyProperties()
'  sErr = InkjetForm.InkjetPrint(iSlide, iDown, sReagent, iDrops, bTestMode)
'
'Todo: Move to correct positions, return error so program can wash & reprint.
'      Figure out what's wrong with TwipsPerPixel.
'//////////////////////////////////////////////////////////////////////////////

Rem Option Base 1

'Constants
Private Const CPRINTVELOCITY As Double = 10  'Printing velocity appears to be < 2.1.
Private Const CTIMEOUT As Double = 90        'Maximum time allowed to do motion.
Private Const CHMARGIN As Long = 60          'Horizontal margin around display.
Private Const CVMARGIN As Long = 30          'Vertical margin around display.
Private Const CMAXPASSES As Integer = 30     'Quit printing after 30 printhead sweeps.
Private Const CFULLPRINT As Integer = -999   'Return code indicating all printing is done.
Private Const CFAILPRINT As Integer = -998   'Return code indicating too many nozzle failures.

'Globals.
Dim istat As Integer
Dim metaArray() As Integer                    'Combine all arrays in one row into meta array.
Dim metaArrayLeft As Integer                  'Leftmost column actually used in metaArray.
Dim metaArrayRight As Integer                 'Rightmost column actually used in metaArray.
Dim lLeftCol(CSLIDECOLS * CSLIDEROWS) As Long 'Location of left column of each array in meta array.
Dim iA140(CROWS) As Integer                   'Nozzles needed. Bit 6 means bank 6.
Dim iA32(CNOZZLES) As Integer                 'Nozzles available.  Bit 6 means bank 6.
Dim bCancelPrint As Boolean                   'Use to cancel printing in progress.
Dim lSlideX(CSLIDECOLS) As Long               'X coordinates of slides.
Dim lSlideY(CSLIDEROWS) As Long               'Y coordinates of slides.
Dim lSlideZ As Long                           'Z coordinate of slides.
Dim lBankOffset(CBANKS) As Long               'Relative X coordinates of pzt banks.
Dim iLastOffset As Integer                    'Offset is between iA32 and iA140.
Dim sw As Stopwatch


Private Sub Form_Load()
    '7 July 2004 CGL.
    'The initialization of this form is really done by ApplyProperties().
    Set sw = New Stopwatch
End Sub


Private Sub Form_Unload(iCancel As Integer)
    '20 Jan 2004 CGL.
    Set sw = Nothing
End Sub


Public Property Let SlideX(i As Integer, newvalue As Long)
    '7 July 2004
    lSlideX(i) = newvalue
End Property
Public Property Let SlideY(i As Integer, newvalue As Long)
    '7 July 2004
    lSlideY(i) = newvalue
End Property
Public Property Let SlideZ(newvalue As Long)
    '7 July 2004
    lSlideZ = newvalue
End Property
Public Property Let BankOffset(i As Integer, newvalue As Long)
    '7 July 2004
    lBankOffset(i) = newvalue
End Property


Public Function ApplyProperties() As String
    '7 July 2004 CGL.
    'Once all the properties of InkjetForm are set, call this function.
    Dim sErr As String
    Dim metacolumns As Long
    Static oldX1 As Long, oldX9 As Long
    
    'Check if redimensioning is necessary
    If (lSlideX(1) = oldX1) And (lSlideX(CSLIDECOLS) = oldX9) Then Exit Function
    oldX1 = lSlideX(1): oldX9 = lSlideX(CSLIDECOLS)
    
    'Dimension metaArray.
    'Start with number of spots that could fit between leftmost
    'and rightmost slides and add another 71.
    metacolumns = ((lSlideX(CSLIDECOLS) - lSlideX(1)) / CPITCH) + 1 + CCOLS
    If (metacolumns > CTARGETS) Then
        'If this is ever encountered, we can increase CTARGETS.
        sErr = "Error in InkjetForm.  Perhaps the slide holder is too wide."
        Rem ErrorMessage.Display sErr, 0
        metacolumns = CTARGETS
    End If
    ReDim metaArray(metacolumns, CROWS)
    metaArrayRight = 1            'This will be increased by CopyIntoMetaArray.
    metaArrayLeft = metacolumns   'This will be decreased by CopyIntoMetaArray.
    
    'Determine positions of each array in metaArray.
    For k = 1 To CSLIDECOLS
        For i = 0 To (CSLIDEROWS - 1)
            lLeftCol((i * CSLIDECOLS) + k) = ((lSlideX(k) - lSlideX(1)) / CPITCH) + 1
        Next i
    Next k
    
    'Dimension the display.
    pbxMain.ScaleMode = 3 'Pixel units.
    pbxMain.ScaleLeft = -CHMARGIN
    pbxMain.ScaleTop = -CVMARGIN
    pbxMain.ScaleWidth = (metacolumns + (2 * CHMARGIN))
    pbxMain.ScaleHeight = (CROWS + (2 * CVMARGIN))
    pbxMain.width = pbxMain.ScaleWidth * Screen.TwipsPerPixelX * 0.55  'Why 0.55 is unknown.
    pbxMain.Height = pbxMain.ScaleHeight * Screen.TwipsPerPixelY * 0.95 'Why 0.95 is unknown.
    pbxMain.DrawWidth = 2
    InkjetForm.width = pbxMain.width + (2 * pbxMain.left)
    InkjetForm.Height = pbxMain.Height + pbxMain.top + 400
    
    ApplyProperties = sErr
End Function


Private Sub cmdCancel_Click()
    '7 Feb 2005 CGL.
    bCancelPrint = True
    ServoForm.KillTriggersLoop
    ErrorMessage.Log "Printing cancelled by user."
    Beep
    Rem Hide
End Sub


Private Sub PushToStatus(txt As String, bScroll As Boolean)
    '27 Oct 2004 CGL.
    'Push this text into the status area of the form.
    'If bScroll=TRUE then scroll text vertically.
    If bScroll Then
        lblStatus.Caption = left((txt & vbCrLf & lblStatus.Caption), 100)
    Else
        lblStatus.Caption = txt
    End If
    lblStatus.Refresh
End Sub


Public Function InkjetPrint(ByVal iSlide As Integer, ByVal iDown As Integer, _
    ByVal sReagent As String, ByVal iDrops As Integer, ByVal bTestMode As Boolean) As String
    '18 Oct 2004 CGL.
    'Print iDown from one (iSlide) or all selected microarray slides.
    'iDown can be 1 to 100 for bases 1 to 100.
    'sReagent can be the symbol for a reagent bank (e.g. "X" for tetrazole, "Default" for bases).
    'iSlide is the slide number to print.  Zero means all slides.
    Dim i As Integer, j As Integer
    Dim iFirst As Integer  'Leftmost slide in row.
    Dim iLast As Integer   'Rightmost slide in row.
    Dim bRowUsed As Boolean
    Dim iCount As Integer  'Count how many slides printed
    Dim sErr As String
    Dim mousept0
    iLastOffset = 0        'This is used by BestOffset in choosing next offset.
    iCount = 0
    bCancelPrint = False
    sErr = ""
    
    'Show display.
    InkjetForm.Show 'vbModal
    mousept0 = Screen.MousePointer
    Screen.MousePointer = vbArrowHourglass
    
    'Print each row of slides
    PogoDIO.Drops = iDrops
    For i = 1 To CSLIDEROWS
        'Check if there are any slides in this row.
        bRowUsed = False
        iLast = 0
        iFirst = CSLIDEROWS * CSLIDECOLS
        'Step through all the slide numbers in this row.
        For j = ((i - 1) * CSLIDECOLS + 1) To (i * CSLIDECOLS)  'j=1..9, 10..18, 19..27
            'Determine if this is first or last slide used in the row.
            'This is the default mode where multiple slides are being printed.
            If (MainForm.btnSlide(j).Tag = "used") And (iSlide = 0) Then
                bRowUsed = True
                If (j < iFirst) Then iFirst = j
                If (j > iLast) Then iLast = j
                iCount = iCount + 1
            End If
            'Determine if only one slide is used and its in this row.
            If (j = iSlide) Then
                bRowUsed = True
                iFirst = j
                iLast = j
                iCount = 1
            End If
        Next j
        
        'If there's a slide in this row, print on this row of slides.
        If bRowUsed Then
            sErr = sErr & PrintOnSlideRow(i, iFirst, iLast, iDown, sReagent, bTestMode)
        End If
        
        'Check if printing cancelled by user.
        DoEvents
        If bCancelPrint Then
            sErr = sErr & "Printing cancelled by user. "
            Rem ErrorMessage.Display sErr, 0  'User gets opportunity to shut program/pogo down.
            Exit For
        End If
    Next i
    
    'Done.   Log results and hide.
    ErrorMessage.Log ("Finished printing down " & iDown & " on " & iCount & " slides.")
    If (bTestMode) Then sw.Wait (2)
    Screen.MousePointer = mousept0
    InkjetPrint = sErr
    InkjetForm.Hide
End Function


Private Function PrintOnSlideRow(iRow As Integer, iFirst As Integer, iLast As Integer, _
    iDown As Integer, sReagent As String, bTestMode As Boolean) As String
    '1 July 2004 CGL.
    'Print slides numbers iFirst to iLast which are chucked into row iRow.
    'iDown can be 1 to 100 for bases 1 to 100.
    'sReagent is the symbol for a reagent bank (e.g. "X" for tetrazole, "Default" for bases).
    Dim i As Integer, j As Integer, k As Integer
    Dim txt As String, sErr As String
    
    'Update caption.
    txt = "Printing one row (slides " & iFirst & " to " & iLast & ")"
    If iRow = 1 Then txt = Replace(txt, "one row", "top row")
    If iRow = 2 Then txt = Replace(txt, "one row", "middle row")
    If iRow = 3 Then txt = Replace(txt, "one row", "bottom row")
    lblRow.Caption = txt
    
    'Move data from active ("used") slides into metaArray.
    ClearMetaArray
    For k = iFirst To iLast
        If MainForm.btnSlide(k).Tag = "used" Then
            istat = CopyIntoMetaArray(k, iDown, sReagent)
        End If
    Next k
    istat = UpdateDisplay()
    
    'Calculate best offset.
    sErr = PrintSuperArray(iRow, (iFirst Mod CSLIDECOLS), bTestMode)
    PrintOnSlideRow = sErr
End Function


Private Function CopyIntoMetaArray(ByVal iSlide As Integer, _
    ByVal iDown As Integer, ByVal sReagent As String) As Integer
    '20 Jan 2004 CGL.
    'Copy down sDown from array MainForm.oSlide(iSlide) into metaArray.
    'iDown can be 1 to 100 for bases 1 to 100.
    'sReagent is the symbol for a reagent bank (e.g. "X" for tetrazole, "Default" for bases).
    Dim i As Integer, j As Integer, k As Integer
    Dim ii As Integer
    Dim iSym As Integer     'Integer ascii value of reagent symbol character.
    Dim oSlide As SlideForm 'Single DNA array slide object reference.
    Dim iCols As Integer    'Number of columns actually used in oSlide.
    Dim iRows As Integer    'Number of rows actually used in oSlide.
    Dim iDowns As Integer   'Number of downs actually used in oSlide.
    Dim iBank As Integer    'Reagent bank specified in oSlide.
    Dim iOneReagent As Integer  'If nonzero then this is the reagent bank specified by sDown.
    CopyIntoMetaArray = 0
    iOneReagent = 0
    
    'Error checking.
    If (iDown < 1) Or (iDown > CBASES) Then
        ErrorMessage.Display "Incorrect iDown in CopyIntoMetaArray.  Printing Down 1 instead.", 0
        iDown = 1
    End If
    
    'Does sReagent indicate we are printing bases (Default) or printing tetrazole?
    If (sReagent <> "Default") Then
        'Determine if sDown starts with a valid reagent symbol.
        iOneReagent = PogoMain.Sym2Bank(Asc(UCase(sReagent)))
        If (iOneReagent = 0) Then
            ErrorMessage.Display "Unidentified reagent symbol in InkjetForm.CopyIntoMetaArray.", 0
            CopyIntoMetaArray = 1
            Exit Function
        End If
    End If
    
    'Find out about dimensions of this array.  Does it have sDown-long sequences?
    Set oSlide = MainForm.GetSlide(iSlide)
    iCols = oSlide.iCols
    iRows = oSlide.iRows
    iDowns = oSlide.iDowns
    
    'Check that oligo sequence is not too long -- that sDown is less than 100.
    If (iDown > CBASES) Then
        ErrorMessage.Display "Error: Oligo sequence too long in InkjetForm.CopyIntoMetaArray.", 0
        CopyIntoMetaArray = 1
        Exit Function
    End If
    
    'We don't have to do anything if the specified down is beyond the longest oligo sequence.
    'TO DO:  Error in the next line?
    If (iDown > iDowns) Then Exit Function  'Exit with no error.
    
    'Move the data.
    For i = 1 To iCols
        ii = lLeftCol(iSlide) + i
        'Monitor the left & right limits of the array.
        If (ii > metaArrayRight) Then metaArrayRight = ii
        If (ii < metaArrayLeft) Then metaArrayLeft = ii
        For j = 1 To iRows
            'Determine the reagent/liquid channel.
            iSym = oSlide.FeatureElement(i, j, iDown)
            iBank = PogoMain.Sym2Bank(iSym)
            'Move the data.
            If (sReagent = "Default") Then 'Put the base specified into metaArray.
                metaArray(ii, j) = iBank
            ElseIf (iBank > 0) Then 'Put sReagent into metaArray.
                metaArray(ii, j) = iOneReagent
            End If
        Next j
    Next i
End Function


Sub ClearMetaArray()
    '13 July 2004
    'Reset all values in metaArray to zero.
    Dim i As Integer, j As Integer
    i = UBound(metaArray, 1)
    j = UBound(metaArray, 2)
    ReDim metaArray(i, j)
    metaArrayRight = 1  'This limit indicates metaArray is empty.
    metaArrayLeft = i   'This limit indicates metaArray is empty.
End Sub


Private Function UpdateDisplay() As Integer
    '18 Nov 2004 CGL.
    'Update display from iSlide section of metaArray.
    'Scale is 25% area (50% linear).  Mix the four spot colors to get the one pixel color.
    Dim i As Integer, j As Integer, k As Integer
    Dim lColor As Long
    UpdateDisplay = 0
    For k = 1 To CSLIDECOLS  'Changed 2 to 1.
        For i = 2 To CCOLS Step 2
            For j = 2 To CROWS Step 2  'Changed 1 to 2.
                lColor = MyColor(metaArray(lLeftCol(k) + i - 0, j - 0)) _
                    Or MyColor(metaArray(lLeftCol(k) + i - 1, j - 0)) _
                    Or MyColor(metaArray(lLeftCol(k) + i - 0, j - 1)) _
                    Or MyColor(metaArray(lLeftCol(k) + i - 1, j - 1))
                pbxMain.PSet (lLeftCol(k) + i, j), lColor
            Next j
        Next i
    Next k
    
    InkjetForm.Refresh
End Function


Private Function PrintSuperArray(iRow As Integer, iCol As Integer, _
    bTestMode As Boolean) As String
    '11 Feb 2005 CGL
    'Print a whole microarray or set of microarrays with more than 32 rows
    'by printing several subarrrays with <= 32 rows.
    'Start at slide row position iRow, slide column position iCol.
    Dim i As Integer, j As Integer
    Dim sErr As String                      'Error report from this function.
    Dim x As Long, y As Long, z As Long     'Slide coordinates.
    Dim offset As Integer                   'One unit is one inkjet row.
    Dim subArray() As Integer               'Subset of superarray.
    Dim bNozzleOnline As Boolean            'Does the nozzle over this iFeature work?
    Dim width As Long
    Dim cnt As Integer
    cnt = 0
    sErr = ""
    
    'Memory allocation
    width = metaArrayRight - metaArrayLeft + 2
    ReDim subArray(width, CNOZZLES) 'Variable width, 32 rows high.
    
    'Positioning.
    If (iRow < 1 Or iRow > CSLIDEROWS Or iCol < 1 Or iCol > CSLIDECOLS) Then
        sErr = "InkjetForm.PrintSuperArray error.  Variable iRow or iCol out of range."
        PrintSuperArray = sErr
        Exit Function
    End If
    x = lSlideX(iCol)  'The leftmost slide in this row.
    y = lSlideY(iRow)
    z = lSlideZ
    
    'Main loop. Exits when metaArray is empty or after ~15 passes.
    Do
        'Display progress.
        cnt = cnt + 1
        PushToStatus ("Print pass " & cnt), True
        
        'Find the best Y-axis offset to hit the most spots with the working nozzles.
        offset = BestOffset
        If offset = CFULLPRINT Then Exit Do  'Exit this loop! metaArray is empty.
        If offset = CFAILPRINT Then Exit Do  'Exit this loop! Too many nozzles failed.
        PushToStatus ("Offsetting printhead by " & offset & " rows."), True
        
        'Move contents of metaArray to subArray.
        For j = 1 To CNOZZLES
            For i = metaArrayLeft To metaArrayRight
                If ((j + offset) < 1) Or ((j + offset) > CROWS) Then
                    'Nozzle is not overtop array, nothing to print here.
                    subArray(i - (metaArrayLeft - 1), j) = 0
                Else
                    bNozzleOnline = MainForm.ctlPiezo192.Nozzle(metaArray(i, j + offset), j)
                    If (bNozzleOnline) Then
                        'Print here and remove the spot from the metaaray.
                        subArray(i - (metaArrayLeft - 1), j) = metaArray(i, j + offset)
                        metaArray(i, j + offset) = 0
                    Else
                        'Can't print here because nozzle is offline.
                        subArray(i - (metaArrayLeft - 1), j) = 0
                    End If
                End If
            Next i
        Next j
        
        'One pass of the print head.
        sErr = sErr & PrintSubArrayFast(x, (y - (offset * CPITCH)), z, subArray)
        UpdateDisplay
        If bCancelPrint Then Exit Do
        
        'Test mode delay.
        If (bTestMode) Then sw.Wait (1.5)
    Loop Until cnt > CMAXPASSES
    
    'Report any errors.
    If (cnt > CMAXPASSES) Or (offset = CFAILPRINT) Then
        sErr = sErr & "Printing abandonded after " & cnt & " passes." & vbCrLf
        Rem ErrorMessage.Display sErr, 0
    End If
    
    'Finish up.
    PushToStatus ("Idle."), False
    PrintSuperArray = sErr
End Function


Private Function BestOffset() As Integer
    '24 Jan 2004.
    'Find the best y-axis offset to print metaArray using working nozzles.
    'Look at all the ways the printhead can be vertically aligned overtop the array and
    'count how many rows can be completely printed.  Report the offset that prints the
    'most rows.  Y-axis displacement = offset * pitch.
    Dim i As Integer, j As Integer
    Dim iBestOffset As Integer
    Dim score As Double                'Score is based on count and position.
    Dim bestScore As Double            'Best score so far.
    Dim count As Integer               'Number of rows printed with this offset.
    Dim bestCount As Integer           'Number of rows printed, best so far.
    Dim result As Integer              'If perfect six banks hit 32 rows, result = 192.
    
    'Use iA32() to store working nozzles.  Bitwise.
    UpdateGoodNozzleArray
    'Use iA140() to summarize which banks are needed for each row.
    UpdateNeededNozzleArray
    
    'Check if any rows left to print.
    count = 0
    For i = LBound(iA140) To UBound(iA140)
        If (iA140(i) <> 0) Then count = count + 1
    Next i
    If (count = 0) Then BestOffset = CFULLPRINT: Exit Function
    
    'Loop through all possible offsets.
    For j = (1 - CNOZZLES) To (CROWS - 1) 'Offsets from -31 to 139.
        'Count how many rows * banks can be printed with each offset.
        count = 0
        For i = 0 To (CNOZZLES - 1)  'Nozzles 0 to 31.
            If ((j + i) >= 1) And ((j + i) <= CROWS) Then
                'With this offset, nozzle is over the array.
                result = CountBits(iA140(j + i) And iA32(i + 1))
            Else
                'Nozzle is not over the array.
                result = 0
            End If
            'Give credit to a row that can be jetted successfully.
           count = count + result
        Next i
        'Keep track of best count. Not used anymore. Use score now.
        If count > bestCount Then bestCount = count
        'Check if this is the best offset to use.
        'The offset range is -31..139, count range is about 1..128.
        score = count  'So far, simple is best.
        Rem score = ((140 - j) / 171) * count  'Tried 050209. NEW!!
        If (score > bestScore) Then
            bestScore = score
            iBestOffset = j - 1 'Yes, j-1 is correct.
        End If
    Next j
    
    'Return special code if unable to print a necessary row.
    iLastOffset = iBestOffset
    If bestCount = 0 Then iBestOffset = CFAILPRINT: iLastOffset = 0
    BestOffset = iBestOffset
End Function


Private Sub UpdateGoodNozzleArray()
    '26 Jan 2004.
    'Note which nozzles are working.  0x00111111=63=all.
    'Move data from remote ctlPiezo to local iA32().
    Dim i As Integer, j As Integer
    For j = 1 To CNOZZLES
        iA32(j) = 0
        For i = 1 To CBANKS
            If MainForm.ctlPiezo192.Nozzle(i, j) Then
                iA32(j) = SetBit(iA32(j), i - 1)
            End If
        Next i
    Next j
End Sub


Private Sub UpdateNeededNozzleArray()
    '26 Jan 2004.
    'Note which nozzles we need.   0x00111111=63=all.
    'Summarize data in metaArray() into iA140().
    Dim i As Integer      'First dimension, horizontal or column.
    Dim j As Integer      'Second dimension, vertical or row.
    Dim full As Integer   'Code for all nozzles needed.
    full = 2 ^ CBANKS - 1 '0x00111111=63=all.
    For j = 1 To UBound(metaArray, 2)
        iA140(j) = 0
        For i = 1 To UBound(metaArray, 1)
            iA140(j) = SetBit(iA140(j), (metaArray(i, j) - 1))
            If (iA140(j) = full) Then Exit For  'Break out to save time.  All nozzles needed.
            'TODO: Deal with redundant banks e.g. tetrazole in 1 & 2.
        Next i
    Next j
End Sub


Private Function SetBit(i As Integer, n As Integer) As Integer
    '26 Jan 2004.
    'Set the n-th bit of integer i to one.
    SetBit = i Or (2 ^ n)
End Function


Private Function ClearBit(i As Integer, n As Integer) As Integer
    '27 Oct 2004 CGL.
    'Set the n-th bit of integer i to zero.
    ClearBit = i And Not (2 ^ n)
End Function


Private Function CountBits(i As Integer) As Integer
    '27 Oct 2004 CGL.
    'Count how many bits are set to 1 in the number i.
    Dim j As Integer, cnt As Integer
    For j = 0 To 15
        If ((i And (2 ^ j)) > 0) Then cnt = cnt + 1
    Next j
    CountBits = cnt
End Function


Private Function PrintSubArrayFast(aX As Long, aY As Long, aZ As Long, theArray) As String
    '14 Feb 2005 CGL.
    'Print theArray starting at absolute position aX, aY, aZ.
    'This is the function that actually sets the triggers and moves the printhead!
    'It is CNOZZLES (32) rows by an arbitrary number of columns.
    'Use the fire-on-the-fly technique.
    Dim x As Integer, y As Integer
    Dim i As Integer, iErr As Integer
    Dim bTimeout As Boolean      'Break out of FOTF loop due to clock.
    Dim bFinished As Boolean     'Break out of FOTF loop due to DIO.
    Dim bStopped As Boolean      'Break out of FOTF due to Servo.
    Dim sErr As String           'Error message returned by this function.  Zero-length if none.
    Dim b As Integer             'Reagent bank number 1 to 6.
    Dim iOffset(CBANKS) As Long  'Relative positions of the six banks.  Multiples of CPITCH.
    Dim lWidth As Long           'Width between bank 1 and 6 in counts.
    Dim lMove As Long            'Distance printhead needs to move in this sweep.
    Dim noz As Integer           'Nozzle number 1 to 192.
    Dim state As Integer         'Nozzle on TRUE or off FALSE.
    Dim targ As Long             'Target 1 is bank 6 column 1; last target is bank 1 last column.
    Dim cnt As Long              'Number of triggers counted.
    Dim lFirstTrig As Long       'Position of first (leftmost) trigger.
    Dim theArrayW As Integer     'Number of columns in theArray.
    Dim targetsW As Integer      'theArrayW + (# columns between bank 1 & 6)
    Dim iMissed As Long
    Dim iTripped As Long
    Dim iRemain As Long
    Dim mousept0
    sErr = ""
    bTimeout = False
    bStopped = False
    bCancelPrint = False
    
    'Check for dimensioning errors.
    If (UBound(theArray, 2) <> CNOZZLES) Then
        sErr = "Error in InkjetForm.PrintSubArrayFast theArray()."
        Rem ErrorMessage.Display sErr, 0
        PrintSubArrayFast = sErr
        Exit Function
    End If
    
    'Check if user wants to cancel.
    DoEvents
    If bCancelPrint Then
        sErr = "Printing cancelled by user. "
        PrintSubArrayFast = sErr
        Exit Function
    End If
    
    'Initialize useful variables.
    iStatus = 0 'No error printing.
    theArrayW = UBound(theArray, 1) - LBound(theArray, 1)
    For i = 1 To CBANKS
        'This should give us 80, 72, 44, 36, 8, 0.
        iOffset(1 + CBANKS - i) = Int(lBankOffset(i) / CPITCH)
    Next i
    targetsW = theArrayW + iOffset(1) - iOffset(CBANKS)  'As little as 150.
    lWidth = Val(lBankOffset(CBANKS)) - Val(lBankOffset(1))
    mousept0 = Screen.MousePointer
    Screen.MousePointer = vbHourglass
    
    'Configure a big buffer of data to guide entirearray ink spewing.
    PogoDIO.InitFireOnFlyBuffer 'Set buffer zero values, clock pulses, latches.
    state = 1
    For x = 1 To theArrayW    '70 columns.  Used to be 32, then 50.
        For y = 1 To CNOZZLES '32 rows on current print head.
            'Determine the nozzle number from the bank and the row.
            b = theArray(x, y)
            If (b < 0) Then b = 0  'Unknown reagent; user has previously been warned.
            'Determine the target positions from the bank and the column.
            targ = x + iOffset(b)
            'Configure the big buffer to spew monomers.
            If (b >= 1 And b <= CBANKS And targ >= 1 And targ <= targetsW) Then
                PogoDIO.CfgFireOnFly b, y, targ, state
            End If
        Next y
    Next x
    
    'Move a little left of first trigger.
    iErr = ServoForm.MoveAbsolute((aX - (1.3 * lWidth)), aY, aZ)
    
    'Set trigger points in 6K4 and setup triggered digital output.
    lFirstTrig = (aX - lWidth)
    Rem iErr = ServoForm.SetTriggers(lFirstTrig, 5, targetsW * 56) 'Linear encoder.
    iErr = ServoForm.SetTriggers(lFirstTrig, CPITCH, targetsW)
    
    PushToStatus ("Trigger at " & lFirstTrig & " starting from " & (aX - (1.3 * lWidth))), True
    If (iErr <> 0) Then
        sErr = "ServoForm.SetTriggers()."
        PrintSubArrayFast = sErr
        Exit Function
    End If
    
    PogoMIO.ConfigureCounters
    sErr = PogoDIO.CfgPGOutput(targetsW)
    If (sErr <> "") Then PrintSubArrayFast = sErr: Exit Function
    
    'Now start motion right.
    sw.Reset
    Rem ServoForm.SetVelocityX (CPRINTVELOCITY)
    ServoForm.SetVelocityX (2.9) 'Speed tested to 10.9 on 6k triggering.  Keep it slower for accuracy.
    lMove = (CLng(theArrayW) * CPITCH) + (1.6 * lWidth) 'Use 1.5*lWidth.
    iErr = ServoForm.MoveRelativeNoWait(lMove, 0, 0)
    
    'The critical jetting loop.
    Do
        'Update the display and check allow cancel for button.
        cnt = ServoForm.TriggersTripped
        iRemain = PogoDIO.PGRemaining
        PushToStatus ("Trigger #" & cnt & " Remaining " & iRemain), False
        DoEvents
        'See if we're done.
        bTimeout = sw.Elapsed(CTIMEOUT)
        bFinished = PogoDIO.HasBeenTriggered
        Rem bStopped = ServoForm.TriggeringDone
    Loop Until bFinished Or bTimeout Or bStopped Or bCancelPrint
    If bTimeout Then sErr = sErr & "Timeout in InkjetForm.PrintSubArrayFast."
    
    'Return to normal velocity and end triggering.
    ServoForm.WaitForMotionStop
    ServoForm.SetVelocityX (0)
    ServoForm.EndTriggering
    PogoDIO.EndTriggeredOutput
    PogoMIO.ResetCounters 'Or put this in destructor?
    'Temporary debugging file.
    Rem PogoDIO.DebugFireOnFlyBuffer
    
    'Check for errors
    iMissed = ServoForm.TriggersMissed
    If (iMissed > 0) Then sErr = sErr & "Error in MainFrm.PrintArrayFast. " & iMissed & " triggers missed." & vbCrLf
    iTripped = ServoForm.TriggersTripped
    If (iTripped < targetsW) Then sErr = sErr & "Error in MainFrm.PrintArrayFast. Only " & iTripped & " triggers tripped." & vbCrLf
    
    If (Len(sErr) > 0) Then
        'We wish for program to continue after these errors if user does not object.
        Rem iErr = ServoForm.MoveRelative(0, 20000, 40000)
        ErrorMessage.Display sErr, 10
        PrintSubArrayFast = sErr
    End If
    
    'Finish up.
    Screen.MousePointer = mousept0
End Function


