VERSION 5.00
Begin VB.Form PogoDIO 
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   "Pogo PCI-DIO-32HS"
   ClientHeight    =   1395
   ClientLeft      =   45
   ClientTop       =   285
   ClientWidth     =   2550
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   1395
   ScaleWidth      =   2550
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton btnClose 
      Caption         =   "Close"
      Default         =   -1  'True
      Height          =   375
      Left            =   600
      TabIndex        =   0
      Top             =   840
      Width           =   1215
   End
   Begin VB.Label Label9 
      BackStyle       =   0  'Transparent
      Caption         =   "This panel is for testing purposes only"
      ForeColor       =   &H00FF0000&
      Height          =   735
      Left            =   120
      TabIndex        =   1
      Top             =   120
      Width           =   2295
   End
End
Attribute VB_Name = "PogoDIO"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'PogoDIO class/form.
'14 Feb 2005
'Copyright
'C Lausted, Institute for Systems Biology
'
'This has the functionality that the Inkjet and Solenoids classes
'provided to Arrayer* and Lombardi*.
'Access to the National Instruments DIO board.
'Used for on-demand inkjetting, triggered inkjetting, and
'dispensing reagents with the teflon solenoids.
'
'With fire-on-the-fly, we can spew up to 14 droplets in rapid succession.
'Remember that nozzle number 1 is the BOTTOM one (row 32).
'
'Dependencies: ErrorMessage, Stopwatch, PogoNidaq.
'////////////////////////////////////////////////////////////////////////

Option Base 1


'Static port output constants.
Private Const INPUTPRT As Integer = 0
Private Const OUTPUTPRT As Integer = 1
Private Const NOHSHAKE As Integer = 0
Private Const LO As Integer = 0
Private Const HI As Integer = 1
Private Const SOLENOIDPORT As Integer = 1 'Port B.
Private Const MUXSTATE As Integer = 0 'Solenoid zero selected, pulldown resisters on Mux.
'Port group and patterned output constants
Private Const GROUP As Integer = 1 'There can be two groups of IO ports.
Private Const GROUPSIZE As Integer = 2 'Two ports or 16 bits.
Private Const GROUPPORTS As Integer = 2 'Ports C and D are in group 1.
Private Const ENABLEPG As Integer = 1 'Enable pattern generation using request-edge latching.
Private Const DISABLEPG As Integer = 0
Private Const REQSOURCEINTCLK As Integer = 0 'Internal clock.
Private Const REQSOURCEAUTO As Integer = 2 'Internal clock.
Private Const TIMEBASE As Integer = -3 '50ns clock.
Private Const REQINTERVALFAST As Integer = 20 'Make interval 1 microseconds or 1MHz.
Private Const REQINTERVALSLOW As Integer = 2000 'Make interval 100 microseconds or 10kHz.
Private Const EXTERNALGATE As Integer = 0 'Never used.
'Epson interface constants.
Private Const LAT As Integer = 256
Private Const CLK As Integer = 512
Private Const SG1 As Integer = 1024
Private Const SG2 As Integer = 2048
Private Const SG3 As Integer = 4096
Private Const NCHG As Integer = 8192
'Fire-on-the-fly printing.
'E.g. 350 ticks per count, 56 counts per spew target, 149 spews per slide.
Private Const CLTARGETS As Long = CTARGETS         '1249 from PogoMain.
Private Const CMAXDROPS As Integer = 5             'NEW: Maximum number of drops for FOTF printing.  We will use <1000 clock pulses.  70us/pulse * 14pulses < 1000.
Private Const CMAXSPEW As Long = 500               'Maximum number of drops spewed while stopped.
Private Const CSMALLSIZE As Long = 100 * CMAXSPEW
Private Const TPCOUNTLE As Long = 350    'Ticks/count with LinEnc. 5 drops * 70us.
Private Const TPCOUNT6K As Long = 350    'Ticks/count with 6k. 5 drops * 70us.
Private Const CPSPEWLE As Long = 56     'Counts/spew with LinEnc = 280um/5um.
Private Const CPSPEW6K As Long = 2      'Counts/spew with 6k = 282um/141um.
Private Const LINENC As Boolean = False 'No linear encoder connected.

'Misc global variables.
Public bTest As Boolean                      'Test/simulation mode that requires no special hardware.
Private dev As Integer                       'Device number for DIO32-HS.
Private stat As Integer                      'General use error codes.
Private dTrpz(49) As Double                  'Modified trapezoidal waveform in Volts.
'Untriggered printing variables and arrays.
Private bNozzle(CBANKS, CNOZZLES) As Boolean 'Which nozzles are on.
Private wBuffer(CSMALLSIZE) As Integer       'Buffer full of trapezoidal waveforms.
Private iDrops As Integer                    'Access via Property Drops. Number of drops to fire-on-the-fly.
Private sw As Stopwatch                      'A stopwatch.
'FOTF printing variables and arrays.
Private lSimTicks As Long               'Test mode. How many clock cycles were requested.
Private lSimTickCount As Long               'Test mode. How many clock cycles have elapsed.
Private lTPCount As Long                'Ticks/count.
Private lCPSpew As Long                 'Counts/spew.
Private lTPSpew As Long                 'Ticks/spew.
Private lSizeBufFOTF As Long            'Size of iBufFOTF.
Private iBufFOTF() As Integer           'Bif buffer for FOTF printing. Access with property.



'Object constructor.
Private Sub Form_Load()
    '10 Feb 2005 CGL.
    'Create a stopwatch, setup IO ports, define pzt waveforms.
    'Allow user to run this in test mode if there are errors.
    Dim i As Long, j As Long
    Dim sErr As String
    sErr = ""
    Set sw = New Stopwatch
    bTest = False  'At first we assume not test mode.
    Drops = 1     'Default number of drops to spew FOTF is one.
    
    'Use error handler to offer user the test mode option.
    On Error GoTo ErrorHandler
    
    'Get the device number and initialize this board.
    dev = InitializeDIO()
    If (dev = -1) Then
        sErr = "Pogo was unable to find the high-speed DIO board." & vbCrLf
        GoTo ErrorHandler
    End If
    
    'Setup solenoid stuff
    'Check if solendoid control hardware (with mux board) present.
    stat = DIG_Prt_Config(dev, SOLENOIDPORT, NOHSHAKE, INPUTPRT)
    If (stat <> 0) Then sErr = sErr & "Port config error:" & NICode(stat) & vbCrLf
    stat = DIG_In_Prt(dev, SOLENOIDPORT, pattern)
    If (stat <> 0) Then sErr = sErr & "Port input error:" & NICode(stat) & vbCrLf
    If (pattern <> MUXSTATE) Then sErr = sErr & "No solenoid multiplex board attached to DIO." & vbCrLf
    'Configure an output port to control solenoids.
    stat = DIG_Prt_Config(dev, SOLENOIDPORT, NOHSHAKE, OUTPUTPRT)
    If (stat <> 0) Then sErr = sErr & "Port config error:" & NICode(stat) & vbCrLf
    'Solenoid zero selected so all seven real solenoids are off.
    stat = DIG_Out_Prt(dev, SOLENOIDPORT, MUXSTATE)
    If (stat <> 0) Then sErr = sErr & "Port output error:" & NICode(stat) & vbCrLf
    
    'Setup inkjet stuff
    'No RTSI bus communication between NI boards until needed.
    'Assign 16bit group, from 8bit ports C&D.
    AssignGroup
    'Turn all nozzles off.
    NozzlesAllOff
    'Load buffers with pzt waveform.
    DefineWaveforms
    
    If (Len(sErr) = 0) Then Exit Sub
ErrorHandler:
    'Log errors.
    'Previously, asked users if they wish to continue in test/simulation mode.
    'Now, assume use wants to continue.  Can quit later.
    sErr = sErr & "Pogo is unable to use the high-speed DIO board. "
    ErrorMessage.Log (sErr)
    bTest = True
End Sub


'Object destructor.
Private Sub Form_Unload(iCancel As Integer)
    '10 Feb 2005 CGL.
    Set sw = Nothing
    If bTest Then Exit Sub
    'Return DIO32-HS to default settings.
    dev = InitializeDIO()
End Sub


Private Sub btnClose_Click()
    '7 Sept 2004 CGL.
    Hide
End Sub


Private Function InitializeDIO() As Integer
    '10 Feb 2005 CGL
    'Initialize the DIO32-HS with default settings.
    'Automatically detect the device number.  Return -1 if not found.
    Const pci_dio32_hs As Integer = 211
    Dim devNumber As Integer, devCode As Integer
    InitializeDIO = -1
    
    'Try eight possible device numbers.
    For devNumber = 0 To 7
        stat = Init_DA_Brds(devNumber, devCode)
        If (devCode = pci_dio32_hs) Then InitializeDIO = devNumber
    Next devNumber
End Function


Property Get MAXDROPS() As Integer
    '28 July 2004 CGL.
    'The maximum number of drops that can be printed FOTF needs to be public.
    MAXDROPS = CMAXDROPS
End Property


Private Sub DefineWaveforms()
    '7 Feb 2005 CGL.
    'Load wBuffer, wBufferBig, and wBufferTemp with piezojetting waveforms.
    Dim i As Long, j As Long, k As Long
    Dim trpz As Variant 'Modified trapezoidal waveform. Arbitrary units.
    
    'Define waveform and convert it to voltage units.
    trpz = Array(0, 5, 10, 15, 20, 23, 24, 25, 25, 25, 25, 27, 27, 27, 27, 27, _
        26, 25, 24, 22, 20, 18, 16, 14, 12, 10, 8, 6, 4, 2, 1, 0.5, 0, 0, 0, 0, _
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
    For i = 1 To 49
        dTrpz(i) = Int(trpz(i) * 255 / 30) '8 bits, 30 volts fs.
    Next i
        
    'Load buffer with pzt waveform.  This is used for startnstop printing.
    For j = 1 To (CSMALLSIZE - 49) Step 100
        For i = 1 To 49
            wBuffer(j + i) = dTrpz(i) '8 bits, 30 volts fs.
        Next i
    Next j
    
End Sub


Property Let BufFOTF(lSpew As Long, lCount As Long, lTick As Long, newvalue As Integer)
    '8 Feb 2005 CGL.
    'Use globals lTPSpew and lTPCount to index global array iBufFOTF.
    'This should be fast so perhaps we will skip the bounds checking.
    iBufFOTF((lSpew * lTPSpew) + (lCount * lTPCount) + lTick) = newvalue
End Property
Property Get BufFOTF(lSpew As Long, lCount As Long, lTick As Long) As Integer
    '8 Feb 2005 CGL.
    BufFOTF = iBufFOTF((lSpew * lTPSpew) + (lCount * lTPCount) + lTick)
End Property


Private Sub AssignGroup()
    '16 Jan 2004 CGL.
    'Reassign group, grouping together ports C&D.
    If bTest Then Exit Sub
    stat = DIG_Block_Clear(dev, GROUP)
    'Unassign group.
    stat = DIG_Grp_Config(dev, GROUP, 0, GROUPPORTS, OUTPUTPRT)
    If (stat <> 0 And stat <> -10412) Then ErrorMessage.Display ("DIG_Grp_Config error:" & NICode(stat)), 15
    'Assign group, ports C&D.
    stat = DIG_Grp_Config(dev, GROUP, GROUPSIZE, GROUPPORTS, OUTPUTPRT)
    If (stat <> 0) Then ErrorMessage.Display ("DIG_Grp_Config error:" & NICode(stat)), 15
    'Set port to 0000.
    stat = DIG_Out_Grp(dev, GROUP, 0)
    If (stat <> 0) Then ErrorMessage.Display ("DIG_Out_Grp error:" & NICode(stat)), 15
End Sub


'---------------------------------------------
'Subroutines used for Start and Stop Printing.
'---------------------------------------------

Private Function SelectPztJets() As String
    '10 Feb 2005 CGL.
    'This sub selects the nozzles to be used, but doesn't actually spew.
    'This sub called at beginning of Spew sub.
    'Jets 1-32: Black;  33-64: Dark Cyan.
    'Jets 65-96: Light Cyan;  97-128: Dark Magenta.
    'Jets 129-160: Light Magenta;  161-192: Yellow.
    Dim i As Integer, j As Integer, pulse As Integer
    Dim cnt As Long, remaining As Long
    Dim buffer(500) As Integer
    Dim sErr As String
    
    If bTest Then Exit Function
    
    'Load a buffer with the digital output that selects nozzles.
    cnt = 1
    buffer(cnt) = NCHG: cnt = cnt + 1
    Rem stat = DIG_Out_Grp(dev, GROUP, 0)
    For i = 1 To 64
        'Convert 6x32 nozzles into 3x64 nozzles.
        If (i <= 32) Then
            pulse = (bNozzle(1, i) * SG1 * -1) + _
                (bNozzle(3, i) * SG2 * -1) + _
                (bNozzle(5, i) * SG3 * -1)
        Else
            pulse = (bNozzle(2, i - 32) * SG1 * -1) + _
                (bNozzle(4, i - 32) * SG2 * -1) + _
                (bNozzle(6, i - 32) * SG3 * -1)
        End If
        buffer(cnt) = pulse: cnt = cnt + 1
        buffer(cnt) = pulse + CLK: cnt = cnt + 1
        buffer(cnt) = 0: cnt = cnt + 1
    Next i
    buffer(cnt) = LAT: cnt = cnt + 1
    buffer(cnt) = 0
        
    'Enable pattern generation.
    AssignGroup
    stat = DIG_Block_PG_Config(dev, GROUP, ENABLEPG, REQSOURCEINTCLK, TIMEBASE, _
        REQINTERVALSLOW, EXTERNALGATE)
    If (stat <> 0) Then sErr = sErr & "DIG_Block_PG_Config error: " & NICode(stat)
    
    'Send the digital output pattern that selects the jets.
    stat = DIG_Block_Out(dev, GROUP, buffer(1), cnt)
    If (stat <> 0) Then sErr = sErr & "DIG_Block_Out error: " & NICode(stat)
    
    'Wait until the jets are all set.
    sw.Reset
    Do
        stat = DIG_Block_Check(dev, GROUP, remaining)
        If (stat <> 0) Then
            sErr = sErr & "DIG_Block_Check error:" & NICode(stat)
            Exit Do
        End If
        If sw.Elapsed(1) Then
            sErr = sErr & "Timeout waiting for digital output."
            Exit Do
        End If
    Loop Until (remaining = 0)
    SelectPztJets = sErr
End Function


Public Function Spew(ByVal Drops As Integer) As String
    '10 Feb 2005 CGL.
    'Output piezo drive waveform.
    'Use globals wBuffer, mboolNozzle.
    Dim count As Long, remaining As Long
    Dim i As Long, j As Long
    Dim sErr As String
    
    If bTest Then Exit Function
    sErr = SelectPztJets
    If Drops < 1 Then Exit Function
    If Drops > CMAXSPEW Then Drops = CMAXSPEW
    count = 100 * CLng(Drops)
    
    'Enable pattern generation.
    AssignGroup
    stat = DIG_Block_PG_Config(dev, GROUP, ENABLEPG, REQSOURCEINTCLK, TIMEBASE, _
        REQINTERVALFAST, EXTERNALGATE)
    If (stat <> 0) Then sErr = sErr & "DIG_Block_PG_Config error:" & NICode(stat)
    
    'Start the spewing.
    stat = DIG_Block_Out(dev, GROUP, wBuffer(1), count)
    If (stat <> 0) Then sErr = sErr & "DIG_Block_Out error:" & NICode(stat)
    
    'Wait until spewing is finished.
    sw.Reset
    Do
        stat = DIG_Block_Check(dev, GROUP, remaining)
        If (stat <> 0) Then
            sErr = sErr & "DIG_Block_Check error:" & NICode(stat)
            Exit Do
        End If
        If sw.Elapsed(1) Then
            sErr = sErr & "Timeout waiting for digital output."
            Exit Do
        End If
    Loop Until (remaining = 0)
    
    'Report errors.
    If (sErr <> "") Then ErrorMessage.Display ("PogoDIO.Spew error: " & sErr), 15
    Spew = sErr
End Function


Public Sub NozzlesAllOff()
    '6 Feb 2004 CGL.
    'Set bNozzles(6,32) all false.
    Dim i As Integer, j As Integer
    For i = 1 To CBANKS
        For j = 1 To CNOZZLES
            bNozzle(i, j) = False
        Next j
    Next i
End Sub

Public Sub NozzlesAllOn()
    '25 Oct 2004 CGL.
    'Set bNozzles(6,32) all true.
    Dim i As Integer, j As Integer
    For i = 1 To CBANKS
        For j = 1 To CNOZZLES
            bNozzle(i, j) = True
        Next j
    Next i
End Sub


Property Get Nozzle(ByVal iBank As Integer, ByVal iNozzle As Integer) As Boolean
    '6 Feb 2004 CGL.
    'Check if a single nozzle is on or off.
    'Flip the array upside down because the 32nd nozzle is towards
    'the top of the slide, the 1st is towards the bottom.
    If (iBank < 1) Or (iBank > CBANKS) Then Exit Property
    If (iNozzle < 1) Or (iNozzle > CNOZZLES) Then Exit Property
    iNozzle = (1 + CNOZZLES - iNozzle)
    Nozzle = bNozzle(iBank, iNozzle)
End Property


Property Let Nozzle(ByVal iBank As Integer, ByVal iNozzle As Integer, ByVal value As Boolean)
    '6 Feb 2004 CGL.
    'Turn a single nozzle on or off.
    'Flip the array upside down because the 32nd nozzle is towards
    'the top of the slide, the 1st is towards the bottom.
    If (iBank < 1) Or (iBank > CBANKS) Then Exit Property
    If (iNozzle < 1) Or (iNozzle > CNOZZLES) Then Exit Property
    iNozzle = (1 + CNOZZLES - iNozzle)
    bNozzle(iBank, iNozzle) = value
End Property




'-------------------------------------
'Subroutines used for Fire on the Fly.
'-------------------------------------

Public Property Get Drops() As Integer
    '27 July 2004 CGL
    'Number of drops spewed during fire-on-the-fly. Use global variable iDrops.
    Drops = iDrops
End Property
Public Property Let Drops(ByVal newvalue As Integer)
    If (newvalue < 1) Then newvalue = 1
    If (newvalue > CMAXDROPS) Then newvalue = CMAXDROPS
    iDrops = newvalue
End Property


Public Sub DebugFireOnFlyBuffer()
    '7 Feb 2005 CGL.
    'This is for testing only and is not called anywhere.
    Dim FN As Variant, i As Long
    FN = FreeFile
    Open "c:\iBufFOTF.txt" For Output As #FN
    For i = 1 To 999000
        Print #1, i, iBufFOTF(i)
    Next i
    Close #FN
End Sub


Public Sub InitFireOnFlyBuffer()
    '11 Feb 2005 CGL.
    'Load buffer with pzt waveform and with clock & latch pulses.
    Dim i As Long, j As Long, k As Long
    
    'Load buffer with pzt waveform.
    '33cm -> 66,000 lin enc cnts.  350 ticks per lin enc cnt.
    'Config targ 1 at 00351..00700; spew 1 at 00701..01050; spew 2 at 01051-1400 (opt).
    'Config targ 2 at 19951..20300; spew 2 at 20301..20650.
    If LINENC Then
        lTPCount = TPCOUNTLE: lCPSpew = CPSPEWLE
    Else
        lTPCount = TPCOUNT6K: lCPSpew = CPSPEW6K
    End If
    lTPSpew = lTPCount * lCPSpew         'Calc Ticks/spew e.g. 56*350=19600.
    lSizeBufFOTF = lTPSpew * CLTARGETS   'Calc Size of iBufFOTF e.g. 19600*1249=24million.
    ReDim iBufFOTF(lSizeBufFOTF)         'Dimension and zero dynamic array.  Big.
    
    For i = 1 To (CLTARGETS - 1)
        For j = 1 To 49
            'Number of drops (pulses) can be from 1 to 5. Get from Drops property.
            'They are 70us apart since 1000000/14400 = 70.
            For k = 0 To (Drops - 1)
                BufFOTF(i, 1, (j + (k * 70))) = dTrpz(j)
            Next k
        Next j
    Next i
    
    'Insert clock and latch pulses into wBufferBig.
    For i = 1 To (CLTARGETS - 1)
        For j = 0 To 252 Step 4
            Rem BufFOTF(i, 0, (j + 1)) = 0
            Rem BufFOTF(i, 0, (j + 2)) = 0
            BufFOTF(i, 0, (j + 3)) = CLK
            Rem BufFOTF(i, 0, (j + 4)) = 0
        Next j
        BufFOTF(i, 0, 258) = LAT
    Next i
End Sub


Public Sub CfgFireOnFly(ByVal bank As Integer, ByVal noz As Integer, _
    ByVal targ As Long, ByVal state As Integer)
    '9 Feb 2005 CGL.
    'Configure nozzles and timing for fire on the fly.
    'Configuration means loading the global wBufferBig.
    ''targ is target x-position number from 1..150, where 81..150 are array columns 1..70 for Bank 6.
    ''state is 1 on or 0 off.
    'Bank6 over top column1 of microarray is targ 1.
    'Bank1 over top column70 of microarray is targ 150.
    'TODO: check if we clear this configuration out before next print down.
    Dim sErr As String
    
    'Error checking
    If (bank < 1 Or bank > CBANKS) Then sErr = sErr & "Error in PogoDIO.CfgFireOnFly: bank parameter invalid."
    If (noz < 1 Or noz > CNOZZLES) Then sErr = sErr & "Error in PogoDIO.CfgFireOnFly: noz parameter invalid."
    If (state < 0 Or state > 1) Then sErr = sErr & "Error in PogoDIO.CfgFireOnFly: state parameter invalid."
    If (targ < 1 Or targ > CTARGETS) Then sErr = sErr & "Error in PogoDIO.CfgFireOnFly: targ parameter invalid."
    If (Len(sErr) > 0) Then ErrorMessage.Display sErr, 0: Exit Sub
    
    'Load a buffer with the digital output that selects nozzles.
    If (bank = 1 Or bank = 2) Then state = state * SG1
    If (bank = 3 Or bank = 4) Then state = state * SG2
    If (bank = 5 Or bank = 6) Then state = state * SG3
    If (bank = 1 Or bank = 3 Or bank = 5) Then
        noz = CNOZZLES - noz  'Flip upside down using 32-noz.
    Else
        noz = CNOZZLES + CNOZZLES - noz 'Flip using 64-noz
    End If
    noz = noz * 4
    
    Rem BufFOTF(targ, 0, (noz + 1)) = 0
    BufFOTF(targ, 0, (noz + 2)) = (state Or BufFOTF(targ, 0, (noz + 2)))
    BufFOTF(targ, 0, (noz + 3)) = (state Or BufFOTF(targ, 0, (noz + 3)))
    Rem BufFOTF(targ, 0, (noz + 4)) = 0
End Sub


Public Function CfgPGOutput(ByVal lTargets As Long) As String
    '14 Feb 2005 CGL.
    'Use this after using CfgFireOnFly.
    'Set the trigger,
    'Enable pattern generation.
    Const SignalACK1 As Integer = 2         'Signal ACK1/STARTTRIG1.
    Const TrigRTSI0 As Integer = 0          'Trigger line RTSI #0.
    Const DirTransmitToRTSI As Integer = 1  'Output to RTSI.
    Const SignalREQ1 As Integer = 0         'Signal REQ1.
    Const TrigRTSI3 As Integer = 3          'Trigger line RTSI #3.
    Const DirTakeFromRTSI As Integer = 0    'Input from RTSI.
    Const ReqSourceExt As Integer = 1       'Use REQ1 for PG clocking (from RTSI3).
    Const ReqIntNA As Integer = 1           'REQ interval not applicable here.
    Const ExtGateNA As Integer = 0          'External gating not applicable here.
    Const TimeBaseNA As Integer = 0         'Timebase not applicable here.
    Dim count As Long
    
    'Error checking
    count = lTargets * lTPSpew
    If (count > lSizeBufFOTF) Then CfgPGOutput = "ServoForm.CfgPGOutput: lTargets too large.": Exit Function
    
    'Handle Test mode.
    lSimTickCount = 0                'Reset simulated clock counter.
    lSimTicks = count                'Remember how many targets were requested.
    If bTest Then Exit Function
    
    'Specify the RTSI connections between NI boards.
    stat = RTSI_Clear(dev)
    'Transmit 6k trigger (wired to ACK1) to MIO via RTSI#0.
    stat = RTSI_Conn(dev, SignalACK1, TrigRTSI0, DirTransmitToRTSI)
    If (stat <> 0) Then CfgPGOutput = "Error configuring RTSI#0 with RTSI_Conn" & NICode(stat): Exit Function
    'Receive clock from MIO.
    stat = RTSI_Conn(dev, SignalREQ1, TrigRTSI3, DirTakeFromRTSI)
    If (stat <> 0) Then CfgPGOutput = "Error configuring RTSI#3 with RTSI_Conn" & NICode(stat): Exit Function
    
    'Configure Pattern-Generation digital output.
    AssignGroup  'The next line will err if we leave this line out.
    stat = DIG_Block_PG_Config(dev, GROUP, ENABLEPG, ReqSourceExt, TimeBaseNA, _
        ReqIntNA, ExtGateNA)
    If (stat <> 0) Then CfgPGOutput = ("DIG_Block_PG_Config error:" & NICode(stat)): Exit Function
    
    'Start the spewing.
    stat = DIG_Block_Out(dev, GROUP, iBufFOTF(1), count)
    If (stat <> 0) Then CfgPGOutput = ("DIG_Block_Out error:" & NICode(stat)): Exit Function
    
    CfgPGOutput = ""
End Function


Public Function HasBeenTriggered() As Boolean
    '14 Feb 2005 CGL.
    'Has the highspeed digital output been triggered and completed.
    Dim remaining As Long
    'Test mode answer.
    If bTest Then
        sw.Wait (0.005)
        lSimTickCount = lSimTickCount + lTPSpew
        HasBeenTriggered = (lSimTickCount >= lSimTicks)
        Exit Function
    End If
    'Real answer.
    stat = DIG_Block_Check(dev, GROUP, remaining)
    'If (stat <> 0) Then ErrorMessage.Display ("Triggered DIG_Block_Check error:" & NICode(stat)), 5
    HasBeenTriggered = Not (remaining > 0)
End Function


Public Function PGRemaining() As Long
    '14 Feb 2005 CGL.
    'How many ticks remaining in Pattern Generation output.
    Dim remaining As Long
    'Test mode answer.
    If bTest Then
        sw.Wait (0.005)
        lSimTickCount = lSimTickCount + lTPSpew
        PGRemaining = (lSimTicks - lSimTickCount)
        Exit Function
    End If
    'Real answer.
    stat = DIG_Block_Check(dev, GROUP, remaining)
    'If (stat <> 0) Then ErrorMessage.Display ("Triggered DIG_Block_Check error:" & NICode(stat)), 5
    PGRemaining = remaining
End Function


Public Sub EndTriggeredOutput()
    '7 Feb 2005 CGL.
    'Disable the trigger and pattern generation.
    If bTest Then Exit Sub
    'This DIG_Block_Clear should be redundant.
    stat = DIG_Block_Clear(dev, GROUP)
    'Disconnect RTSI bus.
    stat = RTSI_Clear(dev)
End Sub




'---------------------------------------------
'Subroutines used for controlling solenoids.
'---------------------------------------------

Public Function Pump(ByVal iPump As Integer, ByVal sglTime As Single) As Integer
    '14 Feb 2005 CGL.
    'Hold a solenoid open for sglTime seconds.  Not longer than 30s.
    Dim mousept0
    
    'Error checking.
    If (iPump > 7 Or iPump < 0 Or sglTime < 0) Then Exit Function
    If (sglTime > 30) Then sglTime = 30: Beep
    
    'Test mode.
    If bTest Then
        mousept0 = Screen.MousePointer
        Screen.MousePointer = vbHourglass
        sw.Wait sglTime
        Screen.MousePointer = mousept0
        Exit Function
    End If
    
    'Set timer and start solenoid dispensing.
    mousept0 = Screen.MousePointer
    Screen.MousePointer = vbHourglass
    sw.Reset
    'Configure dig output port.  This should not be necessary.
    stat = DIG_Prt_Config(dev, SOLENOIDPORT, NOHSHAKE, OUTPUTPRT)
    If (stat <> 0) Then sErr = sErr & "Port config error:" & NICode(stat) & vbCrLf
    'Activate & deactivate the solenoid.
    stat = DIG_Out_Prt(dev, SOLENOIDPORT, iPump)
    If (stat <> 0) Then ErrorMessage.Display ("Error activating solenoid: " & NICode(stat)), 15
    While (sw.Elapsed(sglTime) = False): Wend 'Wait until done.
    stat = DIG_Out_Prt(dev, SOLENOIDPORT, MUXSTATE)
    If (stat <> 0) Then ErrorMessage.Display ("Error deactivating solenoid: " & NICode(stat)), 15
    Screen.MousePointer = mousept0
    'Return any error code.
    Pump = stat
End Function



