VERSION 5.00
Begin VB.Form PogoMIO 
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   "Pogo PCI-MIO-16E"
   ClientHeight    =   4500
   ClientLeft      =   45
   ClientTop       =   285
   ClientWidth     =   6315
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4500
   ScaleWidth      =   6315
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   1000
      Left            =   5640
      Top             =   0
   End
   Begin VB.Frame Frame2 
      Caption         =   "Analog Inputs"
      Height          =   3375
      Left            =   3360
      TabIndex        =   11
      Top             =   480
      Width           =   2775
      Begin VB.TextBox tbxAI0 
         Height          =   285
         Index           =   7
         Left            =   240
         TabIndex        =   19
         Text            =   "0"
         Top             =   2880
         Width           =   855
      End
      Begin VB.TextBox tbxAI0 
         Height          =   285
         Index           =   6
         Left            =   240
         TabIndex        =   18
         Text            =   "0"
         Top             =   2520
         Width           =   855
      End
      Begin VB.TextBox tbxAI0 
         Height          =   285
         Index           =   5
         Left            =   240
         TabIndex        =   17
         Text            =   "0"
         Top             =   2160
         Width           =   855
      End
      Begin VB.TextBox tbxAI0 
         Height          =   285
         Index           =   4
         Left            =   240
         TabIndex        =   16
         Text            =   "0"
         Top             =   1800
         Width           =   855
      End
      Begin VB.TextBox tbxAI0 
         Height          =   285
         Index           =   3
         Left            =   240
         TabIndex        =   15
         Text            =   "0"
         Top             =   1440
         Width           =   855
      End
      Begin VB.TextBox tbxAI0 
         Height          =   285
         Index           =   2
         Left            =   240
         TabIndex        =   14
         Text            =   "0"
         Top             =   1080
         Width           =   855
      End
      Begin VB.TextBox tbxAI0 
         Height          =   285
         Index           =   1
         Left            =   240
         TabIndex        =   13
         Text            =   "0"
         Top             =   720
         Width           =   855
      End
      Begin VB.TextBox tbxAI0 
         Height          =   285
         Index           =   0
         Left            =   240
         TabIndex        =   12
         Text            =   "0"
         Top             =   360
         Width           =   855
      End
      Begin VB.Label Label1 
         Caption         =   "Channel 7"
         Height          =   255
         Index           =   7
         Left            =   1200
         TabIndex        =   27
         Top             =   2880
         Width           =   855
      End
      Begin VB.Label Label1 
         Caption         =   "Ch 6 - Hygrometer"
         Height          =   255
         Index           =   6
         Left            =   1200
         TabIndex        =   26
         Top             =   2520
         Width           =   1455
      End
      Begin VB.Label Label1 
         Caption         =   "Channel 5"
         Height          =   255
         Index           =   5
         Left            =   1200
         TabIndex        =   25
         Top             =   2160
         Width           =   975
      End
      Begin VB.Label Label1 
         Caption         =   "Channel 4"
         Height          =   255
         Index           =   4
         Left            =   1200
         TabIndex        =   24
         Top             =   1800
         Width           =   975
      End
      Begin VB.Label Label1 
         Caption         =   "Channel 3"
         Height          =   255
         Index           =   3
         Left            =   1200
         TabIndex        =   23
         Top             =   1440
         Width           =   1215
      End
      Begin VB.Label Label1 
         Caption         =   "Channel 2"
         Height          =   255
         Index           =   2
         Left            =   1200
         TabIndex        =   22
         Top             =   1080
         Width           =   1215
      End
      Begin VB.Label Label1 
         Caption         =   "Channel 1"
         Height          =   255
         Index           =   1
         Left            =   1200
         TabIndex        =   21
         Top             =   720
         Width           =   1215
      End
      Begin VB.Label Label1 
         Caption         =   "Channel 0"
         Height          =   255
         Index           =   0
         Left            =   1200
         TabIndex        =   20
         Top             =   360
         Width           =   1215
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Digital Input/Output Port"
      Height          =   3375
      Left            =   120
      TabIndex        =   2
      Top             =   480
      Width           =   3135
      Begin VB.CheckBox chkDIO 
         Caption         =   "DIO6 - \Reset droplet detector"
         ForeColor       =   &H00004000&
         Height          =   375
         Index           =   6
         Left            =   120
         TabIndex        =   10
         Top             =   2520
         Width           =   2895
      End
      Begin VB.CheckBox chkDIO 
         Caption         =   "DIO3 - Input"
         Enabled         =   0   'False
         ForeColor       =   &H00000080&
         Height          =   375
         Index           =   3
         Left            =   120
         TabIndex        =   9
         Top             =   1440
         Width           =   2775
      End
      Begin VB.CheckBox chkDIO 
         Caption         =   "DIO2 - Input"
         Enabled         =   0   'False
         ForeColor       =   &H00000080&
         Height          =   375
         Index           =   2
         Left            =   120
         TabIndex        =   8
         Top             =   1080
         Width           =   2775
      End
      Begin VB.CheckBox chkDIO 
         Caption         =   "DIO7 - Read droplet detector"
         Enabled         =   0   'False
         ForeColor       =   &H00000080&
         Height          =   375
         Index           =   7
         Left            =   120
         TabIndex        =   7
         Top             =   2880
         Width           =   2895
      End
      Begin VB.CheckBox chkDIO 
         Caption         =   "DIO5 - 120VAC Solenoid, Box dryer"
         ForeColor       =   &H00004000&
         Height          =   375
         Index           =   5
         Left            =   120
         TabIndex        =   6
         Top             =   2160
         Width           =   2895
      End
      Begin VB.CheckBox chkDIO 
         Caption         =   "DIO4 - 120VAC Solenoid"
         ForeColor       =   &H00004000&
         Height          =   375
         Index           =   4
         Left            =   120
         TabIndex        =   5
         Top             =   1800
         Width           =   2895
      End
      Begin VB.CheckBox chkDIO 
         Caption         =   "DIO1 - 5V solenoid, extra"
         ForeColor       =   &H00004000&
         Height          =   375
         Index           =   1
         Left            =   120
         TabIndex        =   4
         Top             =   720
         Width           =   2775
      End
      Begin VB.CheckBox chkDIO 
         Caption         =   "DIO0 - 5V Solenoid, Slide dryer"
         ForeColor       =   &H00004000&
         Height          =   375
         Index           =   0
         Left            =   120
         TabIndex        =   3
         Top             =   360
         Width           =   2775
      End
   End
   Begin VB.CommandButton btnClose 
      Caption         =   "Close"
      Default         =   -1  'True
      Height          =   375
      Left            =   120
      TabIndex        =   0
      Top             =   3960
      Width           =   1215
   End
   Begin VB.Label Label9 
      BackStyle       =   0  'Transparent
      Caption         =   "This panel is for testing purposes only"
      ForeColor       =   &H00FF0000&
      Height          =   255
      Left            =   120
      TabIndex        =   1
      Top             =   120
      Width           =   3015
   End
End
Attribute VB_Name = "PogoMIO"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'PogoMIO class/form.
'10 Feb 2005
'Copyright
'C Lausted, Institute for Systems Biology
'
'Access to the National Instruments MIO board.
'Used for droplet detector, inert gas solenoids, hygrometer.
'In future, also may monitor gas pressure.
'
'Dependencies: ErrorMessage, PogoNidaq.
'//////////////////////////////////////////////////////////////////

Option Base 1


'Constants.
Private Const LINEARENCODER As Boolean = False  'Triggering with 6k instead.
Private Const port As Integer = 0          'Only one DIO port on this board.
Private Const AOCHAN As Integer = 0        'Only one analog output port.
Private Const INTN2JET As Integer = 0      'N2 jet is on line zero of output port.
Private Const RELAY4 As Integer = 4        'This is a 120VAC solid state relay.
Private Const RELAY5 As Integer = 5        'This is a 120VAC solid state relay.
Private Const PRESSURIZER As Integer = 1   'Phosphoramidite pressure is line one.
Private Const RESETDD As Integer = 6       'Droplet detector reset line.
Private Const READDD As Integer = 7        'Droplet detector signal line.
Private Const HYGCHAN As Integer = 6       'Hygrometer channel.
Private Const HYGGAIN As Integer = 1       'Gain sets range to +/-5 volts?
Private Const CGAIN As Integer = 1         'Gain for other channels +/-5V.

'Globals
Private dev As Integer          'National Instruments MIO-16E.
Private istat As Integer
Public bTest As Boolean         'Simulate MIO even if not attached.



Private Sub Form_Load()
    '10 Feb 2005 CGL.
    'Object constructor.  Initialize board.
    Const INPUTPRT As Integer = 0
    Const OUTPUTPRT As Integer = 1
    Const bidirectionalprt As Integer = 2
    Const NOHSHAKE As Integer = 0
    Dim pattern As Long
    Dim i As Integer
    Dim sErr As String
    bTest = False
    sErr = ""
    
    'Use error handler to offer user the test mode option.
    On Error GoTo ErrorHandler
    
    'Get the device number and initialize this board.
    dev = InitializeMIO()
    If (dev = -1) Then
        sErr = "Pogo was unable to find the multifunction IO board." & vbCrLf
        GoTo ErrorHandler
    End If
        
    'Check if circuit board with relays is connected.  Allow user to switch to test mode.
    istat = DIG_Prt_Config(dev, port, NOHSHAKE, INPUTPRT) 'Can still set lines individually.
    If (istat <> 0) Then sErr = (sErr & "MIO board DIG_Prt_Config error " & NICode(istat) & vbCrLf)
    istat = DIG_In_Prt(dev, port, pattern)
    If ((pattern And 3) <> 0) Then sErr = (sErr & "Hardware external to the " & _
        "MIO board might not be attached." & vbCrLf)
    
    'Setup DIO port for bidirectional.  Set up each line.
    For i = 0 To 7
        istat = DIG_Line_Config(dev, port, i, INPUTPRT)
        If (istat <> 0) Then sErr = (sErr & "MIO board DIG_Line_Config error " & NICode(istat) & vbCrLf)
    Next i
    istat = DIG_Line_Config(dev, port, INTN2JET, OUTPUTPRT)
    istat = DIG_Line_Config(dev, port, PRESSURIZER, OUTPUTPRT)
    istat = DIG_Line_Config(dev, port, RELAY4, OUTPUTPRT)
    istat = DIG_Line_Config(dev, port, RELAY5, OUTPUTPRT)
    istat = DIG_Line_Config(dev, port, RESETDD, OUTPUTPRT)
    istat = DIG_Line_Config(dev, port, READDD, INPUTPRT)
    istat = ResetDropletDetector()
    
    'Test analog ouput port (unused).
    istat = AO_Write(dev, AOCHAN, 0)
    If (istat <> 0) Then sErr = (sErr & "MIO board AO_Write error " & NICode(istat) & vbCrLf)
    
    'Set default hygrometer calibration.
    dblHygM = 1
    dblHygB = 0
    
    If (Len(sErr) = 0) Then Exit Sub
ErrorHandler:
    'Log errors.
    'Previously, asked users if they wish to continue in test/simulation mode.
    'Now, assume use wants to continue.  Can quit later.
    sErr = sErr & "Pogo is unable to use the MIO board."
    ErrorMessage.Log (sErr)
    bTest = True
End Sub


'Object destructor.
Private Sub Form_Unload(iCancel As Integer)
    '10 Feb 2005 CGL.
    If bTest Then Exit Sub
    'Return MIO-16-E to default settings.
    dev = InitializeMIO()
End Sub


Private Function InitializeMIO() As Integer
    '10 Feb 2005 CGL
    'Initialize the MIO-16E with default settings.
    'Automatically detect the device number.  Return -1 if not found.
    Const pci_mio16e_1 As Integer = 205
    Const pci_mio16e_4 As Integer = 206
    Dim devNumber As Integer, devCode As Integer
    InitializeMIO = -1
    
    'Try eight possible device numbers.
    For devNumber = 0 To 7
        stat = Init_DA_Brds(devNumber, devCode)
        If (devCode = pci_mio16e_1) Or (devCode = pci_mio16e_4) Then InitializeMIO = devNumber
    Next devNumber
End Function


Public Sub ConfigureCounters()
    '14 Feb 2005 CGL.
    'Configure counters GPCTR0 and GPCTR1.
    If bTest Then Exit Sub
    
    'Configure Counter#1 to produce double 350us pulses from 6K trigger from RTSI#0.
    'It appears that the leading and trailing edges activate pulses since the 6K PLCP mode scans
    '  are separated by 1.5ms and the pulses are separated by 1.5ms.
    'Retriggerable single pulse generation.
    'I have wired encoder conditioner JP2 to pin 41 (PFI4).
    'But it would be better to wire it to pin 11 (PFI0/TRIG1).
    'Be sure to put 34pin ribbon cable on RTSI bus.
    istat = GPCTR_Control(dev, ND_COUNTER_1, ND_RESET)
    If (istat <> 0) Then MsgBox "A GPCTR_Control " & NICode(istat)
    istat = GPCTR_Set_Application(dev, ND_COUNTER_1, ND_RETRIG_PULSE_GNR)
    If (istat <> 0) Then MsgBox "B" & NICode(istat)
    istat = GPCTR_Change_Parameter(dev, ND_COUNTER_1, ND_SOURCE, ND_INTERNAL_20_MHZ)
    If (istat <> 0) Then MsgBox "C" & NICode(istat)
    istat = GPCTR_Change_Parameter(dev, ND_COUNTER_1, ND_COUNT_1, 2)
    If (istat <> 0) Then MsgBox "D" & NICode(istat)
    istat = GPCTR_Change_Parameter(dev, ND_COUNTER_1, ND_COUNT_2, (350 * 20))  'Why not 350us?
    If (istat <> 0) Then MsgBox "E" & NICode(istat)
    If LINEARENCODER Then
        'Get input from encoder via PFI0 (pin 11).  Preferred.
        istat = GPCTR_Change_Parameter(dev, ND_COUNTER_1, ND_GATE, ND_PFI_0)
    Else
        'Get input from 6K via RTSI#0.  Testing.
        istat = GPCTR_Change_Parameter(dev, ND_COUNTER_1, ND_GATE, ND_RTSI_0)
    End If
    If (istat <> 0) Then MsgBox "f" & NICode(istat)
    istat = Select_Signal(dev, ND_GPCTR1_OUTPUT, ND_GPCTR1_OUTPUT, ND_LOW_TO_HIGH)
    If (istat <> 0) Then MsgBox "g" & NICode(istat)
    istat = GPCTR_Control(dev, ND_COUNTER_1, ND_PROGRAM)
    If (istat <> 0) Then MsgBox "I" & NICode(istat)
    
    'Configure Counter#0 to produce a 1Mhz waveform when Counter#1 output is high.
    'Be sure to wire Counter#1 output (pin40) to Counter#0 gate (pin3).
    'Pulse train generation.  Output on RTSI #3.
    istat = GPCTR_Control(dev, ND_COUNTER_0, ND_RESET)
    If (istat <> 0) Then MsgBox "M" & NICode(istat)
    istat = GPCTR_Set_Application(dev, ND_COUNTER_0, ND_PULSE_TRAIN_GNR)
    If (istat <> 0) Then MsgBox "N" & NICode(istat)
    istat = GPCTR_Change_Parameter(dev, ND_COUNTER_0, ND_SOURCE, ND_INTERNAL_20_MHZ)
    If (istat <> 0) Then MsgBox "O" & NICode(istat)
    istat = GPCTR_Change_Parameter(dev, ND_COUNTER_0, ND_COUNT_1, 10)  '10cts high.
    If (istat <> 0) Then MsgBox "P" & NICode(istat)
    istat = GPCTR_Change_Parameter(dev, ND_COUNTER_0, ND_COUNT_2, 10)  '10cts low. Result is 1us period.
    If (istat <> 0) Then MsgBox "Q" & NICode(istat)
    istat = GPCTR_Change_Parameter(dev, ND_COUNTER_0, ND_GATE, ND_PFI_9) 'Or ND_DEFAULT_PFI_LINE.
    If (istat <> 0) Then MsgBox "R" & NICode(istat)
    istat = Select_Signal(dev, ND_RTSI_3, ND_GPCTR0_OUTPUT, ND_LOW_TO_HIGH) 'Send output to DIO via RTSI#3.
    If (istat <> 0) Then MsgBox "S" & NICode(istat)
    istat = Select_Signal(dev, ND_GPCTR0_OUTPUT, ND_GPCTR0_OUTPUT, ND_LOW_TO_HIGH)
    If (istat <> 0) Then MsgBox "T" & NICode(istat)
    istat = GPCTR_Control(dev, ND_COUNTER_0, ND_PROGRAM)
    If (istat <> 0) Then MsgBox "U" & NICode(istat)
End Sub


Public Sub ResetCounters()
    '14 Feb 2005 CGL
    'Reset general purpose counters to default state.
    If bTest Then Exit Sub
    istat = GPCTR_Control(dev, ND_COUNTER_0, ND_RESET)
    istat = GPCTR_Control(dev, ND_COUNTER_1, ND_RESET)
End Sub



Public Function ResetDropletDetector() As Integer
    '13 Jan 2004 CGL.
    'Make 10 attempts to reset and return 0 if successful.
    Dim i As Integer
    ResetDropletDetector = 0
    If bTest Then Exit Function
    
    For i = 1 To 10
        'Toggle low-high.
        istat = DIG_Out_Line(dev, port, RESETDD, 0)
        Pause (0.001)
        istat = DIG_Out_Line(dev, port, RESETDD, 1)
        If (istat <> 0) Then ErrorMessage.Display ("MIO board DIG_Out_Line error " & NICode(istat)), 15
        Pause (0.001)
        'Check if it worked.
        If (ReadDropletDetector = False) Then Exit Function
    Next i
    'Return error code and message.
    ErrorMessage.Display ("Unable to reset droplet detector"), 15
    ResetDropletDetector = 1
End Function

Public Function ReadDropletDetector() As Boolean
    '13 Jan 2004 CGL.
    'Return boolean state of droplet detection.  True = yes, droplet was detected.
    Dim state As Integer
    'In test mode, we return true 95% of the time
    If bTest Then
        ReadDropletDetector = (Rnd() < 0.95)
        Exit Function
    End If
    'Now proceed with normal mode.
    Pause (0.001)
    istat = DIG_In_Line(dev, port, READDD, state)
    If (istat <> 0) Then ErrorMessage.Display ("MIO board DIG_In_Line error " & NICode(istat)), 15
    If state = 1 Then ReadDropletDetector = True Else ReadDropletDetector = False
End Function


Private Sub Pause(dblDuration As Double)
    'Wait dblDuration seconds, doing nothing.
    Dim startTime As Double
    startTime = Timer
    While (Abs(startTime - Timer) < dblDuration): Wend
End Sub


Property Get Humidity() As Double
    '16 Jan 2004 CGL.
    'Return humidity in volts.
    Dim reading As Integer
    'Test mode.
    If bTest Then
        Humidity = 2.5
    Else
        Humidity = ReadAI(HYGCHAN, HYGGAIN) * 10 / 4096
    End If
    'Normal mode.
    Rem istat = AI_Read(DEV, HYGCHAN, HYGGAIN, reading)
    Rem If (istat <> 0) Then ErrorMessage.Display ("MIO board AI_Read error " & NICode(istat)), 15
    Rem Humidity = reading * 10 / 4096
End Property


Property Let N2JetOn(ByVal bValue As Boolean)
    '16 Jan 2004 CGL.
    'Turn on/off the blower that is used to clean off the array slides.
    Dim iValue As Integer
    If bValue Then iValue = 1 Else iValue = 0
    If bTest Then Exit Property
    istat = DIG_Out_Line(dev, port, INTN2JET, iValue)
    If (istat <> 0) Then ErrorMessage.Display ("MIO board DIG_Out_Line error " & NICode(istat)), 15
End Property


Property Let PressurizerOn(ByVal bValue As Boolean)
    '16 Jan 2004 CGL.
    'Turn on/off the extra inert gas solenoid that can be used to pressurize reagent bottles.
    Dim iValue As Integer
    If bValue Then iValue = 1 Else iValue = 0
    If bTest Then Exit Property
    istat = DIG_Out_Line(dev, port, PRESSURIZER, iValue)
    If (istat <> 0) Then ErrorMessage.Display ("MIO board DIG_Out_Line error " & NICode(istat)), 15
End Property


Property Let Relay4On(ByVal bValue As Boolean)
    '16 Jan 2004 CGL.
    'Turn on/off first 120V solid-state relay.
    Dim iValue As Integer
    If bValue Then iValue = 1 Else iValue = 0
    If bTest Then Exit Property
    istat = DIG_Out_Line(dev, port, RELAY4, iValue)
    If (istat <> 0) Then ErrorMessage.Display ("MIO board DIG_Out_Line error " & NICode(istat)), 15
End Property


Property Let Relay5On(ByVal bValue As Boolean)
    '16 Jan 2004 CGL.
    'Turn on/off second 120V solid-state relay.  It is intended to power the solenoid
    'that feeds inert gas to the air amplifier and floods the working area.
    Dim iValue As Integer
    If bValue Then iValue = 1 Else iValue = 0
    If bTest Then Exit Property
    istat = DIG_Out_Line(dev, port, RELAY5, iValue)
    If (istat <> 0) Then ErrorMessage.Display ("MIO board DIG_Out_Line error " & NICode(istat)), 15
End Property


'-------------------------------------------------------
'Functions for handling the test panel.
'-------------------------------------------------------


Private Sub Form_Activate()
    '30 Sept 2004 CGL.
    'When this form is shown, turn on timer so readings are updated.
    Timer1.Enabled = True
    'Turn digital outputs off.
    For i = 0 To 7
        If chkDIO(i).Enabled = True Then
            istat = DIG_Out_Line(dev, port, i, 0)
            chkDIO(i).value = vbUnchecked
        End If
    Next i
End Sub


Private Sub btnClose_Click()
    '30 Sept 2004 CGL.
    'Shut off timer, turn digital outputs off, and hide panel.
    Timer1.Enabled = False
    'Turn digital outputs off.
    For i = 0 To 7
        If chkDIO(i).Enabled = True Then
            istat = DIG_Out_Line(dev, port, i, 0)
            chkDIO(i).value = vbUnchecked
        End If
    Next i
    Hide
End Sub


Private Sub Timer1_Timer()
    '30 Sept 2004 CGL.
    'Every one second, update analog & digital readings on panel.
    Dim i As Integer, reading As Integer
    If bTest Then Exit Sub
    'Update Analog Inputs
    For i = 0 To 7
        tbxAI0(i).Text = Format(AIVoltage(i), "0.000")
    Next i
    'Update Digital Inputs (Inputs have corresponding chkboxes disabled).
    For i = 0 To 7
        If chkDIO(i).Enabled = False Then
            istat = DIG_In_Line(dev, port, i, state)
            If (istat <> 0) Then ErrorMessage.Display ("MIO board DIG_In_Line error " & NICode(istat)), 15
            If state = 1 Then chkDIO(i).value = vbChecked Else chkDIO(i) = vbUnchecked
        End If
    Next i
End Sub


Public Function AIVoltage(ByVal iChannel As Integer) As Double
    '25 Oct 2004 CGL.
    Dim x As Double
    x = ReadAI(iChannel, CGAIN)  'CGAIN=1 should give me +/-5V range.
    x = x * 5 / 2047
    AIVoltage = x
End Function
    
Private Function ReadAI(ByVal iChannel As Integer, ByVal iGain As Integer) As Integer
    '25 Oct 2004 CGL.
    'Take 25 readings and average.
    Dim i As Integer, reading As Integer
    Dim sum As Long
    For i = 1 To 100
        istat = AI_Read(dev, iChannel, iGain, reading)
        If (istat <> 0) Then ErrorMessage.Display ("MIO board AI_Read error " & NICode(istat)), 15
        sum = sum + reading
    Next i
    ReadAI = sum * 0.01
End Function


Private Sub chkDIO_Click(Index As Integer)
    '30 Sept 2004 CGL.
    'Toggle digital outputs by clicking on checkboxes.
    Dim i As Integer
    If (chkDIO(Index).value = vbChecked) Then i = 1 Else i = 0
    istat = DIG_Out_Line(dev, port, Index, i)
End Sub


