Attribute VB_Name = "PogoMisc"
'PogoMisc
'11 Aug 2004
'Copyright
'C Lausted, Institute for Systems Biology
'
'
'Miscellaneous functions used by multiple forms & modules.
'//////////////////////////////////////////////////////////////////


'Globals.  ////////////////////////////////////////////////////////
Private Const CBGCOLOR As Long = &H606060   'Background color for a spot on the display.


'Functions.  //////////////////////////////////////////////////////
Public Function MyColor(i As Integer) As Long
    '20 Jan 2004 CGL.
    'We need colors 1 thru 6 to be bright.
    If i = 0 Then MyColor = CBGCOLOR Else MyColor = QBColor(i + 8)
End Function


Public Function Min(x1 As Variant, x2 As Variant) As Variant
    If (x1 >= x2) Then Min = x2 Else Min = x1
End Function


Public Function Max(x1 As Variant, x2 As Variant) As Variant
    If (x1 < x2) Then Max = x2 Else Max = x1
End Function


Public Function MyTrim(ByVal s1 As String) As String
    '30 Dec 2003 CGL.
    'Remove leading, trailing, and redundant spaces.
    'Tab characters are converted to spaces also.
    Dim s2 As String
    Dim iLen As Integer
    s1 = Replace(s1, Chr(9), Chr(32))
    s1 = Trim(s1)
    Do
        iLen = Len(s1)
        s1 = Replace(s1, "  ", " ")
    Loop Until (Len(s1) = iLen)
    MyTrim = s1
End Function


Public Function MyParse(ByVal sLine As String) As Variant
    '05 Jan 2004 CGL.
    'Parse string into string array using {() ,} as delimiters.
    'Multiple delimiters in a row count as just one.
    'Text is converted to uppercase.
    sLine = Replace(sLine, "(", " ") 'Change ( to space.
    sLine = Replace(sLine, ")", " ") 'Change ) to space.
    sLine = Replace(sLine, ",", " ") 'Change , to space.
    sLine = UCase(sLine)             'Make uppercase.
    sLine = MyTrim(sLine)
    MyParse = Split(sLine, " ")
End Function


Public Function Concatenate(ByVal delim As String, ParamArray x() As Variant) As String
    '11 Aug 2004 CGL
    'Concatenate or join strings using delimeter delim.
    Concatenate = Join(x, delim)
End Function

