Attribute VB_Name = "PogoNidaq"
'PogoNidaq
'10 Feb 2005
'Copyright
'C Lausted, Institute for Systems Biology
'
'DLL Declarations and constants to use National Instruments boards.
'Dependencies: nidaq32.dll
'//////////////////////////////////////////////////////////////////


'-------------------------------------------------------
'Function prototypes needed by both boards
'-------------------------------------------------------
Public Declare Function Init_DA_Brds Lib "nidaq32.dll" _
    (ByVal dev As Integer, ByRef devCode As Integer) As Integer
Public Declare Function DIG_Prt_Config Lib "nidaq32.dll" (ByVal dev _
    As Integer, ByVal port As Integer, ByVal mode As Integer, _
    ByVal dir As Integer) As Integer
Public Declare Function DIG_Line_Config Lib "nidaq32.dll" (ByVal dev _
    As Integer, ByVal port As Integer, ByVal Line As Integer, _
    ByVal dir As Integer) As Integer
Public Declare Function DIG_Out_Line Lib "nidaq32.dll" (ByVal dev _
    As Integer, ByVal port As Integer, ByVal Line As Integer, _
    ByVal state As Integer) As Integer
Public Declare Function DIG_In_Line Lib "nidaq32.dll" (ByVal dev _
    As Integer, ByVal port As Integer, ByVal Line As Integer, _
    ByRef state As Integer) As Integer
Public Declare Function DIG_In_Prt Lib "nidaq32.dll" (ByVal dev _
    As Integer, ByVal port As Integer, ByRef pattern As Long) As Integer
Public Declare Function DIG_Out_Prt Lib "nidaq32.dll" (ByVal dev _
    As Integer, ByVal port As Integer, ByVal pattern As Long) As Integer

'------------------------------------------------------------------------
'Function prototypes needed by MIO-16E board
'------------------------------------------------------------------------
'Analog ports.
Public Declare Function WFM_Op Lib "nidaq32.dll" (ByVal dev As Integer, _
    ByVal numChans As Integer, ByRef chanVect As Integer, _
    ByRef buffer As Integer, ByVal count As Long, _
    ByVal iterations As Long, ByVal rate As Double) As Integer
Public Declare Function AO_Write Lib "nidaq32.dll" (ByVal dev As Integer, _
    ByVal chan As Integer, ByVal value As Integer) As Integer
Public Declare Function AI_Read Lib "nidaq32.dll" (ByVal dev As Integer, _
    ByVal chan As Integer, ByVal gain As Integer, ByRef reading As Integer) _
    As Integer
'General purpose counters & RTSI bus.
Public Declare Function GPCTR_Control Lib "nidaq32.dll" _
    (ByVal dev As Integer, ByVal gpctrNum As Long, ByVal action As Long) As Integer
Public Declare Function GPCTR_Set_Application Lib "nidaq32.dll" _
    (ByVal dev As Integer, ByVal gpctrNum As Long, ByVal application As Long) As Integer
Public Declare Function Select_Signal Lib "nidaq32.dll" (ByVal dev As Integer, _
    ByVal signal As Long, ByVal source As Long, ByVal sourceSpec As Long) As Integer
Public Declare Function GPCTR_Change_Parameter Lib "nidaq32.dll" (ByVal dev As Integer, _
    ByVal gpctrNum As Long, ByVal paramID As Long, ByVal paramValue As Long) As Integer

'-------------------------------------------------------
'Function prototypes needed by DIO-32HS boad
'-------------------------------------------------------
'Declare port group and pattern generation output functions.
Public Declare Function DIG_Block_Clear Lib "nidaq32.dll" _
    (ByVal dev As Integer, ByVal GROUP As Integer) As Integer
Public Declare Function DIG_Grp_Config Lib "nidaq32.dll" _
    (ByVal dev As Integer, ByVal GROUP As Integer, ByVal GROUPSIZE As Integer, _
    ByVal port As Integer, ByVal dir As Integer) As Integer
Public Declare Function DIG_Out_Grp Lib "nidaq32.dll" _
    (ByVal dev As Integer, ByVal GROUP As Integer, ByVal groupPattern _
    As Integer) As Integer
Public Declare Function DIG_Block_PG_Config Lib "nidaq32.dll" _
    (ByVal dev As Integer, ByVal GROUP As Integer, ByVal config As Integer, _
    ByVal reqSource As Integer, ByVal TIMEBASE As Integer, ByVal _
    reqInterval As Integer, ByVal EXTERNALGATE As Integer) As Integer
Public Declare Function DIG_Block_Out Lib "nidaq32.dll" _
    (ByVal dev As Integer, ByVal GROUP As Integer, ByRef buffer As Integer, ByVal _
    count As Long) As Integer
Public Declare Function DIG_Block_Check Lib "nidaq32.dll" _
    (ByVal dev As Integer, ByVal GROUP As Integer, ByRef remaining As Long) As Integer
'Declare trigger functions necessary for Fire-on-the-Fly.
Public Declare Function DIG_Trigger_Config Lib "nidaq32.dll" _
    (ByVal dev As Integer, ByVal GROUP As Integer, ByVal STARTTRIG As Integer, _
    ByVal STARTPOL As Integer, ByVal STOPTRIG As Integer, ByVal STOPPOL As Integer, _
    ByVal PTSAFTERSTOP As Long, ByVal TPATTERN As Long, ByVal PATTERNMASK As Long) As Integer
Public Declare Function RTSI_Clear Lib "nidaq32.dll" _
    (ByVal dev As Integer) As Integer
Public Declare Function RTSI_Conn Lib "nidaq32.dll" (ByVal dev As Integer, _
    ByVal sigCode As Integer, ByVal trigLine As Integer, ByVal direction As Integer) As Integer
Public Declare Function RTSI_DisConn Lib "nidaq32.dll" (ByVal dev As Integer, _
    ByVal sigCode As Integer, ByVal trigLine As Integer) As Integer


'-------------------------------------------------------
'Constants
'-------------------------------------------------------
Public Const ND_ABOVE_HIGH_LEVEL As Long = 11020
Public Const ND_ABOVE_LEVEL_A As Long = 11021
Public Const ND_ABOVE_LEVEL_A_HYSTERESIS As Long = 11022
Public Const ND_AC As Long = 11025
Public Const ND_ACK_REQ_EXCHANGE_GR1 As Long = 11030
Public Const ND_ACK_REQ_EXCHANGE_GR2 As Long = 11035
Public Const ND_ACTIVE As Long = 11037
Public Const ND_ADC_RESOLUTION As Long = 11040
Public Const ND_AI_CALDAC_COUNT As Long = 11050
Public Const ND_AI_CHANNEL_COUNT As Long = 11060
Public Const ND_AI_COUPLING As Long = 11055
Public Const ND_AI_FIFO_INTERRUPTS As Long = 11600
Public Const ND_ANALOG_FILTER As Long = 11065
Public Const ND_AO48XDC_SET_POWERUP_STATE As Long = 42100
Public Const ND_AO_CALDAC_COUNT As Long = 11070
Public Const ND_AO_CHANNEL_COUNT As Long = 11080
Public Const ND_AO_EXT_REF_CAPABLE As Long = 11090
Public Const ND_AO_UNIPOLAR_CAPABLE As Long = 11095
Public Const ND_ARM As Long = 11100
Public Const ND_ARMED As Long = 11200
Public Const ND_ATC_OUT As Long = 11250
Public Const ND_ATTENUATION As Long = 11260
Public Const ND_AUTOINCREMENT_COUNT As Long = 11300
Public Const ND_AUTOMATIC As Long = 11400
Public Const ND_AVAILABLE_POINTS As Long = 11500

Public Const ND_BASE_ADDRESS As Long = 12100
Public Const ND_BELOW_LEVEL_A As Long = 12110
Public Const ND_BELOW_LEVEL_A_HYSTERESIS As Long = 12115
Public Const ND_BELOW_LOW_LEVEL As Long = 12130
Public Const ND_BETWEEN_LEVEL_A_LEVEL_B As Long = 12135
Public Const ND_BOARD_CLOCK As Long = 12170
Public Const ND_BUFFERED_EVENT_CNT As Long = 12200
Public Const ND_BUFFERED_PERIOD_MSR As Long = 12300
Public Const ND_BUFFERED_PULSE_WIDTH_MSR As Long = 12400
Public Const ND_BUFFERED_SEMI_PERIOD_MSR As Long = 12500
Public Const ND_BURST As Long = 12600
Public Const ND_BURST_INTERVAL As Long = 12700

Public Const ND_CAL_CONST_AUTO_LOAD As Long = 13050
Public Const ND_CALIBRATION_ENABLE As Long = 13055
Public Const ND_CALIBRATION_FRAME_SIZE As Long = 13060
Public Const ND_CALIBRATION_FRAME_PTR As Long = 13065
Public Const ND_CJ_TEMP As Integer = &H8000
Public Const ND_CALGND As Integer = &H8001
Public Const ND_P_POS_0 As Integer = &H4000
Public Const ND_P_POS_1 As Integer = &H4001
Public Const ND_P_POS_2 As Integer = &H4002
Public Const ND_P_POS_3 As Integer = &H4003
Public Const ND_P_POS_4 As Integer = &H4004
Public Const ND_P_POS_5 As Integer = &H4005
Public Const ND_P_POS_6 As Integer = &H4006
Public Const ND_P_POS_7 As Integer = &H4007
Public Const ND_P_NEG_0 As Integer = &H2000
Public Const ND_P_NEG_1 As Integer = &H2001
Public Const ND_P_NEG_2 As Integer = &H2002
Public Const ND_P_NEG_3 As Integer = &H2003
Public Const ND_P_NEG_4 As Integer = &H2004
Public Const ND_P_NEG_5 As Integer = &H2005
Public Const ND_P_NEG_6 As Integer = &H2006
Public Const ND_P_NEG_7 As Integer = &H2007
Public Const ND_CLEAN_UP As Long = 13100
Public Const ND_CLOCK_REVERSE_MODE_GR1 As Long = 13120
Public Const ND_CLOCK_REVERSE_MODE_GR2 As Long = 13130
Public Const ND_CONFIG_MEMORY_SIZE As Long = 13150
Public Const ND_CONTINUOUS As Long = 13160
Public Const ND_COUNT As Long = 13200

Public Const ND_COUNTER_0 As Long = 13300
Public Const ND_COUNTER_1 As Long = 13400
Public Const ND_COUNTER_2 As Long = 13310
Public Const ND_COUNTER_3 As Long = 13320
Public Const ND_COUNTER_4 As Long = 13330
Public Const ND_COUNTER_5 As Long = 13340
Public Const ND_COUNTER_6 As Long = 13350
Public Const ND_COUNTER_7 As Long = 13360

Public Const ND_COUNTER_1_SOURCE As Long = 13430
Public Const ND_COUNT_AVAILABLE As Long = 13450
Public Const ND_COUNT_DOWN As Long = 13465
Public Const ND_COUNT_UP As Long = 13485
Public Const ND_COUNT_1 As Long = 13500
Public Const ND_COUNT_2 As Long = 13600
Public Const ND_COUNT_3 As Long = 13700
Public Const ND_COUNT_4 As Long = 13800
Public Const ND_CURRENT_OUTPUT As Long = 40200

Public Const ND_DAC_RESOLUTION As Long = 13950
Public Const ND_DATA_TRANSFER_CONDITION As Long = 13960
Public Const ND_DATA_XFER_MODE_AI As Long = 14000
Public Const ND_DATA_XFER_MODE_AO_GR1 As Long = 14100
Public Const ND_DATA_XFER_MODE_AO_GR2 As Long = 14200
Public Const ND_DATA_XFER_MODE_DIO_GR1 As Long = 14300
Public Const ND_DATA_XFER_MODE_DIO_GR2 As Long = 14400
Public Const ND_DATA_XFER_MODE_DIO_GR3 As Long = 14500
Public Const ND_DATA_XFER_MODE_DIO_GR4 As Long = 14600
Public Const ND_DATA_XFER_MODE_DIO_GR5 As Long = 14700
Public Const ND_DATA_XFER_MODE_DIO_GR6 As Long = 14800
Public Const ND_DATA_XFER_MODE_DIO_GR7 As Long = 14900
Public Const ND_DATA_XFER_MODE_DIO_GR8 As Long = 15000

Public Const ND_DATA_XFER_MODE_GPCTR0 As Long = 15100
Public Const ND_DATA_XFER_MODE_GPCTR1 As Long = 15200
Public Const ND_DATA_XFER_MODE_GPCTR2 As Long = 15110
Public Const ND_DATA_XFER_MODE_GPCTR3 As Long = 15120
Public Const ND_DATA_XFER_MODE_GPCTR4 As Long = 15130
Public Const ND_DATA_XFER_MODE_GPCTR5 As Long = 15140
Public Const ND_DATA_XFER_MODE_GPCTR6 As Long = 15150
Public Const ND_DATA_XFER_MODE_GPCTR7 As Long = 15160
Public Const ND_DATA_XFER_MODE_GPCTR8 As Long = 15165
Public Const ND_DATA_XFER_MODE_GPCTR9 As Long = 15170
Public Const ND_DATA_XFER_MODE_GPCTR10 As Long = 15175
Public Const ND_DATA_XFER_MODE_GPCTR11 As Long = 15180

Public Const ND_DC As Long = 15250
Public Const ND_DDS_BUFFER_SIZE As Long = 15255
Public Const ND_DEVICE_NAME As Long = 15260
Public Const ND_DEVICE_POWER As Long = 15270
Public Const ND_DEVICE_SERIAL_NUMBER As Long = 15280
Public Const ND_DEVICE_STATE_DURING_SUSPEND_MODE As Long = 15290
Public Const ND_DEVICE_TYPE_CODE As Long = 15300
Public Const ND_DIGITAL_FILTER As Long = 15350
Public Const ND_DIGITAL_RESTART As Long = 15375
Public Const ND_DIO128_GET_PORT_THRESHOLD As Long = 41200
Public Const ND_DIO128_SELECT_INPUT_PORT As Long = 41100
Public Const ND_DIO128_SET_PORT_THRESHOLD As Long = 41300
Public Const ND_DISABLED As Long = 15400
Public Const ND_DISARM As Long = 15450
Public Const ND_DIVIDE_DOWN_SAMPLING_SUPPORTED As Long = 15475
Public Const ND_DMA_A_LEVEL As Long = 15500
Public Const ND_DMA_B_LEVEL As Long = 15600
Public Const ND_DMA_C_LEVEL As Long = 15700
Public Const ND_DONE As Long = 15800
Public Const ND_DONT_CARE As Long = 15900
Public Const ND_DONT_KNOW As Long = 15950

Public Const ND_EDGE_SENSITIVE As Long = 16000
Public Const ND_ENABLED As Long = 16050
Public Const ND_END As Long = 16055
Public Const ND_EXTERNAL As Long = 16060
Public Const ND_EXTERNAL_CALIBRATE As Long = 16100

Public Const ND_FACTORY_CALIBRATION_EQUIP As Long = 16210
Public Const ND_FACTORY_EEPROM_AREA As Long = 16220
Public Const ND_FIFO_EMPTY As Long = 16230
Public Const ND_FIFO_HALF_FULL_OR_LESS As Long = 16240
Public Const ND_FIFO_HALF_FULL_OR_LESS_UNTIL_FULL As Long = 16245
Public Const ND_FIFO_NOT_FULL As Long = 16250
Public Const ND_FIFO_TRANSFER_COUNT As Long = 16260
Public Const ND_FILTER_CORRECTION_FREQ As Long = 16300
Public Const ND_FOREGROUND As Long = 16350
Public Const ND_FREQ_OUT As Long = 16400
Public Const ND_FSK As Long = 16500
Public Const ND_EDGE_BASED_FSK As Long = 16500

Public Const ND_GATE As Long = 17100
Public Const ND_GATE_POLARITY As Long = 17200

Public Const ND_GPCTR0_GATE As Long = 17300
Public Const ND_GPCTR0_OUTPUT As Long = 17400
Public Const ND_GPCTR0_SOURCE As Long = 17500

Public Const ND_GPCTR1_GATE As Long = 17600
Public Const ND_GPCTR1_OUTPUT As Long = 17700
Public Const ND_GPCTR1_SOURCE As Long = 17800

Public Const ND_GPCTR2_GATE As Long = 17320
Public Const ND_GPCTR2_OUTPUT As Long = 17420
Public Const ND_GPCTR2_SOURCE As Long = 17520

Public Const ND_GPCTR3_GATE As Long = 17330
Public Const ND_GPCTR3_OUTPUT As Long = 17430
Public Const ND_GPCTR3_SOURCE As Long = 17530

Public Const ND_GPCTR4_GATE As Long = 17340
Public Const ND_GPCTR4_OUTPUT As Long = 17440
Public Const ND_GPCTR4_SOURCE As Long = 17540

Public Const ND_GPCTR5_GATE As Long = 17350
Public Const ND_GPCTR5_OUTPUT As Long = 17450
Public Const ND_GPCTR5_SOURCE As Long = 17550

Public Const ND_GPCTR6_GATE As Long = 17360
Public Const ND_GPCTR6_OUTPUT As Long = 17460
Public Const ND_GPCTR6_SOURCE As Long = 17660

Public Const ND_GPCTR7_GATE As Long = 17370
Public Const ND_GPCTR7_OUTPUT As Long = 17470
Public Const ND_GPCTR7_SOURCE As Long = 17570





Public Const ND_GROUND_DAC_REFERENCE As Long = 17900

Public Const ND_HARDWARE As Long = 18000
Public Const ND_HI_RES_SAMPLING As Long = 18020
Public Const ND_HIGH As Long = 18050
Public Const ND_HIGH_HYSTERESIS As Long = 18080
Public Const ND_HIGH_TO_LOW As Long = 18100
Public Const ND_HW_ANALOG_TRIGGER As Long = 18900

Public Const ND_IMPEDANCE As Long = 19000
Public Const ND_INACTIVE As Long = 19010
Public Const ND_INITIAL_COUNT As Long = 19100
Public Const ND_INIT_PLUGPLAY_DEVICES As Long = 19110
Public Const ND_INSIDE_REGION As Long = 19150
Public Const ND_INTERNAL As Long = 19160
Public Const ND_INTERNAL_100_KHZ As Long = 19200
Public Const ND_INTERNAL_10_MHZ As Long = 19300
Public Const ND_INTERNAL_1250_KHZ As Long = 19320
Public Const ND_INTERNAL_20_MHZ As Long = 19400
Public Const ND_INTERNAL_25_MHZ As Long = 19410
Public Const ND_INTERNAL_2500_KHZ As Long = 19420
Public Const ND_INTERNAL_5_MHZ As Long = 19450
Public Const ND_INTERNAL_7160_KHZ As Long = 19460
Public Const ND_INTERNAL_TIMER As Long = 19500
Public Const ND_INTERRUPTS As Long = 19600
Public Const ND_INTERRUPT_A_LEVEL As Long = 19700
Public Const ND_INTERRUPT_B_LEVEL As Long = 19800
Public Const ND_INTERRUPT_TRIGGER_MODE As Long = 19850
Public Const ND_IN_CHANNEL_CLOCK_TIMEBASE As Long = 19900
Public Const ND_IN_CHANNEL_CLOCK_TB_POL As Long = 20000
Public Const ND_IN_CONVERT As Long = 20100
Public Const ND_IN_CONVERT_POL As Long = 20200
Public Const ND_IN_DATA_FIFO_SIZE As Long = 20250
Public Const ND_IN_EXTERNAL_GATE As Long = 20300
Public Const ND_IN_EXTERNAL_GATE_POL As Long = 20400
Public Const ND_IN_SCAN_CLOCK_TIMEBASE As Long = 20500
Public Const ND_IN_SCAN_CLOCK_TB_POL As Long = 20600
Public Const ND_IN_SCAN_IN_PROG As Long = 20650
Public Const ND_IN_SCAN_START As Long = 20700
Public Const ND_IN_SCAN_START_POL As Long = 20800
Public Const ND_IN_START_TRIGGER As Long = 20900
Public Const ND_IN_START_TRIGGER_POL As Long = 21000
Public Const ND_IN_STOP_TRIGGER As Long = 21100
Public Const ND_IN_STOP_TRIGGER_POL As Long = 21200
Public Const ND_INT_AI_GND As Long = 21210
Public Const ND_INT_AO_CH_0 As Long = 21230
Public Const ND_INT_AO_CH_0_VS_REF_5V As Long = 21235
Public Const ND_INT_AO_CH_1 As Long = 21240
Public Const ND_INT_AO_CH_1_VS_AO_CH_0 As Long = 21245
Public Const ND_INT_AO_CH_1_VS_REF_5V As Long = 21250
Public Const ND_INT_AO_CH_2 As Long = 21220
Public Const ND_INT_AO_CH_3 As Long = 21221
Public Const ND_INT_AO_CH_4 As Long = 21222
Public Const ND_INT_AO_CH_5 As Long = 21223
Public Const ND_INT_AO_CH_6 As Long = 21224
Public Const ND_INT_AO_CH_7 As Long = 21225
Public Const ND_INT_AO_GND As Long = 21260
Public Const ND_INT_AO_GND_VS_AI_GND As Long = 21265
Public Const ND_INT_CM_REF_5V As Long = 21270
Public Const ND_INT_DEV_TEMP As Long = 21280
Public Const ND_INT_REF_5V As Long = 21290
Public Const ND_INT_REF_EXTERN As Long = 21296
Public Const ND_INT_CAL_BUS As Long = 21295
Public Const ND_INT_MUX_BUS As Long = 21305

Public Const ND_INT_AI_GND_AMP_0 As Long = 21211
Public Const ND_INT_AI_GND_AMP_1 As Long = 21212
Public Const ND_INT_AI_GND_AMP_2 As Long = 21213
Public Const ND_INT_AI_GND_AMP_3 As Long = 21214
Public Const ND_INT_AI_GND_AMP_4 As Long = 21215
Public Const ND_INT_AI_GND_AMP_5 As Long = 21216
Public Const ND_INT_AI_GND_AMP_6 As Long = 21217
Public Const ND_INT_AI_GND_AMP_7 As Long = 21218

Public Const ND_INT_AO_CH_0_AMP_0 As Long = 21231
Public Const ND_INT_AO_CH_0_AMP_1 As Long = 21232
Public Const ND_INT_AO_CH_0_AMP_2 As Long = 21233
Public Const ND_INT_AO_CH_0_AMP_3 As Long = 21234
Public Const ND_INT_AO_CH_1_AMP_0 As Long = 21241
Public Const ND_INT_AO_CH_1_AMP_1 As Long = 21242
Public Const ND_INT_AO_CH_1_AMP_2 As Long = 21243
Public Const ND_INT_AO_CH_1_AMP_3 As Long = 21244
Public Const ND_INT_AO_CH_0_VS_REF_AMP_0 As Long = 21236
Public Const ND_INT_AO_CH_0_VS_REF_AMP_1 As Long = 21237
Public Const ND_INT_AO_CH_0_VS_REF_AMP_2 As Long = 21238
Public Const ND_INT_AO_CH_0_VS_REF_AMP_3 As Long = 21239
Public Const ND_INT_AO_CH_1_VS_REF_AMP_0 As Long = 21251
Public Const ND_INT_AO_CH_1_VS_REF_AMP_1 As Long = 21252
Public Const ND_INT_AO_CH_1_VS_REF_AMP_2 As Long = 21253
Public Const ND_INT_AO_CH_1_VS_REF_AMP_3 As Long = 21254
Public Const ND_INT_AO_GND_VS_AI_GND_AMP_0 As Long = 21266
Public Const ND_INT_AO_GND_VS_AI_GND_AMP_1 As Long = 21267
Public Const ND_INT_AO_GND_VS_AI_GND_AMP_2 As Long = 21268
Public Const ND_INT_AO_GND_VS_AI_GND_AMP_3 As Long = 21269
Public Const ND_INT_CM_REF_AMP_0 As Long = 21271
Public Const ND_INT_CM_REF_AMP_1 As Long = 21272
Public Const ND_INT_CM_REF_AMP_2 As Long = 21273
Public Const ND_INT_CM_REF_AMP_3 As Long = 21274
Public Const ND_INT_REF_AMP_0 As Long = 21291
Public Const ND_INT_REF_AMP_1 As Long = 21292
Public Const ND_INT_REF_AMP_2 As Long = 21293
Public Const ND_INT_REF_AMP_3 As Long = 21294
Public Const ND_INT_REF_AMP_4 As Long = 21301
Public Const ND_INT_REF_AMP_5 As Long = 21302
Public Const ND_INT_REF_AMP_6 As Long = 21303
Public Const ND_INT_REF_AMP_7 As Long = 21304
Public Const ND_ROUTE_INT_REFERENCE As Long = 21299

Public Const ND_INTERRUPT_EVERY_SAMPLE As Long = 11700
Public Const ND_INTERRUPT_HALF_FIFO As Long = 11800
Public Const ND_IO_CONNECTOR As Long = 21300

Public Const ND_LEVEL_A As Long = 21410
Public Const ND_LEVEL_B As Long = 21420
Public Const ND_LEVEL_SENSITIVE As Long = 24000
Public Const ND_LINK_COMPLETE_INTERRUPTS As Long = 24010
Public Const ND_LOW As Long = 24050
Public Const ND_LOW_HYSTERESIS As Long = 24080
Public Const ND_LOW_TO_HIGH As Long = 24100
Public Const ND_LPT_DEVICE_MODE As Long = 24200

Public Const ND_MARKER As Long = 24500
Public Const ND_MARKER_QUANTUM As Long = 24550
Public Const ND_MAX_ARB_SEQUENCE_LENGTH As Long = 24600
Public Const ND_MAX_FUNC_SEQUENCE_LENGTH As Long = 24610
Public Const ND_MAX_LOOP_COUNT As Long = 24620
Public Const ND_MAX_NUM_WAVEFORMS As Long = 24630
Public Const ND_MAX_SAMPLE_RATE As Long = 24640
Public Const ND_MAX_WFM_SIZE As Long = 24650
Public Const ND_MEMORY_TRANSFER_WIDTH As Long = 24700
Public Const ND_MIN_SAMPLE_RATE As Long = 24800
Public Const ND_MIN_WFM_SIZE As Long = 24810

Public Const ND_NEGATIVE As Long = 26100
Public Const ND_NEW As Long = 26190
Public Const ND_NI_DAQ_SW_AREA As Long = 26195
Public Const ND_NO As Long = 26200
Public Const ND_NO_STRAIN_GAUGE As Long = 26225
Public Const ND_NO_TRACK_AND_HOLD As Long = 26250
Public Const ND_NONE As Long = 26300
Public Const ND_NOT_APPLICABLE As Long = 26400
Public Const ND_NUMBER_DIG_PORTS As Long = 26500

Public Const ND_OFF As Long = 27010
Public Const ND_OFFSET As Long = 27020
Public Const ND_ON As Long = 27050
Public Const ND_OTHER As Long = 27060
Public Const ND_OTHER_GPCTR_OUTPUT As Long = 27300
Public Const ND_OTHER_GPCTR_TC As Long = 27400
Public Const ND_OUTSIDE_LEVEL_A_LEVEL_B As Long = 27065
Public Const ND_OUT_DATA_FIFO_SIZE As Long = 27070
Public Const ND_OUT_EXTERNAL_GATE As Long = 27080
Public Const ND_OUT_EXTERNAL_GATE_POL As Long = 27082
Public Const ND_OUT_START_TRIGGER As Long = 27100
Public Const ND_OUT_START_TRIGGER_POL As Long = 27102
Public Const ND_OUT_UPDATE As Long = 27200
Public Const ND_OUT_UPDATE_POL As Long = 27202
Public Const ND_OUT_UPDATE_CLOCK_TIMEBASE As Long = 27210
Public Const ND_OUT_UPDATE_CLOCK_TB_POL As Long = 27212
Public Const ND_OUTPUT_ENABLE As Long = 27220
Public Const ND_OUTPUT_MODE As Long = 27230
Public Const ND_OUTPUT_POLARITY As Long = 27240
Public Const ND_OUTPUT_STATE As Long = 27250
Public Const ND_OUTPUT_TYPE As Long = 40000

Public Const ND_DIGITAL_PATTERN_GENERATION As Long = 28030
Public Const ND_PAUSE As Long = 28040
Public Const ND_PAUSE_ON_HIGH As Long = 28045
Public Const ND_PAUSE_ON_LOW As Long = 28050
Public Const ND_PFI_0 As Long = 28100
Public Const ND_PFI_1 As Long = 28200
Public Const ND_PFI_2 As Long = 28300
Public Const ND_PFI_3 As Long = 28400
Public Const ND_PFI_4 As Long = 28500
Public Const ND_PFI_5 As Long = 28600
Public Const ND_PFI_6 As Long = 28700
Public Const ND_PFI_7 As Long = 28800
Public Const ND_PFI_8 As Long = 28900
Public Const ND_PFI_9 As Long = 29000
Public Const ND_PFI_10 As Long = 50280
Public Const ND_PFI_11 As Long = 50290
Public Const ND_PFI_12 As Long = 50300
Public Const ND_PFI_13 As Long = 50310
Public Const ND_PFI_14 As Long = 50320
Public Const ND_PFI_15 As Long = 50330
Public Const ND_PFI_16 As Long = 50340
Public Const ND_PFI_17 As Long = 50350
Public Const ND_PFI_18 As Long = 50360
Public Const ND_PFI_19 As Long = 50370
Public Const ND_PFI_20 As Long = 50380
Public Const ND_PFI_21 As Long = 50390
Public Const ND_PFI_22 As Long = 50400
Public Const ND_PFI_23 As Long = 50410
Public Const ND_PFI_24 As Long = 50420
Public Const ND_PFI_25 As Long = 50430
Public Const ND_PFI_26 As Long = 50440
Public Const ND_PFI_27 As Long = 50450
Public Const ND_PFI_28 As Long = 50460
Public Const ND_PFI_29 As Long = 50470
Public Const ND_PFI_30 As Long = 50480
Public Const ND_PFI_31 As Long = 50490
Public Const ND_PFI_32 As Long = 50500
Public Const ND_PFI_33 As Long = 50510
Public Const ND_PFI_34 As Long = 50520
Public Const ND_PFI_35 As Long = 50530
Public Const ND_PFI_36 As Long = 50540
Public Const ND_PFI_37 As Long = 50550
Public Const ND_PFI_38 As Long = 50560
Public Const ND_PFI_39 As Long = 50570

Public Const ND_PLL_REF_FREQ As Long = 29010
Public Const ND_PLL_REF_SOURCE As Long = 29020
Public Const ND_PRE_ARM As Long = 29050
Public Const ND_POSITIVE As Long = 29100
Public Const ND_PREPARE As Long = 29200
Public Const ND_PROGRAM As Long = 29300
Public Const ND_PULSE As Long = 29350
Public Const ND_PULSE_SOURCE As Long = 29500
Public Const ND_PULSE_TRAIN_GNR As Long = 29600
Public Const ND_PXI_BACKPLANE_CLOCK As Long = 29900

Public Const ND_REGLITCH As Long = 31000
Public Const ND_RESERVED As Long = 31100
Public Const ND_RESET As Long = 31200
Public Const ND_RESUME As Long = 31250
Public Const ND_RETRIG_PULSE_GNR As Long = 31300
Public Const ND_REVISION As Long = 31350
Public Const ND_RTSI_0 As Long = 31400
Public Const ND_RTSI_1 As Long = 31500
Public Const ND_RTSI_2 As Long = 31600
Public Const ND_RTSI_3 As Long = 31700
Public Const ND_RTSI_4 As Long = 31800
Public Const ND_RTSI_5 As Long = 31900
Public Const ND_RTSI_6 As Long = 32000
Public Const ND_RTSI_CLOCK As Long = 32100
Public Const ND_PXI_STAR As Long = 32200
Public Const ND_PXI_STAR_3 As Long = 32210
Public Const ND_PXI_STAR_4 As Long = 32220
Public Const ND_PXI_STAR_5 As Long = 32230
Public Const ND_PXI_STAR_6 As Long = 32240
Public Const ND_PXI_STAR_7 As Long = 32250
Public Const ND_PXI_STAR_8 As Long = 32260
Public Const ND_PXI_STAR_9 As Long = 32270
Public Const ND_PXI_STAR_10 As Long = 32280
Public Const ND_PXI_STAR_11 As Long = 32290
Public Const ND_PXI_STAR_12 As Long = 32300
Public Const ND_PXI_STAR_13 As Long = 32310
Public Const ND_PXI_STAR_14 As Long = 32320
Public Const ND_PXI_STAR_15 As Long = 32330

Public Const ND_SCANCLK As Long = 32400
Public Const ND_SCANCLK_LINE As Long = 32420
Public Const ND_SC_2040_MODE As Long = 32500
Public Const ND_SC_2043_MODE As Long = 32600
Public Const ND_SELF_CALIBRATE As Long = 32700
Public Const ND_SET_DEFAULT_LOAD_AREA As Long = 32800
Public Const ND_RESTORE_FACTORY_CALIBRATION As Long = 32810
Public Const ND_SET_POWERUP_STATE As Long = 42100
Public Const ND_SIGNAL_CONDITIONING_SPEC As Long = 32900
Public Const ND_SIMPLE_EVENT_CNT As Long = 33100
Public Const ND_SINGLE As Long = 33150
Public Const ND_SINGLE_PERIOD_MSR As Long = 33200
Public Const ND_SINGLE_PULSE_GNR As Long = 33300
Public Const ND_SINGLE_PULSE_WIDTH_MSR As Long = 33400
Public Const ND_SINGLE_TRIG_PULSE_GNR As Long = 33500
Public Const ND_SOURCE As Long = 33700
Public Const ND_SOURCE_POLARITY As Long = 33800
Public Const ND_STABLE_10_MHZ As Long = 33810
Public Const ND_STEPPED As Long = 33825
Public Const ND_STRAIN_GAUGE As Long = 33850
Public Const ND_STRAIN_GAUGE_EX0 As Long = 33875
Public Const ND_SUB_REVISION As Long = 33900
Public Const ND_SYNC_DUTY_CYCLE_HIGH As Long = 33930
Public Const ND_SYNC_OUT As Long = 33970

Public Const ND_TC_REACHED As Long = 34100
Public Const ND_THE_AI_CHANNEL As Long = 34400
Public Const ND_TOGGLE As Long = 34700
Public Const ND_TOGGLE_GATE As Long = 34800
Public Const ND_TRACK_AND_HOLD As Long = 34850
Public Const ND_TRIG_PULSE_WIDTH_MSR As Long = 34900
Public Const ND_TRIGGER_SOURCE As Long = 34930
Public Const ND_TRIGGER_MODE As Long = 34970

Public Const ND_UI2_TC As Long = 35100
Public Const ND_UP_DOWN As Long = 35150
Public Const ND_UP_TO_1_DMA_CHANNEL As Long = 35200
Public Const ND_UP_TO_2_DMA_CHANNELS As Long = 35300
Public Const ND_USE_CAL_CHAN As Long = 36000
Public Const ND_USE_AUX_CHAN As Long = 36100
Public Const ND_USER_EEPROM_AREA As Long = 37000
Public Const ND_USER_EEPROM_AREA_2 As Long = 37010
Public Const ND_USER_EEPROM_AREA_3 As Long = 37020
Public Const ND_USER_EEPROM_AREA_4 As Long = 37030
Public Const ND_USER_EEPROM_AREA_5 As Long = 37040

Public Const ND_DSA_RTSI_CLOCK_AD As Long = 44000
Public Const ND_DSA_RTSI_CLOCK_DA As Long = 44010
Public Const ND_DSA_OUTPUT_TRIGGER As Long = 44020
Public Const ND_DSA_INPUT_TRIGGER As Long = 44030
Public Const ND_DSA_SHARC_TRIGGER As Long = 44040
Public Const ND_DSA_ANALOG_TRIGGER As Long = 44050
Public Const ND_DSA_HOST_TRIGGER As Long = 44060
Public Const ND_DSA_EXTERNAL_DIGITAL_TRIGGER As Long = 44070
Public Const ND_DSA_EXCITATION As Long = 44080

Public Const ND_VOLTAGE_OUTPUT As Long = 40100
Public Const ND_VOLTAGE_REFERENCE As Long = 38000

Public Const ND_VXI_SC As Integer = &H2000
Public Const ND_PXI_SC As Integer = &H2010
Public Const ND_WALRUS_SCXI_HV_BACKPLANE As Integer = &H2011
Public Const ND_WALRUS_SCXI_LV_BACKPLANE As Integer = &H2012
Public Const ND_VXIMIO_SET_ALLOCATE_MODE As Long = 43100
Public Const ND_VXIMIO_USE_ONBOARD_MEMORY_AI As Long = 43500
Public Const ND_VXIMIO_USE_ONBOARD_MEMORY_AO As Long = 43600
Public Const ND_VXIMIO_USE_ONBOARD_MEMORY_GPCTR As Long = 43700
Public Const ND_VXIMIO_USE_PC_MEMORY_AI As Long = 43200
Public Const ND_VXIMIO_USE_PC_MEMORY_AO As Long = 43300
Public Const ND_VXIMIO_USE_PC_MEMORY_GPCTR As Long = 43400

Public Const ND_WFM_QUANTUM As Long = 45000

Public Const ND_YES As Long = 39100
Public Const ND_3V_LEVEL As Long = 43450

Public Const ND_WRITE_MARK As Long = 50000
Public Const ND_READ_MARK As Long = 50010
Public Const ND_BUFFER_START As Long = 50020
Public Const ND_TRIGGER_POINT As Long = 50025
Public Const ND_BUFFER_MODE As Long = 50030
Public Const ND_DOUBLE As Long = 50050
Public Const ND_QUADRATURE_ENCODER_X1 As Long = 50070
Public Const ND_QUADRATURE_ENCODER_X2 As Long = 50080
Public Const ND_QUADRATURE_ENCODER_X4 As Long = 50090
Public Const ND_TWO_PULSE_COUNTING As Long = 50100
Public Const ND_LINE_FILTER As Long = 50110
Public Const ND_SYNCHRONIZATION As Long = 50120
Public Const ND_5_MICROSECONDS As Long = 50130
Public Const ND_1_MICROSECOND As Long = 50140
Public Const ND_500_NANOSECONDS As Long = 50150
Public Const ND_100_NANOSECONDS As Long = 50160
Public Const ND_1_MILLISECOND As Long = 50170
Public Const ND_10_MILLISECONDS As Long = 50180
Public Const ND_100_MILLISECONDS As Long = 50190


Public Const ND_OTHER_GPCTR_SOURCE As Long = 50580
Public Const ND_OTHER_GPCTR_GATE As Long = 50590
Public Const ND_AUX_LINE As Long = 50600
Public Const ND_AUX_LINE_POLARITY As Long = 50610
Public Const ND_TWO_SIGNAL_EDGE_SEPARATION_MSR As Long = 50630
Public Const ND_BUFFERED_TWO_SIGNAL_EDGE_SEPARATION_MSR As Long = 50640
Public Const ND_SWITCH_CYCLE As Long = 50650
Public Const ND_INTERNAL_MAX_TIMEBASE As Long = 50660
Public Const ND_PRESCALE_VALUE As Long = 50670
Public Const ND_MAX_PRESCALE As Long = 50690
Public Const ND_INTERNAL_LINE_0 As Long = 50710
Public Const ND_INTERNAL_LINE_1 As Long = 50720
Public Const ND_INTERNAL_LINE_2 As Long = 50730
Public Const ND_INTERNAL_LINE_3 As Long = 50740
Public Const ND_INTERNAL_LINE_4 As Long = 50750
Public Const ND_INTERNAL_LINE_5 As Long = 50760
Public Const ND_INTERNAL_LINE_6 As Long = 50770
Public Const ND_INTERNAL_LINE_7 As Long = 50780
Public Const ND_INTERNAL_LINE_8 As Long = 50790
Public Const ND_INTERNAL_LINE_9 As Long = 50800
Public Const ND_INTERNAL_LINE_10 As Long = 50810
Public Const ND_INTERNAL_LINE_11 As Long = 50820
Public Const ND_INTERNAL_LINE_12 As Long = 50830
Public Const ND_INTERNAL_LINE_13 As Long = 50840
Public Const ND_INTERNAL_LINE_14 As Long = 50850
Public Const ND_INTERNAL_LINE_15 As Long = 50860
Public Const ND_INTERNAL_LINE_16 As Long = 50862
Public Const ND_INTERNAL_LINE_17 As Long = 50864
Public Const ND_INTERNAL_LINE_18 As Long = 50866
Public Const ND_INTERNAL_LINE_19 As Long = 50868
Public Const ND_INTERNAL_LINE_20 As Long = 50870
Public Const ND_INTERNAL_LINE_21 As Long = 50872
Public Const ND_INTERNAL_LINE_22 As Long = 50874
Public Const ND_INTERNAL_LINE_23 As Long = 50876

Public Const ND_START_TRIGGER As Long = 51150
Public Const ND_START_TRIGGER_POLARITY As Long = 51151

Public Const ND_COUNTING_SYNCHRONOUS As Long = 51200
Public Const ND_SYNCHRONOUS As Long = 51210
Public Const ND_ASYNCHRONOUS As Long = 51220
Public Const ND_CONFIGURABLE_FILTER As Long = 51230
Public Const ND_ENCODER_TYPE As Long = 51240
Public Const ND_Z_INDEX_ACTIVE As Long = 51250
Public Const ND_Z_INDEX_VALUE As Long = 51260
Public Const ND_SNAPSHOT As Long = 51270
Public Const ND_POSITION_MSR As Long = 51280
Public Const ND_BUFFERED_POSITION_MSR As Long = 51290
Public Const ND_SAVED_COUNT As Long = 51300
Public Const ND_READ_MARK_H_SNAPSHOT As Long = 51310
Public Const ND_READ_MARK_L_SNAPSHOT As Long = 51320
Public Const ND_WRITE_MARK_H_SNAPSHOT As Long = 51330
Public Const ND_WRITE_MARK_L_SNAPSHOT As Long = 51340
Public Const ND_BACKLOG_H_SNAPSHOT As Long = 51350
Public Const ND_BACKLOG_L_SNAPSHOT As Long = 51360
Public Const ND_ARMED_SNAPSHOT As Long = 51370
Public Const ND_EDGE_GATED_FSK As Long = 51371
Public Const ND_SIMPLE_GATED_EVENT_CNT As Long = 51372

Public Const ND_VIDEO_TYPE As Long = 51380
Public Const ND_PAL_B As Long = 51390
Public Const ND_PAL_G As Long = 51400
Public Const ND_PAL_H As Long = 51410
Public Const ND_PAL_I As Long = 51420
Public Const ND_PAL_D As Long = 51430
Public Const ND_PAL_N As Long = 51440
Public Const ND_PAL_M As Long = 51450
Public Const ND_NTSC_M As Long = 51460
Public Const ND_COUNTER_TYPE As Long = 51470
Public Const ND_NI_TIO As Long = 51480
Public Const ND_AM9513 As Long = 51490
Public Const ND_STC As Long = 51500
Public Const ND_8253 As Long = 51510
Public Const ND_A_HIGH_B_HIGH As Long = 51520
Public Const ND_A_HIGH_B_LOW As Long = 51530
Public Const ND_A_LOW_B_HIGH As Long = 51540
Public Const ND_A_LOW_B_LOW As Long = 51550
Public Const ND_Z_INDEX_RELOAD_PHASE As Long = 51560
Public Const ND_UPDOWN_LINE As Long = 51570
Public Const ND_DEFAULT As Long = 51575
Public Const ND_DEFAULT_PFI_LINE As Long = 51580
Public Const ND_BUFFER_SIZE As Long = 51590
Public Const ND_ELEMENT_SIZE As Long = 51600
Public Const ND_NUMBER_GP_COUNTERS As Long = 51610
Public Const ND_BUFFERED_TIME_STAMPING As Long = 51620
Public Const ND_TIME_0_DATA_32 As Long = 51630
Public Const ND_TIME_8_DATA_24 As Long = 51640
Public Const ND_TIME_16_DATA_16 As Long = 51650
Public Const ND_TIME_24_DATA_8 As Long = 51660
Public Const ND_TIME_32_DATA_32 As Long = 51670
Public Const ND_TIME_48_DATA_16 As Long = 51680
Public Const ND_ABSOLUTE As Long = 51690
Public Const ND_RELATIVE As Long = 51700
Public Const ND_TIME_DATA_SIZE As Long = 51710
Public Const ND_TIME_FORMAT As Long = 51720
Public Const ND_HALT_ON_OVERFLOW As Long = 51730
Public Const ND_OVERLAY_RTSI_ON_PFI_LINES As Long = 51740
Public Const ND_STOP_TRIGGER As Long = 51750
Public Const ND_TS_INPUT_MODE As Long = 51760
Public Const ND_BOTH_EDGES As Long = 51770

Public Const ND_CLOCK_0 As Long = 51780
Public Const ND_CLOCK_1 As Long = 51790
Public Const ND_CLOCK_2 As Long = 51800
Public Const ND_CLOCK_3 As Long = 51810
Public Const ND_SYNCHRONIZATION_LINE As Long = 51820
Public Const ND_TRANSFER_METHOD As Long = 51830
Public Const ND_SECONDS As Long = 51840
Public Const ND_PRECISION As Long = 51850
Public Const ND_NANO_SECONDS As Long = 51860
Public Const ND_SYNCHRONIZATION_METHOD As Long = 51870
Public Const ND_PULSE_PER_SECOND As Long = 51880
Public Const ND_IRIG_B As Long = 51890
Public Const ND_SIMPLE_TIME_MSR As Long = 51900
Public Const ND_SINGLE_TIME_MSR As Long = 51910
Public Const ND_BUFFERED_TIME_MSR As Long = 51920
Public Const ND_DMA As Long = 51930
Public Const ND_INTERNAL_SYNCHRONIZATION As Long = 51940
Public Const ND_INITIAL_SECONDS As Long = 51950
Public Const ND_INITIAL_SECONDS_ENABLE As Long = 51951
Public Const ND_EXTERNAL_CALIBRATION As Long = 51990
Public Const ND_INTERNAL_CALIBRATION As Long = 51200
Public Const ND_ABORT_CALIBRATION As Long = 51210
Public Const ND_STORE_CALIBRATION As Long = 51220

Public Const ND_MEASUREMENT_MODE As Long = 51230
Public Const ND_CURRENT As Long = 51240
Public Const ND_FREQUENCY As Long = 52250
Public Const ND_VOLTAGE As Long = 52260
Public Const ND_OHMS As Long = 52270

Public Const ND_EXCITATION_CURRENT As Long = 52280
Public Const ND_FREQ_STARTING_EDGE As Long = 52290
Public Const ND_FREQ_TRIG_LOW As Long = 52300
Public Const ND_FREQ_TRIG_HIGH As Long = 52310
Public Const ND_FREQ_NUM_OF_CYCLES As Long = 52320
Public Const ND_FREQ_TIME_BASE As Long = 52330
Public Const ND_FREQ_LOW_LIMIT As Long = 52340

Public Const ND_AVERAGING_NUM_OF_SAMPLES As Long = 52350
Public Const ND_AVERAGING_FREQUENCY As Long = 52360
Public Const ND_OFFSET_COMP_MODE As Long = 52370

Public Const ND_DIGITAL_LINE As Long = 52380
Public Const ND_DIGITAL_PORT As Long = 52390
Public Const ND_GPCTR0_UP_DOWN As Long = 52400
Public Const ND_GPCTR1_UP_DOWN As Long = 52410
Public Const ND_DIGITAL_LINE_0 As Long = 52420
Public Const ND_DIGITAL_LINE_1 As Long = 52430
Public Const ND_DIGITAL_LINE_2 As Long = 52440
Public Const ND_DIGITAL_LINE_3 As Long = 52450
Public Const ND_DIGITAL_LINE_4 As Long = 52460
Public Const ND_DIGITAL_LINE_5 As Long = 52470
Public Const ND_DIGITAL_LINE_6 As Long = 52480
Public Const ND_DIGITAL_LINE_7 As Long = 52490
Public Const ND_SCARAB_A_MEMORY_SIZE As Long = 52510
Public Const ND_SCARAB_B_MEMORY_SIZE As Long = 52520
Public Const ND_PATTERN_GENERATION_LOOP_ENABLE As Long = 52530
Public Const ND_MEASUREMENT_TYPE As Long = 52540
Public Const ND_DIFFERENTIAL As Long = 52550
Public Const ND_NRSE As Long = 52560
Public Const ND_4WIRE As Long = 52570
Public Const ND_READ_MARK_H_SNAPSHOT_GR1 As Long = 52580
Public Const ND_READ_MARK_L_SNAPSHOT_GR1 As Long = 52590
Public Const ND_READ_MARK_H_SNAPSHOT_GR2 As Long = 52600
Public Const ND_READ_MARK_L_SNAPSHOT_GR2 As Long = 52610
Public Const ND_WRITE_MARK_H_SNAPSHOT_GR1 As Long = 52620
Public Const ND_WRITE_MARK_L_SNAPSHOT_GR1 As Long = 52630
Public Const ND_WRITE_MARK_H_SNAPSHOT_GR2 As Long = 52640
Public Const ND_WRITE_MARK_L_SNAPSHOT_GR2 As Long = 52650

Public Const ND_PARAM_SCXI_SETTLING_TIME As Long = 52710
Public Const ND_PARAM_USER_DEFINED_SETTLING_TIME As Long = 52720
Public Const ND_PARAM_SCXI_SCAN_INFO As Long = 52730
Public Const ND_PARAM_SCXI_MODULE_CODE As Long = 52740
Public Const ND_PARAM_SCXI_DUMMY As Long = 52750
Public Const ND_PARAM_CHANNEL_NAME As Long = 52760
Public Const ND_PARAM_TASKID As Long = 52770
Public Const ND_PARAM_CJC As Long = 52780
Public Const ND_PARAM_CHANNEL_CLOCK_TIMEBASE As Long = 52790
Public Const ND_PARAM_CHANNEL_CLOCK_INTERVAL As Long = 52800
Public Const ND_PARAM_CHANNEL_CLOCK_FREQUENCY As Long = 52810
Public Const ND_PARAM_CHANNEL_CLOCK_SOURCE As Long = 52820
Public Const ND_PARAM_CHANNEL_CLOCK_DEFAULT As Long = 52830
Public Const ND_PARAM_SCAN_CLOCK_TIMEBASE As Long = 52840
Public Const ND_PARAM_SCAN_CLOCK_INTERVAL As Long = 52850
Public Const ND_PARAM_SCAN_CLOCK_FREQUENCY As Long = 52860
Public Const ND_PARAM_SCAN_CLOCK_SOURCE As Long = 52870
Public Const ND_PARAM_SCAN_CLOCK_DEFAULT As Long = 52880
Public Const ND_PARAM_NUM_CHANNELS As Long = 52890


'-------------------------------------------------------
'Function for handling National Instruments error codes.
'-------------------------------------------------------

Public Function NICode(ByVal iErr As Integer) As String
    '7 July 2004 CGL.
    'This function translates error codes into description strings.
    NICode = "(Error number " & iErr & " is not in the National Instruments documentation.)"
    If (iErr = -10001) Then NICode = "-10001 syntaxError An error was detected in the input string; the arrangement or ordering of the characters in the string is not consistent with the expected ordering."
    If (iErr = -10002) Then NICode = "-10002  semanticsError  An error was detected in the input string; the syntax of the string is correct, but certain values specified in the string are inconsistent with other values specified in the string."
    If (iErr = -10003) Then NICode = "-10003  invalidValueError   The value of a numeric parameter is invalid."
    If (iErr = -10004) Then NICode = "-10004  valueConflictError  The value of a numeric parameter is inconsistent with another one, and therefore the combination is invalid."
    If (iErr = -10005) Then NICode = "-10005  badDeviceError  The device is invalid."
    If (iErr = -10006) Then NICode = "-10006  badLineError    The line is invalid."
    If (iErr = -10007) Then NICode = "-10007  badChanError    A channel, port, or counter is out of range for the device type or device configuration; or the combination of channels is not allowed; or the scan order must be reversed (0 last)."
    If (iErr = -10008) Then NICode = "-10008  badGroupError   The group is invalid."
    If (iErr = -10009) Then NICode = "-10009  badCounterError The counter is invalid."
    If (iErr = -10010) Then NICode = "-10010  badCountError   The count is too small or too large for the specified counter, or the given I/O transfer count is not appropriate for the current buffer or channel configuration."
    If (iErr = -10011) Then NICode = "-10011  badIntervalError    The analog input scan rate is too fast for the number of channels and the channel clock rate; or the given clock rate is not supported by the associated counter channel or I/O channel."
    If (iErr = -10012) Then NICode = "-10012  badRangeError   The analog input or analog output voltage or current range is invalid for the specified channel, or you are writing an invalid voltage or current to the analog output."
    If (iErr = -10013) Then NICode = "-10013  badErrorCodeError   The driver returned an unrecognized or unlisted error code."
    If (iErr = -10014) Then NICode = "-10014  groupTooLargeError  The group size is too large for the board."
    If (iErr = -10015) Then NICode = "-10015  badTimeLimitError   The time limit is invalid."
    If (iErr = -10016) Then NICode = "-10016  badReadCountError   The read count is invalid."
    If (iErr = -10017) Then NICode = "-10017  badReadModeError    The read mode is invalid."
    If (iErr = -10018) Then NICode = "-10018  badReadOffsetError  The offset is unreachable."
    If (iErr = -10019) Then NICode = "-10019  badClkFrequencyError    The frequency is invalid."
    If (iErr = -10020) Then NICode = "-10020  badTimebaseError    The timebase is invalid."
    If (iErr = -10021) Then NICode = "-10021  badLimitsError  The limits are beyond the range of the board."
    If (iErr = -10022) Then NICode = "-10022  badWriteCountError  Your data array contains an incomplete update, or you are trying to write past the end of the internal buffer, or your output operation is continuous and the length of your array is not a multiple of one half of the internal buffer size."
    If (iErr = -10023) Then NICode = "-10023  badWriteModeError   The write mode is out of range or is disallowed."
    If (iErr = -10024) Then NICode = "-10024  badWriteOffsetError Adding the write offset to the write mark places the write mark outside the internal buffer."
    If (iErr = -10025) Then NICode = "-10025  limitsOutOfRangeError   The requested input limits exceed the board's capability or configuration.  Alternative limits were selected."
    If (iErr = -10026) Then NICode = "-10026  badBufferSpecificationError The requested number of buffers or the buffer size is not allowed. For example,  the buffer limit for Lab and 1200 devices is 64K samples, or the board does not support multiple buffers."
    If (iErr = -10027) Then NICode = "-10027  badDAQEventError    For DAQEvents 0 and 1 general value A must be greater than 0 and less than the internal buffer size.  If DMA is used for DAQEvent 1, general value A must divide the internal buffer size evenly, with no remainder.  If the TIO-10 is used for DAQEvent 4, general value A must be 1 or 2."
    If (iErr = -10028) Then NICode = "-10028  badFilterCutoffError    The cutoff frequency specified is not valid for this device."
    If (iErr = -10029) Then NICode = "-10029  obsoleteFunctionError   The function you are calling is no longer supported in this version of the driver."
    If (iErr = -10030) Then NICode = "-10030  badBaudRateError    The specified baud rate for communicating with the serial port is not valid on this platform."
    If (iErr = -10031) Then NICode = "-10031  badChassisIDError   The specified SCXI chassis does not correspond to a configured SCXI chassis."
    If (iErr = -10032) Then NICode = "-10032  badModuleSlotError  The SCXI module slot that was specified is invalid or corresponds to an empty slot."
    If (iErr = -10033) Then NICode = "-10033  invalidWinHandleError   The window handle passed to the function is invalid."
    If (iErr = -10034) Then NICode = "-10034  noSuchMessageError  No configured message matches the one you tried to delete."
    If (iErr = -10035) Then NICode = "-10035  irrelevantAttributeError    The specified attribute is not relevant."
    If (iErr = -10036) Then NICode = "-10036  badYearError    The specified year is invalid."
    If (iErr = -10037) Then NICode = "-10037  badMonthError   The specified month is invalid."
    If (iErr = -10038) Then NICode = "-10038  badDayError The specified day is invalid."
    If (iErr = -10039) Then NICode = "-10039  stringTooLongError  The specified input string is too long.  For instance, DAQScope 5102 devices can only store a string up to 32 bytes in length on the calibration EEPROM.  In that case, please shorten the string."
    If (iErr = -10040) Then NICode = "-10040  badGroupSizeError   The group size is invalid."
    If (iErr = -10041) Then NICode = "-10041  badTaskIDError  The specified task ID is invalid. For instance, you may have connected a taskID from an Analog Input VI to a Digital I/O VI."
    If (iErr = -10042) Then NICode = "-10042  inappropriateControlCodeError   The specified control code is inappropriate for the current configuration or state."
    If (iErr = -10043) Then NICode = "-10043  badDivisorError The specified divisor is invalid."
    If (iErr = -10044) Then NICode = "-10044  badPolarityError    The specified polarity is invalid."
    If (iErr = -10045) Then NICode = "-10045  badInputModeError   The specified input mode is invalid."
    If (iErr = -10046) Then NICode = "-10046  badExcitationError  The excitation value specified is not valid for this device."
    If (iErr = -10047) Then NICode = "-10047  badConnectionTypeError  The type of SCXI channel connection specified is not valid for this module."
    If (iErr = -10048) Then NICode = "-10048  badExcitationTypeError  The excitation type specified is not valid for this device."
    If (iErr = -10050) Then NICode = "-10050  badChanListError    There is more than one channel name in the channel list that corresponds to the same hardware channel."
    If (iErr = -10079) Then NICode = "-10079  badTrigSkipCountError   The trigger skip count is invalid."
    If (iErr = -10080) Then NICode = "-10080  badGainError    The gain or gain adjust is invalid."
    If (iErr = -10081) Then NICode = "-10081  badPretrigCountError    The pretrigger sample count is invalid."
    If (iErr = -10082) Then NICode = "-10082  badPosttrigCountError   The posttrigger sample count is invalid."
    If (iErr = -10083) Then NICode = "-10083  badTrigModeError    The trigger mode is invalid."
    If (iErr = -10084) Then NICode = "-10084  badTrigCountError   The trigger count is invalid."
    If (iErr = -10085) Then NICode = "-10085  badTrigRangeError   The trigger range or trigger hysteresis window is invalid."
    If (iErr = -10086) Then NICode = "-10086  badExtRefError  The external reference  is invalid."
    If (iErr = -10087) Then NICode = "-10087  badTrigTypeError    The trigger type is invalid."
    If (iErr = -10088) Then NICode = "-10088  badTrigLevelError   The trigger level is invalid."
    If (iErr = -10089) Then NICode = "-10089  badTotalCountError  The total count is inconsistent with the buffer size and pretrigger scan count or with the board type."
    If (iErr = -10090) Then NICode = "-10090  badRPGError The individual range, polarity, and gain settings are valid but the combination is not allowed."
    If (iErr = -10091) Then NICode = "-10091  badIterationsError  You have attempted to use an invalid setting for the iterations parameter. The iterations value must be 0 or greater. Your device might be limited to only two values, 0 and 1."
    If (iErr = -10092) Then NICode = "-10092  lowScanIntervalError    Some devices require a time gap between the last sample in a scan and the start of the next scan. The scan interval you have specified does not provide a large enough gap for the board. See your documentation for an explanation."
    If (iErr = -10093) Then NICode = "-10093  fifoModeError   FIFO mode waveform generation cannot be used because at least one condition is not satisfied."
    If (iErr = -10094) Then NICode = "-10094  badCalDACconstError The calDAC constant passed to the function is invalid."
    If (iErr = -10095) Then NICode = "-10095  badCalStimulusError The calibration stimulus passed to the function is invalid."
    If (iErr = -10096) Then NICode = "-10096  badCalibrationConstantError The specified calibration constant is invalid."
    If (iErr = -10097) Then NICode = "-10097  badCalOpError   The specified calibration operation is invalid."
    If (iErr = -10098) Then NICode = "-10098  badCalConstAreaError    The specified calibration constant area is invalid.  For instance, the specified calibration constant area contains constants which cannot be modified outside the factory."
    If (iErr = -10100) Then NICode = "-10100  badPortWidthError   The requested digital port width is not a multiple of the hardware port width or is not attainable by the DAQ hardware."
    If (iErr = -10120) Then NICode = "-10120  gpctrBadApplicationError    Invalid application used."
    If (iErr = -10121) Then NICode = "-10121  gpctrBadCtrNumberError  Invalid counterNumber used."
    If (iErr = -10122) Then NICode = "-10122  gpctrBadParamValueError Invalid paramValue used."
    If (iErr = -10123) Then NICode = "-10123  gpctrBadParamIDError    Invalid paramID used."
    If (iErr = -10124) Then NICode = "-10124  gpctrBadEntityIDError   Invalid entityID used."
    If (iErr = -10125) Then NICode = "-10125  gpctrBadActionError Invalid action used."
    If (iErr = -10126) Then NICode = "-10126  gpctrSourceSelectError  Invalid source selected."
    If (iErr = -10127) Then NICode = "-10127  badCountDirError    The specified counter does not support the specified count direction."
    If (iErr = -10128) Then NICode = "-10128  badGateOptionError  The specified gating option is invalid."
    If (iErr = -10129) Then NICode = "-10129  badGateModeError    The specified gate mode is invalid."
    If (iErr = -10130) Then NICode = "-10130  badGateSourceError  The specified gate source is invalid."
    If (iErr = -10131) Then NICode = "-10131  badGateSignalError  The specified gate signal is invalid."
    If (iErr = -10132) Then NICode = "-10132  badSourceEdgeError  The specified source edge is invalid."
    If (iErr = -10133) Then NICode = "-10133  badOutputTypeError  The specified output type is invalid."
    If (iErr = -10134) Then NICode = "-10134  badOutputPolarityError  The specified output polarity is invalid."
    If (iErr = -10135) Then NICode = "-10135  badPulseModeError   The specified pulse mode is invalid."
    If (iErr = -10136) Then NICode = "-10136  badDutyCycleError   The specified duty cycle is invalid."
    If (iErr = -10137) Then NICode = "-10137  badPulsePeriodError The specified pulse period is invalid."
    If (iErr = -10138) Then NICode = "-10138  badPulseDelayError  The specified pulse delay is invalid."
    If (iErr = -10139) Then NICode = "-10139  badPulseWidthError  The specified pulse width is invalid."
    If (iErr = -10140) Then NICode = "-10140  badFOUTportError    The specified frequency output (FOUT or FREQ_OUT) port is invalid."
    If (iErr = -10141) Then NICode = "-10141  badAutoIncrementModeError   The specified autoincrement mode is invalid."
    If (iErr = -10150) Then NICode = "-10150  CfgInvalidatedSysCalError   Hardware configuration has changed since last system calibration"
    If (iErr = -10151) Then NICode = "-10151  sysCalOutofDateError    system calibration is out of date"
    If (iErr = -10180) Then NICode = "-10180  badNotchFilterError The specified notch filter is invalid."
    If (iErr = -10181) Then NICode = "-10181  badMeasModeError    The specified measurement mode is invalid."
    If (iErr = -10200) Then NICode = "-10200  EEPROMreadError Unable to read data from EEPROM."
    If (iErr = -10201) Then NICode = "-10201  EEPROMwriteError    Unable to write data to EEPROM."
    If (iErr = -10202) Then NICode = "-10202  EEPROMwriteProtectionError  You cannot write into this location or area of your EEPROM because it is writeprotected.  You may be trying to store calibration constants into a writeprotected area;  if this is the case, you should select user area of the EEPROM instead."
    If (iErr = -10203) Then NICode = "-10203  EEPROMinvalidLocationError  The specified EEPROM location is invalid."
    If (iErr = -10204) Then NICode = "-10204  EEPROMinvalidPasswordError  The password for accessing the EEPROM is incorrect."
    If (iErr = -10240) Then NICode = "-10240  noDriverError   The driver interface could not locate or open the driver.."
    If (iErr = -10241) Then NICode = "-10241  oldDriverError  One of the driver files or the configuration utility is out of date, or a particular feature of the Channel Wizard is not supported in this version of the driver."
    If (iErr = -10242) Then NICode = "-10242  functionNotFoundError   The specified function is not located in the driver."
    If (iErr = -10243) Then NICode = "-10243  configFileError The driver could not locate or open the configuration file, or the format of the configuration file is not compatible with the currently installed driver."
    If (iErr = -10244) Then NICode = "-10244  deviceInitError The driver encountered a hardware-initialization error while attempting to configure the specified device."
    If (iErr = -10245) Then NICode = "-10245  osInitError The driver encountered an operating-system error while attempting to perform an operation, or the operating system does not support an operation performed by the driver."
    If (iErr = -10246) Then NICode = "-10246  communicationsError The driver is unable to communicate with the specified external device."
    If (iErr = -10247) Then NICode = "-10247  cmosConfigError The CMOS configuration-memory for the device is empty or invalid, or the configuration specified does not agree with the current configuration of the device, or the EISA system configuration is invalid."
    If (iErr = -10248) Then NICode = "-10248  dupAddressError The base addresses for two or more devices are the same; consequently, the driver is unable to access the specified device."
    If (iErr = -10249) Then NICode = "-10249  intConfigError  The interrupt configuration is incorrect given the capabilities of the computer or device."
    If (iErr = -10250) Then NICode = "-10250  dupIntError The interrupt levels for two or more devices are the same."
    If (iErr = -10251) Then NICode = "-10251  dmaConfigError  The DMA configuration is incorrect given the capabilities of the computer/DMA controller or device."
    If (iErr = -10252) Then NICode = "-10252  dupDMAError The DMA channels for two or more devices are the same."
    If (iErr = -10253) Then NICode = "-10253  jumperlessBoardError    Unable to find one or more jumperless boards you have configured using the Measurement  as long  Automation Explorer."
    If (iErr = -10254) Then NICode = "-10254  DAQCardConfError    Cannot configure the DAQCard because 1) the correct version of the card and socket services software is not installed; 2) the card in the PCMCIA socket is not a DAQCard; or 3) the base address and/or interrupt level requested are not available according to the card and socket services resource manager.  Try different settings or use AutoAssign in the Measurement  as long  Automation Explorer."
    If (iErr = -10255) Then NICode = "-10255  remoteChassisDriverInitError    There was an error in initializing the driver for Remote SCXI."
    If (iErr = -10256) Then NICode = "-10256  comPortOpenError    There was an error in opening the specified COM port."
    If (iErr = -10257) Then NICode = "-10257  baseAddressError    Bad base address specified in Measurement  as long  Automation Explorer."
    If (iErr = -10258) Then NICode = "-10258  dmaChannel1Error    Bad DMA channel 1 specified in Measurement  as long  Automation Explorer or by the operating system."
    If (iErr = -10259) Then NICode = "-10259  dmaChannel2Error    Bad DMA channel 2 specified in Measurement  as long  Automation Explorer or by the operating system."
    If (iErr = -10260) Then NICode = "-10260  dmaChannel3Error    Bad DMA channel 3 specified in Measurement  as long  Automation Explorer or by the operating system."
    If (iErr = -10261) Then NICode = "-10261  userModeToKernelModeCallError   The user mode code failed when calling the kernel mode code."
    If (iErr = -10340) Then NICode = "-10340  noConnectError  No RTSI or PFI signal/line is connected, or the specified signal and the specified line are not connected, or your connection to an RDA server either cannot be made or has been terminated."
    If (iErr = -10341) Then NICode = "-10341  badConnectError The RTSI or PFI signal/line cannot be connected as specified."
    If (iErr = -10342) Then NICode = "-10342  multConnectError    The specified RTSI signal is already being driven by a RTSI line, or the specified RTSI line is already being driven by a RTSI signal."
    If (iErr = -10343) Then NICode = "-10343  SCXIConfigError The specified SCXI configuration parameters are invalid, or the function cannot be executed with the current SCXI configuration."
    If (iErr = -10344) Then NICode = "-10344  chassisSynchedError The Remote SCXI unit is not synchronized with the host. Reset the chassis again to resynchronize it with the host."
    If (iErr = -10345) Then NICode = "-10345  chassisMemAllocError    The required amount of memory cannot be allocated on the Remote SCXI unit for the specified operation."
    If (iErr = -10346) Then NICode = "-10346  badPacketError  The packet received by the Remote SCXI unit is invalid.  Check your serial port cable connections."
    If (iErr = -10347) Then NICode = "-10347  chassisCommunicationError   There was an error in sending a packet to the remote chassis.  Check your serial port cable connections."
    If (iErr = -10348) Then NICode = "-10348  waitingForReprogError   The Remote SCXI unit is in reprogramming mode and is waiting for reprogramming commands from the host (Measurement  as long  Automation Explorer)."
    If (iErr = -10349) Then NICode = "-10349  SCXIModuleTypeConflictError The module ID read from the SCXI module conflicts with the configured module type."
    If (iErr = -10350) Then NICode = "-10350  CannotDetermineEntryModuleError Neither an SCXI entry module (i.e.: the SCXI module cabled to the measurement device that performs the acquisition/control operation) has been specified by the user, nor can NI-DAQ uniquely determine the entry module for the current SCXI configuration."
    If (iErr = -10360) Then NICode = "-10360  DSPInitError    The DSP driver was unable to load the kernel for its operating system."
    If (iErr = -10370) Then NICode = "-10370  badScanListError    The scan list is invalid; for example, you are mixing AMUX-64T channels and onboard channels, scanning SCXI channels out of order, or have specified a different starting channel for the same SCXI module.  Also, the driver attempts to achieve complicated gain distributions over SCXI channels on the same module by manipulating the scan list and returns this error if it fails."
    If (iErr = -10380) Then NICode = "-10380  invalidSignalSrcError   The specified signal source is invalid for the selected signal name."
    If (iErr = -10381) Then NICode = "-10381  invalidSignalNameError  The specified signal name is invalid."
    If (iErr = -10382) Then NICode = "-10382  invalidSrcSpecError The specified source specification is invalid for the signal source or signal name."
    If (iErr = -10383) Then NICode = "-10383  invalidSignalDestError  The specified signal destination is invalid."
    If (iErr = -10390) Then NICode = "-10390  routingError    The routing manager was unable to complete the request due to a lack of resources, or because the required resources are reserved."
    If (iErr = -10391) Then NICode = "-10391  pfiBadLineError The routing manager was unable to complete the request due to an invalid PFI line number."
    If (iErr = -10392) Then NICode = "-10392  pfiGPCTRNotRoutedError  The specified General Purpose Counter Output and/or Up/Down signal(s) are not routed to any PFI lines."
    If (iErr = -10393) Then NICode = "-10393  pfiDefaultLineUndefinedError    A default PFI line does not exist for the given signal.  You must specify the PFI line either explicitly in the VI, or through the PFI line configuration VI."
    If (iErr = -10394) Then NICode = "-10394  pfiDoubleRoutingError   Given PFI line is already reserved for a different signal, or given signal has already reserved a different PFI line."
    If (iErr = -10400) Then NICode = "-10400  userOwnedRsrcError  The specified resource is owned by the user and cannot be accessed or modified by the driver."
    If (iErr = -10401) Then NICode = "-10401  unknownDeviceError  The specified device is not a National Instruments product, the driver does not support the device (for example, the driver was released before the device was supported), or the device has not been configured using the Measurement  as long  Automation Explorer."
    If (iErr = -10402) Then NICode = "-10402  deviceNotFoundError No device is located in the specified slot or at the specified address."
    If (iErr = -10403) Then NICode = "-10403  deviceSupportError  The specified device does not support the requested action (the driver recognizes the device, but the action is inappropriate for the device)."
    If (iErr = -10404) Then NICode = "-10404  noLineAvailError    No line is available."
    If (iErr = -10405) Then NICode = "-10405  noChanAvailError    No channel is available."
    If (iErr = -10406) Then NICode = "-10406  noGroupAvailError   No group is available."
    If (iErr = -10407) Then NICode = "-10407  lineBusyError   The specified line is in use."
    If (iErr = -10408) Then NICode = "-10408  chanBusyError   The specified channel is in use."
    If (iErr = -10409) Then NICode = "-10409  groupBusyError  The specified group is in use."
    If (iErr = -10410) Then NICode = "-10410  relatedLCGBusyError A related line, channel, or group is in use; if the driver configures the specified line, channel, or group, the configuration, data, or handshaking lines for the related line, channel, or group will be disturbed."
    If (iErr = -10411) Then NICode = "-10411  counterBusyError    The specified counter is in use."
    If (iErr = -10412) Then NICode = "-10412  noGroupAssignError  No group is assigned, or the specified line or channel cannot be assigned to a group."
    If (iErr = -10413) Then NICode = "-10413  groupAssignError    A group is already assigned, or the specified line or channel is already assigned to a group."
    If (iErr = -10414) Then NICode = "-10414  reservedPinError    The selected signal requires a pin that is reserved and configured only by NI-DAQ.  You cannot configure this pin yourself."
    If (iErr = -10415) Then NICode = "-10415  externalMuxSupportError This function does not support your DAQ device when an external multiplexer (such as an AMUX64T or SCXI) is connected to it."
    If (iErr = -10440) Then NICode = "-10440  sysOwnedRsrcError   The specified resource is owned by the driver and cannot be accessed or modified by the user."
    If (iErr = -10441) Then NICode = "-10441  memConfigError  No memory is configured to support the current data-transfer mode, or the configured memory does not support the current data-transfer mode.  (If block transfers are in use, the memory must be capable of performing block transfers.)"
    If (iErr = -10442) Then NICode = "-10442  memDisabledError    The specified memory is disabled or is unavailable given the current addressing mode."
    If (iErr = -10443) Then NICode = "-10443  memAlignmentError   The transfer buffer is not aligned properly for the current data-transfer mode.  For example, the buffer is at an odd address, is not aligned to a 32-bit boundary, is not aligned to a 512-bit boundary, and so on.  Alternatively, the driver is unable to align the buffer because the buffer is too small.  For DSA devices, buffer should be an array of i32.  These devices return the data in a 32-bit format in which the data bits are in the most significant bits.  The buffer must be aligned on a 4-byte boundary.  If the buffer is allocated as an array of i32s, it must be typecast to an i16 pointer when passing its address to DAQ_Op.  If the buffer is allocated as a double-sized array of i16s, the user must check that the buffer is aligned on a 4-byte boundary before passing the buffer to DAQ_Op."
    If (iErr = -10444) Then NICode = "-10444  memFullError    No more system memory is available on the heap, or no more memory is available on the device, or insufficient disk space is available."
    If (iErr = -10445) Then NICode = "-10445  memLockError    The transfer buffer cannot be locked into physical memory. On PC AT machines, portions of the DMA data acquisition buffer may be in an invalid DMA region, for example, above 16 megabytes."
    If (iErr = -10446) Then NICode = "-10446  memPageError    The transfer buffer contains a page break; system resources may require reprogramming when the page break is encountered."
    If (iErr = -10447) Then NICode = "-10447  memPageLockError    The operating environment is unable to grant a page lock."
    If (iErr = -10448) Then NICode = "-10448  stackMemError   The driver is unable to continue parsing a string input due to stack limitations."
    If (iErr = -10449) Then NICode = "-10449  cacheMemError   A cache-related error occurred, or caching is not supported in the current mode."
    If (iErr = -10450) Then NICode = "-10450  physicalMemError    A hardware error occurred in physical memory, or no memory is located at the specified address."
    If (iErr = -10451) Then NICode = "-10451  virtualMemError The driver is unable to make the transfer buffer contiguous in virtual memory and therefore cannot lock it into physical memory; thus, the buffer cannot be used for DMA transfers."
    If (iErr = -10452) Then NICode = "-10452  noIntAvailError No interrupt level is available for use."
    If (iErr = -10453) Then NICode = "-10453  intInUseError   The specified interrupt level is already in use by another device."
    If (iErr = -10454) Then NICode = "-10454  noDMACError No DMA controller is available in the system."
    If (iErr = -10455) Then NICode = "-10455  noDMAAvailError No DMA channel is available for use."
    If (iErr = -10456) Then NICode = "-10456  DMAInUseError   The specified DMA channel is already in use by another device."
    If (iErr = -10457) Then NICode = "-10457  badDMAGroupError    DMA cannot be configured for the specified group because it is too small, too large, or misaligned.  Consult the device user manual to determine group ramifications with respect to DMA."
    If (iErr = -10458) Then NICode = "-10458  diskFullError   The storage disk you specified is full."
    If (iErr = -10459) Then NICode = "-10459  DLLInterfaceError   The NI-DAQ DLL could not be called due to an interface error."
    If (iErr = -10460) Then NICode = "-10460  interfaceInteractionError   You have mixed VIs from the DAQ library and the _DAQ compatibility library (LabVIEW 2.2 style VIs).  You may switch between the two libraries only by running the DAQ VI Device Reset before calling _DAQ compatibility VIs or by running the compatibility VI Board Reset before calling DAQ VIs."
    If (iErr = -10461) Then NICode = "-10461  resourceReservedError   The specified resource is unavailable because it has already been reserved by another entity."
    If (iErr = -10462) Then NICode = "-10462  resourceNotReservedError    The specified resource has not been reserved, so the action is not allowed."
    If (iErr = -10463) Then NICode = "-10463  mdResourceAlreadyReservedError  Another entity has already reserved the requested resource."
    If (iErr = -10464) Then NICode = "-10464  mdResourceReservedError Attempted to access a reserved resource that requires the usage of a key."
    If (iErr = -10465) Then NICode = "-10465  mdResourceNotReservedError  Attempting to lift a reservation off a resouce that previously had no reservation."
    If (iErr = -10466) Then NICode = "-10466  mdResourceAccessKeyError    The requested operation cannot be performed because the key supplied is invalid."
    If (iErr = -10467) Then NICode = "-10467  mdResourceNotRegisteredError    The resource requested is not registered with the minidriver."
    If (iErr = -10480) Then NICode = "-10480  muxMemFullError The scan list is too large to fit into the mux-gain memory of the board."
    If (iErr = -10481) Then NICode = "-10481  bufferNotInterleavedError   You must provide a single buffer of interleaved data, and the channels must be in ascending order.  You cannot use DMA to transfer data from two buffers; however, you may be able to use interrupts."
    If (iErr = -10482) Then NICode = "-10482  waveformBufferSizeError You have specified channels with different waveform lengths. To fix the problem, ensure that the waveform data for every channel has the same number of array elements."
    If (iErr = -10540) Then NICode = "-10540  SCXIModuleNotSupportedError At least one of the SCXI modules specified is not supported for the operation."
    If (iErr = -10541) Then NICode = "-10541  TRIG1ResourceConflict   CTRB1 will drive COUTB1, however CTRB1 will also drive TRIG1.  This may cause unpredictable results when scanning the chassis."
    If (iErr = -10542) Then NICode = "-10542  matrixTerminalBlockError    This function requires that no Matrix terminal block is configured with the SCXI module."
    If (iErr = -10543) Then NICode = "-10543  noMatrixTerminalBlockError  This function requires that some matrix terminal block is configured with the SCXI module."
    If (iErr = -10544) Then NICode = "-10544  invalidMatrixTerminalBlockError The type of matrix terminal block configured will not allow proper operation of this function with the given parameters."
    If (iErr = -10560) Then NICode = "-10560  invalidDSPHandleError   The DSP handle input is not valid ."
    If (iErr = -10561) Then NICode = "-10561  DSPDataPathBusyError    Either DAQ or WFM can use a PC memory buffer, but not both at the same time."
    If (iErr = -10600) Then NICode = "-10600  noSetupError    No setup operation has been performed for the specified resources. Or, some resources require a specific ordering of calls for proper setup."
    If (iErr = -10601) Then NICode = "-10601  multSetupError  The specified resources have already been configured by a setup operation."
    If (iErr = -10602) Then NICode = "-10602  noWriteError    No output data has been written into the transfer buffer."
    If (iErr = -10603) Then NICode = "-10603  groupWriteError The output data associated with a group must be for a single channel or must be for consecutive channels."
    If (iErr = -10604) Then NICode = "-10604  activeWriteError    Once data generation has started, only the transfer buffers originally written to may be updated.  If DMA is active and a single transfer buffer contains interleaved channel-data, new data must be provided for all output channels currently using the DMA channel."
    If (iErr = -10605) Then NICode = "-10605  endWriteError   No data was written to the transfer buffer because the final data block has already been loaded."
    If (iErr = -10606) Then NICode = "-10606  notArmedError   The specified resource is not armed."
    If (iErr = -10607) Then NICode = "-10607  armedError  The specified resource is already armed."
    If (iErr = -10608) Then NICode = "-10608  noTransferInProgError   No transfer is in progress for the specified resource."
    If (iErr = -10609) Then NICode = "-10609  transferInProgError A transfer is already in progress for the specified resource, or the operation is not allowed because the device is in the process of performing transfers, possibly with different resources."
    If (iErr = -10610) Then NICode = "-10610  transferPauseError  A single output channel in a group may not be paused if the output data for the group is interleaved."
    If (iErr = -10611) Then NICode = "-10611  badDirOnSomeLinesError  Some of the lines in the specified channel are not configured for the transfer direction specified.  For a write transfer, some lines are configured for input.  For a read transfer, some lines are configured for output."
    If (iErr = -10612) Then NICode = "-10612  badLineDirError The specified line does not support the specified transfer direction."
    If (iErr = -10613) Then NICode = "-10613  badChanDirError The specified channel does not support the specified transfer direction, or you have performed an operation on a digital port or line configured for the opposite direction."
    If (iErr = -10614) Then NICode = "-10614  badGroupDirError    The specified group does not support the specified transfer direction."
    If (iErr = -10615) Then NICode = "-10615  masterClkError  The clock configuration for the clock master is invalid."
    If (iErr = -10616) Then NICode = "-10616  slaveClkError   The clock configuration for the clock slave is invalid."
    If (iErr = -10617) Then NICode = "-10617  noClkSrcError   No source signal has been assigned to the clock resource."
    If (iErr = -10618) Then NICode = "-10618  badClkSrcError  The specified source signal cannot be assigned to the clock resource."
    If (iErr = -10619) Then NICode = "-10619  multClkSrcError A source signal has already been assigned to the clock resource."
    If (iErr = -10620) Then NICode = "-10620  noTrigError No trigger signal has been assigned to the trigger resource."
    If (iErr = -10621) Then NICode = "-10621  badTrigError    The specified trigger signal cannot be assigned to the trigger resource."
    If (iErr = -10622) Then NICode = "-10622  preTrigError    The pretrigger mode is not supported or is not available in the current configuration, or no pretrigger source has been assigned."
    If (iErr = -10623) Then NICode = "-10623  postTrigError   No posttrigger source has been assigned."
    If (iErr = -10624) Then NICode = "-10624  delayTrigError  The delayed trigger mode is not supported or is not available in the current configuration, or no delay source has been assigned."
    If (iErr = -10625) Then NICode = "-10625  masterTrigError The trigger configuration for the trigger master is invalid."
    If (iErr = -10626) Then NICode = "-10626  slaveTrigError  The trigger configuration for the trigger slave is invalid."
    If (iErr = -10627) Then NICode = "-10627  noTrigDrvError  No signal has been assigned to the trigger resource."
    If (iErr = -10628) Then NICode = "-10628  multTrigDrvError    A signal has already been assigned to the trigger resource."
    If (iErr = -10629) Then NICode = "-10629  invalidOpModeError  The specified operating mode is invalid, or the resources have not been configured for the specified operating mode."
    If (iErr = -10630) Then NICode = "-10630  invalidReadError    The parameters specified to read data were invalid in the context of the acquisition. For example, an attempt was made to read 0 bytes from the transfer buffer, or an attempt was made to read past the end of the transfer buffer."
    If (iErr = -10631) Then NICode = "-10631  noInfiniteModeError Continuous input or output transfers are not allowed in the current operating mode, or continuous operation is not allowed for this type of device."
    If (iErr = -10632) Then NICode = "-10632  someInputsIgnoredError  Certain inputs were ignored because they are not relevant in the current operating mode."
    If (iErr = -10633) Then NICode = "-10633  invalidRegenModeError   The specified analog output regeneration mode is not allowed for this board."
    If (iErr = -10634) Then NICode = "-10634  noContTransferInProgressError   No continuous (double buffered) transfer is in progress for the specified resource."
    If (iErr = -10635) Then NICode = "-10635  invalidSCXIOpModeError  Either the SCXI operating mode specified in a configuration call is invalid, or a module is in the wrong operating mode to execute the function call."
    If (iErr = -10636) Then NICode = "-10636  noContWithSynchError    You cannot start a continuous (double-buffered) operation with a synchronous function call."
    If (iErr = -10637) Then NICode = "-10637  bufferAlreadyConfigError    Attempted to configure a buffer after the buffer had already been configured. You can configure a buffer only once."
    If (iErr = -10638) Then NICode = "-10638  badClkDestError The clock cannot be assigned to the specified destination."
    If (iErr = -10670) Then NICode = "-10670  rangeBadForMeasModeError    The input range is invalid for the configured measurement mode."
    If (iErr = -10671) Then NICode = "-10671  autozeroModeConflictError   Autozero cannot be enabled for the configured measurement mode."
    If (iErr = -10680) Then NICode = "-10680  badChanGainError    All channels of this board must have the same gain."
    If (iErr = -10681) Then NICode = "-10681  badChanRangeError   All channels of this board must have the same range."
    If (iErr = -10682) Then NICode = "-10682  badChanPolarityError    All channels of this board must be the same polarity."
    If (iErr = -10683) Then NICode = "-10683  badChanCouplingError    All channels of this board must have the same coupling."
    If (iErr = -10684) Then NICode = "-10684  badChanInputModeError   All channels of this board must have the same input mode."
    If (iErr = -10685) Then NICode = "-10685  clkExceedsBrdsMaxConvRateError  The clock rate exceeds the board's recommended maximum rate."
    If (iErr = -10686) Then NICode = "-10686  scanListInvalidError    A configuration change has invalidated the scan list."
    If (iErr = -10687) Then NICode = "-10687  bufferInvalidError  A configuration change has invalidated the acquisition buffer, or an acquisition buffer has not been configured."
    If (iErr = -10688) Then NICode = "-10688  noTrigEnabledError  The number of total scans and pretrigger scans implies that a triggered start is intended, but triggering is not enabled."
    If (iErr = -10689) Then NICode = "-10689  digitalTrigBError   Digital trigger B is illegal for the number of total scans and pretrigger scans specified."
    If (iErr = -10690) Then NICode = "-10690  digitalTrigAandBError   This board does not allow digital triggers A and B to be enabled at the same time."
    If (iErr = -10691) Then NICode = "-10691  extConvRestrictionError This board does not allow an external sample clock with an external scan clock, start trigger, or stop trigger."
    If (iErr = -10692) Then NICode = "-10692  chanClockDisabledError  The acquisition cannot be started because the channel clock is disabled."
    If (iErr = -10693) Then NICode = "-10693  extScanClockError   You cannot use an external scan clock when doing a single scan of a single channel."
    If (iErr = -10694) Then NICode = "-10694  unsafeSamplingFreqError The scan rate is above the maximum or below the minimum for the hardware, gains, and filters used."
    If (iErr = -10695) Then NICode = "-10695  DMAnotAllowedError  You have set up an operation that requires the use of interrupts.  DMA is not allowed. For example, some DAQ events, such as messaging and LabVIEW occurrences, require interrupts."
    If (iErr = -10696) Then NICode = "-10696  multiRateModeError  Multi-rate scanning cannot be used with the AMUX-64, SCXI, or pretriggered acquisitions."
    If (iErr = -10697) Then NICode = "-10697  rateNotSupportedError   Unable to convert your timebase/interval pair to match the actual hardware capabilities of this board."
    If (iErr = -10698) Then NICode = "-10698  timebaseConflictError   You cannot use this combination of scan and sample clock timebases for this board."
    If (iErr = -10699) Then NICode = "-10699  polarityConflictError   You cannot use this combination of scan and sample clock source polarities for this operation and board."
    If (iErr = -10700) Then NICode = "-10700  signalConflictError You cannot use this combination of scan and convert clock signal sources for this operation and board."
    If (iErr = -10701) Then NICode = "-10701  noLaterUpdateError  The call had no effect because the specified channel had not been set for later internal update."
    If (iErr = -10702) Then NICode = "-10702  prePostTriggerError Pretriggering and posttriggering cannot be used simultaneously on the Lab and 1200 series devices."
    If (iErr = -10710) Then NICode = "-10710  noHandshakeModeError    The specified port has not been configured for handshaking."
    If (iErr = -10720) Then NICode = "-10720  noEventCtrError The specified counter is not configured for event-counting operation."
    If (iErr = -10740) Then NICode = "-10740  SCXITrackHoldError  A signal has already been assigned to the SCXI track-and-hold trigger line, or a control call was inappropriate because the specified module is not configured for one-channel operation."
    If (iErr = -10780) Then NICode = "-10780  sc2040InputModeError    When you have an SC2040 attached to your device, all analog input channels must be configured for differential input mode."
    If (iErr = -10781) Then NICode = "-10781  outputTypeMustBeVoltageError    The polarity of the output channel cannot be bipolar when outputting currents."
    If (iErr = -10782) Then NICode = "-10782  sc2040HoldModeError The specified operation cannot be performed with the SC-2040 configured in hold mode."
    If (iErr = -10783) Then NICode = "-10783  calConstPolarityConflictError   Calibration constants in the load area have a different polarity from the current configuration. Therefore, you should load constants from factory."
    If (iErr = -10784) Then NICode = "-10784  masterDeviceNotInPXISlot2   Your master device must be PXI slot number 2 in order to route clocks to slave devices.  PXI slot 2 is the STAR trigger controller slot.  Only modules in slot 2 can drive the STAR trigger lines."
    If (iErr = -10800) Then NICode = "-10800  timeOutError    The operation could not complete within the time limit."
    If (iErr = -10801) Then NICode = "-10801  calibrationError    An error occurred during the calibration process.  Possible reasons for this error include incorrect connection of the stimulus signal, incorrect value of the stimulus signal, or malfunction of your DAQ device."
    If (iErr = -10802) Then NICode = "-10802  dataNotAvailError   The requested amount of data has not yet been acquired."
    If (iErr = -10803) Then NICode = "-10803  transferStoppedError    The on-going transfer has been stopped.   This is to prevent regeneration for output operations, or to reallocate resources for input operations."
    If (iErr = -10804) Then NICode = "-10804  earlyStopError  The transfer stopped prior to reaching the end of the transfer buffer."
    If (iErr = -10805) Then NICode = "-10805  overRunError    The clock rate is faster than the hardware can support.  An attempt to input or output a new data point was made before the hardware could finish processing the previous data point.  This condition may also occur when glitches are present on an external clock signal."
    If (iErr = -10806) Then NICode = "-10806  noTrigFoundError    No trigger value was found in the input transfer buffer."
    If (iErr = -10807) Then NICode = "-10807  earlyTrigError  The trigger occurred before sufficient pretrigger data was acquired."
    If (iErr = -10808) Then NICode = "-10808  LPTcommunicationError   An error occurred in the parallel port communication with the DAQ device."
    If (iErr = -10809) Then NICode = "-10809  gateSignalError Attempted to start a pulse width measurement with the pulse in the phase to be measured (e.g., high phase for high-level gating)."
    If (iErr = -10810) Then NICode = "-10810  internalDriverError An unexpected error occurred inside the driver when performing this given operation."
    If (iErr = -10811) Then NICode = "-10811  frequencyMeasurementError   The input signal's frequency could not be measured.  The input signal's frequency may be outside the expected frequency range, or the threshhold and hysteresis values may not be being crossed."
    If (iErr = -10840) Then NICode = "-10840  softwareError   The contents or the location of the driver file was changed between accesses to the driver."
    If (iErr = -10841) Then NICode = "-10841  firmwareError   The firmware does not support the specified operation, or the firmware operation could not complete due to a data-integrity problem."
    If (iErr = -10842) Then NICode = "-10842  hardwareError   The hardware is not responding to the specified operation, or the response from the hardware is not consistent with the functionality of the hardware."
    If (iErr = -10843) Then NICode = "-10843  underFlowError  Because of system and/or bus-bandwidth limitations, the driver could not write data to the device fast enough to keep up with the device throughput; the onboard device memory reported an underflow error.  This error may be returned erroneously when an overrun error has occurred."
    If (iErr = -10844) Then NICode = "-10844  underWriteError Your application was unable to deliver data to the background generation buffer fast enough so new data could not be delivered to the device.  To prevent this error, you might increase the size of the background generation buffer, increase the amount of data you write to it per call to the write function/VI, slow down your generation rate, or reduce the number of tasks your computer is performing."
    If (iErr = -10845) Then NICode = "-10845  overFlowError   Because of system and/or bus-bandwidth limitations, the driver could not read data from the device fast enough to keep up with the device throughput; the onboard device memory reported an overflow error."
    If (iErr = -10846) Then NICode = "-10846  overWriteError  Your application was unable to retrieve data from the background acquisition buffer fast enough so the unretrieved data was overwritten with new data.  To prevent this error, you might increase the size of the background acquisition buffer, increase the amount of data you read from it per call to the read function/VI, slow down your acquisition rate, or reduce the number of tasks your computer is performing."
    If (iErr = -10847) Then NICode = "-10847  dmaChainingError    New buffer information was not available at the time of the DMA chaining interrupt; DMA transfers will terminate at the end of the currently active transfer buffer."
    If (iErr = -10848) Then NICode = "-10848  noDMACountAvailError    The driver could not obtain a valid reading from the transfer-count register in the DMA controller."
    If (iErr = -10849) Then NICode = "-10849  OpenFileError   The configuration file or DSP kernel file could not be opened."
    If (iErr = -10850) Then NICode = "-10850  closeFileError  Unable to close a file."
    If (iErr = -10851) Then NICode = "-10851  fileSeekError   Unable to seek within a file."
    If (iErr = -10852) Then NICode = "-10852  readFileError   Unable to read from a file."
    If (iErr = -10853) Then NICode = "-10853  writeFileError  Unable to write to a file."
    If (iErr = -10854) Then NICode = "-10854  miscFileError   An error occurred accessing a file."
    If (iErr = -10855) Then NICode = "-10855  osUnsupportedError  NI-DAQ does not support the current operation on this particular version of the operating system."
    If (iErr = -10856) Then NICode = "-10856  osError An unexpected error occurred from the operating system while performing the given operation."
    If (iErr = -10857) Then NICode = "-10857  internalKernelError An unexpected error occurred inside the kernel of the device while performing this operation."
    If (iErr = -10858) Then NICode = "-10858  hardwareConfigChangedError  The system has reconfigured the device and has invalidated the existing configuration.  The device requires reinitialization to be used again."
    If (iErr = -10880) Then NICode = "-10880  updateRateChangeError   A change to the update rate is not possible at this time because 1) when waveform generation is in progress, you cannot change the interval timebase or 2) when you make several changes in a row, you must give each change enough time to take effect before requesting further changes."
    If (iErr = -10881) Then NICode = "-10881  partialTransferCompleteError    You cannot do another transfer after a successful partial transfer."
    If (iErr = -10882) Then NICode = "-10882  daqPollDataLossError    The data collected on the Remote SCXI unit was overwritten before it could be transferred to the buffer in the host. Try using a slower data acquisition rate if possible."
    If (iErr = -10883) Then NICode = "-10883  wfmPollDataLossError    New data could not be transferred to the waveform buffer of the Remote SCXI unit to keep up with the waveform update rate. Try using a slower waveform update rate if possible."
    If (iErr = -10884) Then NICode = "-10884  pretrigReorderError Could not rearrange data after a pretrigger acquisition completed."
    If (iErr = -10885) Then NICode = "-10885  overLoadError   The input signal exceeded the input range of the ADC."
    If (iErr = -10920) Then NICode = "-10920  gpctrDataLossError  One or more data points may have been lost during buffered GPCTR operations due to speed limitations of your system."
    If (iErr = -10940) Then NICode = "-10940  chassisResponseTimeoutError No response was received from the Remote SCXI unit within the specified time limit."
    If (iErr = -10941) Then NICode = "-10941  reprogrammingFailedError    Reprogramming the Remote SCXI unit was unsuccessful. Please try again."
    If (iErr = -10942) Then NICode = "-10942  invalidResetSignatureError  An invalid reset signature was sent from the host to the Remote SCXI unit."
    If (iErr = -10943) Then NICode = "-10943  chassisLockupError  The interrupt service routine on the remote SCXI unit is taking longer than necessary.  You do not need to reset your remote SCXI unit; however, please clear and restart your data acquisition."
End Function


'--------------------------------------
'NI-DAQ Function Prototypes (Unused)
'--------------------------------------

Rem Declare Function AI_Change_Parameter% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c&, ByVal d&)
Rem Declare Function AI_Check% Lib "nidaq32.dll" (ByVal a%, b%, c%)
Rem Declare Function AI_Clear% Lib "nidaq32.dll" (ByVal a%)
Rem Declare Function AI_Configure% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e%, ByVal f%)
Rem Declare Function AI_Mux_Config% Lib "nidaq32.dll" (ByVal a%, ByVal b%)
Rem Declare Function AI_Read% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, d%)
Rem Declare Function AI_Setup% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%)
Rem Declare Function AI_VRead% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, d#)
Rem Declare Function AI_VScale% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d#, ByVal e#, ByVal f%, g#)
Rem Declare Function Align_DMA_Buffer% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c As Any, ByVal d&, ByVal e&, f&)
Rem Declare Function AO_Calibrate% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%)
Rem Declare Function AO_Configure% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e#, ByVal f%)
Rem Declare Function AO_Change_Parameter% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c&, ByVal d&)
Rem Declare Function AO_Update% Lib "nidaq32.dll" (ByVal a%)
Rem Declare Function AO_VWrite% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c#)
Rem Declare Function AO_Write% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%)
Rem Declare Function Calibrate_E_Series% Lib "nidaq32.dll" (ByVal a%, ByVal b&, ByVal c&, ByVal d#)
Rem Declare Function Calibrate_59xx% Lib "nidaq32.dll" (ByVal a%, ByVal b&, ByVal c#)
Rem Declare Function Calibrate_DSA% Lib "nidaq32.dll" (ByVal a%, ByVal b&, ByVal c#)
Rem Declare Function Config_Alarm_Deadband% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c$, ByVal d#, ByVal e#, ByVal f%, ByVal g%, ByVal h%, ByVal i&)
Rem Declare Function Config_ATrig_Event_Message% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c$, ByVal d#, ByVal e#, ByVal f%, ByVal g&, ByVal h&, ByVal i&, ByVal j%, ByVal k%, ByVal l&)
Rem Declare Function Config_DAQ_Event_Message% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c$, ByVal d%, ByVal e&, ByVal f&, ByVal g&, ByVal h&, ByVal i&, ByVal j%, ByVal k%, ByVal l&)
Rem Declare Function Configure_HW_Analog_Trigger% Lib "nidaq32.dll" (ByVal a%, ByVal b&, ByVal c&, ByVal d&, ByVal e&, ByVal f&)
Rem Declare Function CTR_Config% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e%, ByVal f%)
Rem Declare Function CTR_EvCount% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%)
Rem Declare Function CTR_EvRead% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%, d%)
Rem Declare Function CTR_FOUT_Config% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e%)
Rem Declare Function CTR_Period% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%)
Rem Declare Function CTR_Pulse% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e%)
Rem Declare Function CTR_Rate% Lib "nidaq32.dll" (ByVal a#, ByVal b#, c%, d%, e%)
Rem Declare Function CTR_Reset% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%)
Rem Declare Function CTR_Restart% Lib "nidaq32.dll" (ByVal a%, ByVal b%)
Rem Declare Function CTR_Simul_Op% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%, ByVal d%)
Rem Declare Function CTR_Square% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e%)
Rem Declare Function CTR_State% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%)
Rem Declare Function CTR_Stop% Lib "nidaq32.dll" (ByVal a%, ByVal b%)
Rem Declare Function DAQ_Check% Lib "nidaq32.dll" (ByVal a%, b%, c&)
Rem Declare Function DAQ_Clear% Lib "nidaq32.dll" (ByVal a%)
Rem Declare Function DAQ_Config% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%)
Rem Declare Function DAQ_DB_Config% Lib "nidaq32.dll" (ByVal a%, ByVal b%)
Rem Declare Function DAQ_DB_HalfReady% Lib "nidaq32.dll" (ByVal a%, b%, c%)
Rem Declare Function DAQ_DB_Transfer% Lib "nidaq32.dll" (ByVal a%, b As Any, c&, d%)
Rem Declare Function DAQ_Monitor% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d&, e As Any, f&, g%)
Rem Declare Function DAQ_Op% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, d As Any, ByVal e&, ByVal f#)
Rem Declare Function DAQ_Rate% Lib "nidaq32.dll" (ByVal a#, ByVal b%, c%, d%)
Rem Declare Function DAQ_Start% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, d As Any, ByVal e&, ByVal f%, ByVal g%)
Rem Declare Function DAQ_StopTrigger_Config% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c&)
Rem Declare Function DAQ_to_Disk% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d$, ByVal e&, ByVal f#, ByVal g%)
Rem Declare Function DAQ_VScale% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d#, ByVal e#, ByVal f&, g%, h#)
Rem Declare Function DIG_Block_Check% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c&)
Rem Declare Function DIG_Block_Clear% Lib "nidaq32.dll" (ByVal a%, ByVal b%)
Rem Declare Function DIG_Block_In% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c As Any, ByVal d&)
Rem Declare Function DIG_Block_Out% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c As Any, ByVal d&)
Rem Declare Function DIG_Block_PG_Config% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e%, ByVal f%, ByVal g%)
Rem Declare Function DIG_DB_Config% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e%)
Rem Declare Function DIG_DB_HalfReady% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%)
Rem Declare Function DIG_DB_Transfer% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c As Any, ByVal d&)
Rem Declare Function DIG_Grp_Config% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e%)
Rem Declare Function DIG_Grp_Mode% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e%, ByVal f%, ByVal g%)
Rem Declare Function DIG_Grp_Status% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%)
Rem Declare Function DIG_In_Grp% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%)
Rem Declare Function DIG_In_Line% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, d%)
Rem Declare Function Query_Optimizations_GFS% Lib "nidaq32.dll" (ByVal a%)
Rem Declare Function DIG_In_Port_GFS% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%)
Rem Declare Function DIG_In_Port% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%)
Rem Declare Function DIG_Line_Config% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%)
Rem Declare Function DIG_Out_Grp% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%)
Rem Declare Function DIG_Out_Line% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%)
Rem Declare Function DIG_Out_Port_GFS% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%)
Rem Declare Function DIG_Out_Port% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%)
Rem Declare Function DIG_Prt_Config% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%)
Rem Declare Function DIG_Prt_Status% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%)
Rem Declare Function DIG_SCAN_Setup% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, d%, ByVal e%)
Rem Declare Function Get_DAQ_Device_Info% Lib "nidaq32.dll" (ByVal a%, ByVal b&, c&)
Rem Declare Function Get_DAQ_Event% Lib "nidaq32.dll" (ByVal a&, b%, c%, d%, e&)
Rem Declare Function Get_NI_DAQ_Version% Lib "nidaq32.dll" (a&)
Rem Declare Function GPCTR_Config_Buffer% Lib "nidaq32.dll" (ByVal a%, ByVal b&, ByVal c&, ByVal d&, e As Any)
Rem Declare Function GPCTR_Read_Buffer% Lib "nidaq32.dll" (ByVal a%, ByVal b&, ByVal c&, ByVal d&, ByVal e&, ByVal f#, g&, h&)
Rem Declare Function Line_Change_Attribute% Lib "nidaq32.dll" (ByVal a%, ByVal b&, ByVal c&, ByVal d&)
Rem Declare Function GPCTR_Control% Lib "nidaq32.dll" (ByVal a%, ByVal b&, ByVal c&)
Rem Declare Function GPCTR_Set_Application% Lib "nidaq32.dll" (ByVal a%, ByVal b&, ByVal c&)
Rem Declare Function GPCTR_Watch% Lib "nidaq32.dll" (ByVal a%, ByVal b&, ByVal c&, d&)
Rem Declare Function ICTR_Read% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%)
Rem Declare Function ICTR_Reset% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%)
Rem Declare Function ICTR_Setup% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e%)
Rem Declare Function Init_DA_Brds% Lib "nidaq32.dll" (ByVal a%, b%)
Rem Declare Function Lab_ISCAN_Check% Lib "nidaq32.dll" (ByVal a%, b%, c&, d%)
Rem Declare Function Lab_ISCAN_Op% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, d As Any, ByVal e&, ByVal f#, ByVal g#, h%)
Rem Declare Function Lab_ISCAN_Start% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, d As Any, ByVal e&, ByVal f%, ByVal g%, ByVal h%)
Rem Declare Function Lab_ISCAN_to_Disk% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d$, ByVal e&, ByVal f#, ByVal g#, ByVal h%)
Rem Declare Function LPM16_Calibrate% Lib "nidaq32.dll" (ByVal a%)
Rem Declare Function MIO_Config% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%)
Rem Declare Function Peek_DAQ_Event% Lib "nidaq32.dll" (ByVal a&, b%, c%, d%, e&)
Rem Declare Function REG_Level_Read% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c&)
Rem Declare Function REG_Level_Write% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c&, ByVal d&, e&)
Rem Declare Function RTSI_Clear% Lib "nidaq32.dll" (ByVal a%)
Rem Declare Function RTSI_Clock% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%)
Rem Declare Function RTSI_Conn% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%)
Rem Declare Function RTSI_DisConn% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%)
Rem Declare Function SC_2040_Config% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%)
Rem Declare Function SCAN_Demux% Lib "nidaq32.dll" (a%, ByVal b&, ByVal c%, ByVal d%)
Rem Declare Function SCAN_Op% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%, d%, e As Any, ByVal f&, ByVal g#, ByVal h#)
Rem Declare Function SCAN_Sequence_Demux% Lib "nidaq32.dll" (ByVal a%, b%, ByVal c&, d%, ByVal e%, f%, g&)
Rem Declare Function SCAN_Sequence_Retrieve% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%)
Rem Declare Function SCAN_Sequence_Setup% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%, d%, e%, f%, g%)
Rem Declare Function SCAN_Setup% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%, d%)
Rem Declare Function SCAN_Start% Lib "nidaq32.dll" (ByVal a%, b As Any, ByVal c&, ByVal d%, ByVal e%, ByVal f%, ByVal g%)
Rem Declare Function SCAN_to_Disk% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%, d%, ByVal e$, ByVal f&, ByVal g#, ByVal h#, ByVal i%)
Rem Declare Function Calibrate_1200% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e%, ByVal f%, ByVal g%, ByVal h%, ByVal i#, ByVal j#)
Rem Declare Function SCXI_AO_Write% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e%, ByVal f#, ByVal g%, h%)
Rem Declare Function SCXI_Cal_Constants% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e%, ByVal f%, ByVal g#, ByVal h%, ByVal i%, ByVal j%, ByVal k#, ByVal l#, ByVal m#, ByVal n#, ByVal o#, p#, q#)
Rem Declare Function InitChannelWizardStrainCal% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e!, ByVal f!, g#, h%, i%, ByVal j!, ByVal k%)
Rem Declare Function ChannelWizardSCXIStrainCal% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e%, ByVal f#, ByVal g%, ByVal h$, ByVal i$, j#, k#, l#)
Rem Declare Function SCXI_Calibrate% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e%, ByVal f#, ByVal g#, ByVal h%, ByVal i%)
Rem Declare Function SCXI_Strain_Null% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e%, f!)
Rem Declare Function SCXI_Strain_Null_Ex% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e%, f!, ByVal g!, ByVal h&, i%, j%)
Rem Declare Function SCXI_Calibrate_Setup% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%)
Rem Declare Function SCXI_Change_Chan% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%)
Rem Declare Function SCXI_Set_Potentiometer% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e$)
Rem Declare Function SCXI_Set_Excitation% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e!, f!)
Rem Declare Function SCXI_Configure_Connection% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%)
Rem Declare Function SCXI_Configure_Filter% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e#, ByVal f%, ByVal g%, h#)
Rem Declare Function SCXI_Get_Chassis_Info% Lib "nidaq32.dll" (ByVal a%, b%, c%, d%, e%, f%)
Rem Declare Function SCXI_Get_Module_Info% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c&, d%, e%)
Rem Declare Function SCXI_Get_State% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, e&)
Rem Declare Function SCXI_Get_Status% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, d&)
Rem Declare Function SCXI_Load_Config% Lib "nidaq32.dll" (ByVal a%)
Rem Declare Function SCXI_MuxCtr_Setup% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%)
Rem Declare Function SCXI_Reset% Lib "nidaq32.dll" (ByVal a%, ByVal b%)
Rem Declare Function SCXI_Scale% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d#, ByVal e#, ByVal f%, ByVal g%, ByVal h%, ByVal i&, j%, k#)
Rem Declare Function SCXI_SCAN_Setup% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%, d%, e%, ByVal f%, ByVal g%)
Rem Declare Function SCXI_Set_Config% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e%, ByVal f%, g&, h%, i%)
Rem Declare Function SCXI_Set_Gain% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d#)
Rem Declare Function SCXI_Set_Input_Mode% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%)
Rem Declare Function SCXI_Set_State% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e&)
Rem Declare Function SCXI_Single_Chan_Setup% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%)
Rem Declare Function SCXI_Track_Hold_Control% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%)
Rem Declare Function SCXI_Track_Hold_Setup% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e%, ByVal f%, ByVal g%)
Rem Declare Function Select_Signal% Lib "nidaq32.dll" (ByVal a%, ByVal b&, ByVal c&, ByVal d&)
Rem Declare Function Set_DAQ_Device_Info% Lib "nidaq32.dll" (ByVal a%, ByVal b&, ByVal c&)
Rem Declare Function Timeout_Config% Lib "nidaq32.dll" (ByVal a%, ByVal b&)
Rem Declare Function WFM_Chan_Control% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%)
Rem Declare Function WFM_Check% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%, d&, e&)
Rem Declare Function WFM_ClockRate% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e&, ByVal f%)
Rem Declare Function WFM_DB_Config% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%, ByVal d%, ByVal e%, ByVal f%)
Rem Declare Function WFM_DB_HalfReady% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%, d%)
Rem Declare Function WFM_DB_Transfer% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%, d As Any, ByVal e&)
Rem Declare Function WFM_from_Disk% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%, ByVal d$, ByVal e&, ByVal f&, ByVal g&, ByVal h#)
Rem Declare Function WFM_Group_Control% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%)
Rem Declare Function WFM_Group_Setup% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%, ByVal d%)
Rem Declare Function WFM_Load% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%, d As Any, ByVal e&, ByVal f&, ByVal g%)
Rem Declare Function WFM_Op% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c%, d As Any, ByVal e&, ByVal f&, ByVal g#)
Rem Declare Function WFM_Rate% Lib "nidaq32.dll" (ByVal a#, ByVal b%, c%, d&)
Rem Declare Function WFM_Scale% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c&, ByVal d#, e#, f%)
Rem Declare Function AI_Read_Scan% Lib "nidaq32.dll" (ByVal a%, b%)
Rem Declare Function AI_VRead_Scan% Lib "nidaq32.dll" (ByVal a%, b#)
Rem Declare Function SCXI_ModuleID_Read% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c&)
Rem Declare Function AO_VScale% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c#, d%)
Rem Declare Function GPCTR_Change_Parameter% Lib "nidaq32.dll" (ByVal a%, ByVal b&, ByVal c&, ByVal d&)
Rem Declare Function USE_MIO% Lib "nidaq32.dll" ()
Rem Declare Function USE_LPM% Lib "nidaq32.dll" ()
Rem Declare Function USE_LAB% Lib "nidaq32.dll" ()
Rem Declare Function USE_DIO_96% Lib "nidaq32.dll" ()
Rem Declare Function USE_DIO_32F% Lib "nidaq32.dll" ()
Rem Declare Function USE_DIO_24% Lib "nidaq32.dll" ()
Rem Declare Function USE_AO_610% Lib "nidaq32.dll" ()
Rem Declare Function USE_AO_2DC% Lib "nidaq32.dll" ()
Rem Declare Function DIG_Trigger_Config% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d%, ByVal e%, ByVal f%, ByVal g&, ByVal h&, ByVal i&)
Rem Declare Function SCXI_Set_Threshold% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c%, ByVal d#, ByVal e#)
Rem Declare Function WFM_Set_Clock% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c&, ByVal d#, ByVal e&, f#)
Rem Declare Function DAQ_Set_Clock% Lib "nidaq32.dll" (ByVal a%, ByVal b&, ByVal c#, ByVal d&, e#)
Rem Declare Function Tio_Select_Signal% Lib "nidaq32.dll" (ByVal a%, ByVal b&, ByVal c&, ByVal d&)
Rem Declare Function Tio_Combine_Signals% Lib "nidaq32.dll" (ByVal a%, ByVal b&, ByVal c&)
Rem Declare Function DIG_In_Prt% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c&)
Rem Declare Function DIG_Out_Prt% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c&)
Rem Declare Function AI_Get_Overloaded_Channels% Lib "nidaq32.dll" (ByVal a%, b%, c%)
Rem Declare Function Calibrate_TIO% Lib "nidaq32.dll" (ByVal a%, ByVal b&, ByVal c&, ByVal d#)
Rem Declare Function DIG_Change_Message_Config% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c$, ByVal d$, ByVal e%, ByVal f%, ByVal g&)
Rem Declare Function DIG_Change_Message_Control% Lib "nidaq32.dll" (ByVal a%, ByVal b%)
Rem Declare Function DIG_Filter_Config% Lib "nidaq32.dll" (ByVal a%, ByVal b%, ByVal c$, ByVal d#)
Rem Declare Function SCXI_TerminalBlockID_Read% Lib "nidaq32.dll" (ByVal a%, ByVal b%, c&)
Rem Declare Function ni62xx_CalStart% Lib "nidaq32.dll" (ByVal a%, ByVal b$)
Rem Declare Function ni62xx_CalAdjust% Lib "nidaq32.dll" (ByVal a%, ByVal b&, c#, ByVal d%)
Rem Declare Function ni62xx_CalEnd% Lib "nidaq32.dll" (ByVal a%, ByVal b&)
Rem Declare Function ni62xx_SelfCalibrate% Lib "nidaq32.dll" (ByVal a%)
Rem Declare Function CalFetchInternalReference% Lib "nidaq32.dll" (ByVal a%, b#)
Rem Declare Function CalChangePassword% Lib "nidaq32.dll" (ByVal a%, ByVal b$, ByVal c$)
Rem Declare Function CalFetchCount% Lib "nidaq32.dll" (ByVal a%, ByVal b&, c&)
Rem Declare Function CalFetchDate% Lib "nidaq32.dll" (ByVal a%, ByVal b&, c&, d&, e&)
Rem Declare Function CalFetchTemperature% Lib "nidaq32.dll" (ByVal a%, ByVal b&, c#)
Rem Declare Function CalFetchMiscInfo% Lib "nidaq32.dll" (ByVal a%, ByVal b$)
Rem Declare Function CalStoreMiscInfo% Lib "nidaq32.dll" (ByVal a%, ByVal b$)
