VERSION 5.00
Begin VB.Form ReagentsForm 
   BackColor       =   &H00E0E0E0&
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   "Reagents Control"
   ClientHeight    =   4980
   ClientLeft      =   45
   ClientTop       =   285
   ClientWidth     =   5100
   ControlBox      =   0   'False
   Icon            =   "ReagentsForm.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4980
   ScaleWidth      =   5100
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.Timer tmrPeriodicJet 
      Enabled         =   0   'False
      Interval        =   5000
      Left            =   3240
      Top             =   3000
   End
   Begin VB.CheckBox chkPeriodicJet 
      BackColor       =   &H00E0E0E0&
      Caption         =   "Periodic Jet"
      Height          =   255
      Left            =   3240
      TabIndex        =   24
      Top             =   2640
      Width           =   1815
   End
   Begin VB.CheckBox chkDryerOn 
      BackColor       =   &H00E0E0E0&
      Caption         =   "Dryer On"
      Height          =   255
      Left            =   3240
      TabIndex        =   15
      Top             =   2280
      Width           =   1815
   End
   Begin VB.CommandButton btnDispenseAll 
      Caption         =   "Purge All"
      Height          =   375
      Left            =   1680
      TabIndex        =   14
      Top             =   4200
      Width           =   1215
   End
   Begin VB.CommandButton btnDispense 
      Caption         =   "Waste"
      Height          =   375
      Index           =   6
      Left            =   1680
      TabIndex        =   13
      Top             =   3120
      Width           =   1215
   End
   Begin VB.CommandButton btnDispense 
      Caption         =   "Solenoid 5"
      Height          =   375
      Index           =   5
      Left            =   1680
      TabIndex        =   12
      Top             =   2640
      Width           =   1215
   End
   Begin VB.CommandButton btnDispense 
      Caption         =   "Solenoid 4"
      Height          =   375
      Index           =   4
      Left            =   1680
      TabIndex        =   11
      Top             =   2160
      Width           =   1215
   End
   Begin VB.CommandButton btnDispense 
      Caption         =   "Solenoid 3"
      Height          =   375
      Index           =   3
      Left            =   1680
      TabIndex        =   10
      Top             =   1680
      Width           =   1215
   End
   Begin VB.CommandButton btnDispense 
      Caption         =   "Solenoid 2"
      Height          =   375
      Index           =   2
      Left            =   1680
      TabIndex        =   9
      Top             =   1200
      Width           =   1215
   End
   Begin VB.CommandButton btnClose 
      Caption         =   "Close"
      Default         =   -1  'True
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   3600
      TabIndex        =   2
      Top             =   4320
      Width           =   1335
   End
   Begin VB.Frame Frame2 
      BackColor       =   &H00E0E0E0&
      Caption         =   "Inkjet"
      Height          =   1935
      Left            =   3240
      TabIndex        =   1
      Top             =   120
      Width           =   1695
      Begin VB.CommandButton btnPrint 
         Caption         =   "Print"
         Height          =   615
         Left            =   240
         TabIndex        =   7
         Top             =   1080
         Width           =   1095
      End
      Begin VB.TextBox tbxDrops 
         Height          =   375
         Left            =   240
         TabIndex        =   6
         Text            =   "1"
         Top             =   600
         Width           =   1095
      End
      Begin VB.Label Label2 
         BackStyle       =   0  'Transparent
         Caption         =   "Drops:"
         Height          =   255
         Left            =   240
         TabIndex        =   5
         Top             =   360
         Width           =   1215
      End
   End
   Begin VB.Frame Frame1 
      BackColor       =   &H00E0E0E0&
      Caption         =   "Solenoids"
      Height          =   4695
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   3015
      Begin VB.TextBox tbxPurgeDur 
         Height          =   375
         Left            =   120
         TabIndex        =   23
         Text            =   "4"
         Top             =   4080
         Width           =   1335
      End
      Begin VB.ComboBox cmbWhere 
         Height          =   315
         ItemData        =   "ReagentsForm.frx":144A
         Left            =   1560
         List            =   "ReagentsForm.frx":14A5
         TabIndex        =   21
         Text            =   "Here"
         Top             =   3480
         Width           =   1215
      End
      Begin VB.TextBox tbxSolDur 
         Height          =   375
         Index           =   6
         Left            =   120
         TabIndex        =   20
         Text            =   "1.5"
         Top             =   3000
         Width           =   1335
      End
      Begin VB.TextBox tbxSolDur 
         Height          =   375
         Index           =   5
         Left            =   120
         TabIndex        =   19
         Text            =   "1.5"
         Top             =   2520
         Width           =   1335
      End
      Begin VB.TextBox tbxSolDur 
         Height          =   375
         Index           =   4
         Left            =   120
         TabIndex        =   18
         Text            =   "1.5"
         Top             =   2040
         Width           =   1335
      End
      Begin VB.TextBox tbxSolDur 
         Height          =   375
         Index           =   3
         Left            =   120
         TabIndex        =   17
         Text            =   "1.5"
         Top             =   1560
         Width           =   1335
      End
      Begin VB.TextBox tbxSolDur 
         Height          =   375
         Index           =   2
         Left            =   120
         TabIndex        =   16
         Text            =   "1.5"
         Top             =   1080
         Width           =   1335
      End
      Begin VB.CommandButton btnDispense 
         Caption         =   "Solenoid 1"
         Height          =   375
         Index           =   1
         Left            =   1560
         TabIndex        =   8
         Top             =   600
         Width           =   1215
      End
      Begin VB.TextBox tbxSolDur 
         Height          =   375
         Index           =   1
         Left            =   120
         TabIndex        =   4
         Text            =   "1.5"
         Top             =   600
         Width           =   1335
      End
      Begin VB.Line Line1 
         BorderColor     =   &H00FFFFFF&
         X1              =   120
         X2              =   2760
         Y1              =   3960
         Y2              =   3960
      End
      Begin VB.Label Label3 
         BackStyle       =   0  'Transparent
         Caption         =   "Dispense where?"
         Height          =   255
         Left            =   120
         TabIndex        =   22
         Top             =   3480
         Width           =   1455
      End
      Begin VB.Label Label1 
         BackStyle       =   0  'Transparent
         Caption         =   "Dispense time (s):"
         Height          =   255
         Left            =   120
         TabIndex        =   3
         Top             =   360
         Width           =   1455
      End
   End
End
Attribute VB_Name = "ReagentsForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'ReagentsForm
'7 Nov 2004
'Copyright
'C Lausted, Institute for Systems Biology
'
'This form lets the user manually run the solenoids or print.
'Functions and properties:
'Properties that must be initialized:
'
'Dependencies: PogoMain.
'//////////////////////////////////////////////////////////////////

Private Const CPURGINGAREA As Integer = 3                  'Important Coordinate #3.
Private Const CPURGINGAREASTR  As String = "Purging Area"  'Second item in combo box
Private Const CPERIODICJET As Double = 40                  'To keep nozzles clean, jet every 40 min.

Dim iNextPurge As Long  'Time until next purging of inkjet nozzles.



Private Sub Form_Load()
    '27 June 2004 CGL.
    'Update PeriodicJet display every 5000ms.
    tmrPeriodicJet.Interval = 5000
    tmrPeriodicJet.Enabled = False
End Sub


Private Sub btnClose_Click()
    Hide
End Sub


Property Let ButtonsEnabled(ByVal bEnabled As Boolean)
    '17 Nov 2004 CGL.
    'Activate or deactivate buttons on this form.
    For Each obj In ReagentsForm
        If (left(obj.Name, 3) = "btn") Then obj.Enabled = bEnabled
    Next
    ReagentsForm.Refresh
End Property



'BOX DRYER SOLENOID FUNCTIONS & PROPERTIES.
'//////////////////////////////////////////////////////////////////

Public Sub chkDryerOn_Click()
    '14 Oct 2004 CGL
    'Turn on/off 120VAC to N2/Ar solenoid for drying the box.
    BoxDryerOn = (chkDryerOn.value = vbChecked)
End Sub


Property Get BoxDryerOn() As Boolean
    '14 Oct 2004 CGL
    'Indicate status of 120VAC to N2/Ar solenoid for drying the box.
    BoxDryerOn = (chkDryerOn.value = vbChecked)
End Property

Property Let BoxDryerOn(ByVal newvalue As Boolean)
    '14 Oct 2004 CGL
    'Turn on/off 120VAC to N2/Ar solenoid for drying the box.
    If newvalue Then
        PogoMIO.Relay5On = True
        chkDryerOn.value = vbChecked
    Else
        PogoMIO.Relay5On = False
        chkDryerOn.value = vbUnchecked
    End If
    chkDryerOn.Refresh
End Property


'REAGENT SOLENOID FUNCTIONS & PROPERTIES.
'//////////////////////////////////////////////////////////////////

Private Sub tbxSolDur_LostFocus(i As Integer)
    '27 June 2004 CGL.  Validation.
    PogoMain.SolDur(i) = Val(tbxSolDur(i).Text)
End Sub


Private Sub btnDispense_Click(Index As Integer)
    '11 Aug 2004 CGL.
    'Dispense reagent onto current location, purging area, or slide.
    Dim sErr As String, iSol As Integer, dDur As String, iSlide As String
    iSol = Index
    dDur = Val(tbxSolDur(iSol))
    If (left(cmbWhere.Text, 5) = "Slide") Then
        'Move to a specific slide and wash.  (e.g. cmbWhere.Text="Slide 27")
        iSlide = Int(Val(right(cmbWhere.Text, 2)))
        sErr = PogoMain.MoveWashOverSlide(iSlide, iSol)
        sErr = PogoDIO.Pump(iSol, dDur)
    ElseIf (cmbWhere.Text = CPURGINGAREASTR) Then
        'Move to purging area and dispense.  (e.g. cmbWhere.Text = "Purging Area")
        sErr = PogoMain.MoveWashOverSlide(0, iSol)
        sErr = PogoDIO.Pump(iSol, dDur)
    ElseIf (cmbWhere.Text = "Here") Then
        'Dispense right here.
        sErr = PogoDIO.Pump(iSol, dDur)
    Else
        ErrorMessage.Display "Error in ReagentsForm.btnDispense_Click", 5
    End If
End Sub


Private Sub btnDispenseAll_Click()
    '18 Oct 2004 CGL.
    'Dispense a fixed volume of each reagent into the purging area.
    Dim i As Integer
    Dim sOldDur As String
    Dim dDur As Double
    Dim mousept0
    
    mousept0 = Screen.MousePointer
    Screen.MousePointer = vbHourglass
    'Determine the purging duration.
    dDur = Val(tbxPurgeDur.Text)
    If (dDur < 0) Then dDur = 0
    If (dDur > CMAXSOLDUR) Then dDur = CMAXSOLDUR
    tbxPurgeDur.Text = dDur
    
    'Specify the Purging Area in the combo box.
    cmbWhere.Text = CPURGINGAREASTR
    
    'Loop through all six liquid channels (except waste).
    For i = 6 To 1 Step -1
        If (i <> PogoMain.WasteSol) Then
            sOldDur = tbxSolDur(i).Text    'Remember the previous duration setting.
            tbxSolDur(i) = dDur            'Set to something like 4.0 seconds.
            tbxSolDur(i).Refresh
            btnDispense_Click (i)          'Dispense.
            tbxSolDur(i).Text = sOldDur    'Reset previous duration setting.
            tbxSolDur(i).Refresh
        End If
    Next i
    
    'Run waste solenoid last for cleanup.
    sOldDur = tbxSolDur(PogoMain.WasteSol).Text
    tbxSolDur(PogoMain.WasteSol).Text = dDur * 5
    tbxSolDur(PogoMain.WasteSol).Refresh
    btnDispense_Click (PogoMain.WasteSol)
    tbxSolDur(PogoMain.WasteSol).Text = sOldDur
    tbxSolDur(PogoMain.WasteSol).Refresh
    
    Screen.MousePointer = mousept0
End Sub


'INKJET FUNCTIONS & PROPERTIES.
'//////////////////////////////////////////////////////////////////

Private Sub tbxDrops_LostFocus()
    '27 June 2004 CGL.  Validation.
    PogoMain.Drops = Val(tbxDrops.Text)
End Sub


Private Sub btnPrint_Click()
    '27 July 2004 CGL
    'Print all loaded slides, down one.
    PogoMain.PrintNow
End Sub


Public Sub chkPeriodicJet_Click()
    '7 Nov 2004 CGL
    'Checkbox to turn on/off the periodic purging the the inkjet nozzles.
    'If this is vbChecked when a synthesis program is started, it will
    'be vbGrayed until the synthesis is done.
    PeriodicJet = chkPeriodicJet.value
End Sub


Property Get PeriodicJet() As Integer
    '7 Nov 2004 CGL
    'Indicate status of the periodic purging the the inkjet nozzles.
    PeriodicJet = chkPeriodicJet.value
End Property

Property Let PeriodicJet(ByVal newvalue As Integer)
    '7 Nov 2004 CGL
    'Turn on/off the periodic purging the the inkjet nozzles.
    If (newvalue = vbChecked) Then
        tmrPeriodicJet.Enabled = True
        iNextPurge = 0
    Else
        tmrPeriodicJet.Enabled = False
        chkPeriodicJet.Caption = "Periodic Jet"
    End If
    chkPeriodicJet.value = newvalue
    chkPeriodicJet.Refresh
End Property


Private Sub tmrPeriodicJet_Timer()
    '7 Nov 2004 CGL
    'This sub is called every 5 seconds.  The time until inkjet purging is displayed.
    'Every ten minutes we move to the Purging Area and shoot 1000 droplets.
    Static mytime As Integer
    'Give warning beep 5 seconds before potential motion.
    If (iNextPurge < 10) Then Beep
    'At time zero do the jetting.
    If (iNextPurge < 5) Then
        Beep
        chkPeriodicJet.Caption = "Periodic Jet - Now"
        PogoMain.PurgeNozzles (0)   'Zero means default number of drops.
        iNextPurge = Int(CPERIODICJET * 60 + 5)
    End If
    iNextPurge = iNextPurge - 5
    chkPeriodicJet.Caption = "Periodic Jet in " & iNextPurge & "s"
End Sub
