VERSION 5.00
Begin VB.Form ServoForm 
   Appearance      =   0  'Flat
   BackColor       =   &H00E0E0E0&
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   "Servo Panel"
   ClientHeight    =   3780
   ClientLeft      =   45
   ClientTop       =   285
   ClientWidth     =   5730
   ControlBox      =   0   'False
   Icon            =   "ServoForm.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3780
   ScaleWidth      =   5730
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton btnJog 
      Caption         =   ">>"
      Height          =   495
      Index           =   15
      Left            =   3240
      TabIndex        =   6
      Top             =   3120
      Width           =   855
   End
   Begin VB.CommandButton btnImportant 
      Caption         =   "User Def. 8"
      Height          =   375
      Index           =   8
      Left            =   4200
      TabIndex        =   39
      Top             =   2640
      Width           =   1335
   End
   Begin VB.CommandButton btnImportant 
      Caption         =   "User Def. 7"
      Height          =   375
      Index           =   7
      Left            =   4200
      TabIndex        =   38
      Top             =   2280
      Width           =   1335
   End
   Begin VB.CommandButton btnImportant 
      Caption         =   "User Def. 6"
      Height          =   375
      Index           =   6
      Left            =   4200
      TabIndex        =   37
      Top             =   1920
      Width           =   1335
   End
   Begin VB.CommandButton btnImportant 
      Caption         =   "Park"
      Height          =   375
      Index           =   5
      Left            =   4200
      TabIndex        =   36
      Top             =   1560
      Width           =   1335
   End
   Begin VB.CommandButton btnImportant 
      Caption         =   "Gloves"
      Height          =   375
      Index           =   4
      Left            =   4200
      TabIndex        =   35
      Top             =   1200
      Width           =   1335
   End
   Begin VB.CommandButton btnImportant 
      Caption         =   "Sol. Purging"
      Height          =   375
      Index           =   3
      Left            =   4200
      TabIndex        =   34
      Top             =   840
      Width           =   1335
   End
   Begin VB.CommandButton btnImportant 
      Caption         =   "Inkjet Purge"
      Height          =   375
      Index           =   2
      Left            =   4200
      TabIndex        =   33
      Top             =   480
      Width           =   1335
   End
   Begin VB.CommandButton btnImportant 
      Caption         =   "Laser"
      Height          =   375
      Index           =   1
      Left            =   4200
      TabIndex        =   32
      Top             =   120
      Width           =   1335
   End
   Begin VB.CommandButton btnGoToCoordinates 
      Caption         =   "Go To Coordinates"
      Height          =   375
      Left            =   120
      TabIndex        =   31
      Top             =   1680
      Width           =   3975
   End
   Begin VB.TextBox tbxPosition 
      Height          =   285
      Index           =   3
      Left            =   2760
      TabIndex        =   21
      Text            =   "0"
      Top             =   1320
      Width           =   1215
   End
   Begin VB.TextBox tbxPosition 
      Height          =   285
      Index           =   2
      Left            =   2760
      TabIndex        =   20
      Text            =   "0"
      Top             =   960
      Width           =   1215
   End
   Begin VB.TextBox tbxPosition 
      Height          =   285
      Index           =   1
      Left            =   2760
      TabIndex        =   19
      Text            =   "0"
      Top             =   600
      Width           =   1215
   End
   Begin VB.CommandButton btnJog 
      Caption         =   ">"
      Height          =   495
      Index           =   14
      Left            =   2760
      TabIndex        =   15
      Top             =   3120
      Width           =   495
   End
   Begin VB.CommandButton btnJog 
      Caption         =   "Z Axis Home"
      Height          =   495
      Index           =   13
      Left            =   1440
      TabIndex        =   14
      Top             =   3120
      Width           =   1335
   End
   Begin VB.CommandButton btnJog 
      Caption         =   "<"
      Height          =   495
      Index           =   12
      Left            =   960
      TabIndex        =   13
      Top             =   3120
      Width           =   495
   End
   Begin VB.CommandButton btnJog 
      Caption         =   "<<"
      Height          =   495
      Index           =   11
      Left            =   120
      TabIndex        =   12
      Top             =   3120
      Width           =   855
   End
   Begin VB.CommandButton btnJog 
      Caption         =   ">>"
      Height          =   495
      Index           =   10
      Left            =   3240
      TabIndex        =   11
      Top             =   2640
      Width           =   855
   End
   Begin VB.CommandButton btnJog 
      Caption         =   ">"
      Height          =   495
      Index           =   9
      Left            =   2760
      TabIndex        =   10
      Top             =   2640
      Width           =   495
   End
   Begin VB.CommandButton btnJog 
      Caption         =   "Y Axis Home"
      Height          =   495
      Index           =   8
      Left            =   1440
      TabIndex        =   9
      Top             =   2640
      Width           =   1335
   End
   Begin VB.CommandButton btnJog 
      Caption         =   "<"
      Height          =   495
      Index           =   7
      Left            =   960
      TabIndex        =   8
      Top             =   2640
      Width           =   495
   End
   Begin VB.CommandButton btnJog 
      Caption         =   "<<"
      Height          =   495
      Index           =   6
      Left            =   120
      TabIndex        =   7
      Top             =   2640
      Width           =   855
   End
   Begin VB.CommandButton btnJog 
      Caption         =   ">>"
      Height          =   495
      Index           =   5
      Left            =   3240
      TabIndex        =   5
      Top             =   2160
      Width           =   855
   End
   Begin VB.CommandButton btnJog 
      Caption         =   ">"
      Height          =   495
      Index           =   4
      Left            =   2760
      TabIndex        =   4
      Top             =   2160
      Width           =   495
   End
   Begin VB.CommandButton btnJog 
      Caption         =   "X Axis Home"
      Height          =   495
      Index           =   3
      Left            =   1440
      TabIndex        =   3
      Top             =   2160
      Width           =   1335
   End
   Begin VB.CommandButton btnJog 
      Caption         =   "<"
      Height          =   495
      Index           =   2
      Left            =   960
      TabIndex        =   2
      Top             =   2160
      Width           =   495
   End
   Begin VB.CommandButton btnJog 
      Caption         =   "<<"
      Height          =   495
      Index           =   1
      Left            =   120
      TabIndex        =   1
      Top             =   2160
      Width           =   855
   End
   Begin VB.CommandButton btnClose 
      Caption         =   "Close"
      Default         =   -1  'True
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   4200
      TabIndex        =   0
      Top             =   3240
      Width           =   1335
   End
   Begin VB.Label lblCaption 
      BackStyle       =   0  'Transparent
      Caption         =   "Go To"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   0
      Left            =   2760
      TabIndex        =   30
      Top             =   120
      Width           =   1215
   End
   Begin VB.Label lblCaption 
      BackStyle       =   0  'Transparent
      Caption         =   "Z:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   3
      Left            =   240
      TabIndex        =   29
      Top             =   1320
      Width           =   375
   End
   Begin VB.Label lblCaption 
      BackStyle       =   0  'Transparent
      Caption         =   "Y:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   2
      Left            =   240
      TabIndex        =   28
      Top             =   960
      Width           =   375
   End
   Begin VB.Label lblCaption 
      BackStyle       =   0  'Transparent
      Caption         =   "X:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   1
      Left            =   240
      TabIndex        =   27
      Top             =   600
      Width           =   375
   End
   Begin VB.Label lblActual 
      BackStyle       =   0  'Transparent
      Caption         =   "Actual"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   0
      Left            =   1680
      TabIndex        =   26
      Top             =   120
      Width           =   1215
   End
   Begin VB.Label lblActual 
      BackStyle       =   0  'Transparent
      Caption         =   "0"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Index           =   3
      Left            =   1680
      TabIndex        =   25
      Top             =   1320
      Width           =   975
   End
   Begin VB.Label lblActual 
      BackStyle       =   0  'Transparent
      Caption         =   "0"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Index           =   2
      Left            =   1680
      TabIndex        =   24
      Top             =   960
      Width           =   975
   End
   Begin VB.Label lblActual 
      BackStyle       =   0  'Transparent
      Caption         =   "0"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Index           =   1
      Left            =   1680
      TabIndex        =   23
      Top             =   600
      Width           =   975
   End
   Begin VB.Label lblCommanded 
      BackStyle       =   0  'Transparent
      Caption         =   "Commanded"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Index           =   0
      Left            =   240
      TabIndex        =   22
      Top             =   120
      Width           =   1335
   End
   Begin VB.Label lblCommanded 
      BackStyle       =   0  'Transparent
      Caption         =   "0"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Index           =   3
      Left            =   720
      TabIndex        =   18
      Top             =   1320
      Width           =   855
   End
   Begin VB.Label lblCommanded 
      BackStyle       =   0  'Transparent
      Caption         =   "0"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Index           =   2
      Left            =   720
      TabIndex        =   17
      Top             =   960
      Width           =   855
   End
   Begin VB.Label lblCommanded 
      BackStyle       =   0  'Transparent
      Caption         =   "0"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Index           =   1
      Left            =   720
      TabIndex        =   16
      Top             =   600
      Width           =   855
   End
End
Attribute VB_Name = "ServoForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'ServoForm
'29 Mar 2005
'Copyright
'C Lausted, Institute for Systems Biology
'
'This form communicates with the 6K4 motion controller and allows the
'user to move the three axes of the POSAM.
'A ethernet card must be set up with static IP number 192.168.10.31.
'Be sure to load the form into memory, hidden from view, at startup.
'Functions and properties:
'  MoveAbsolute(x,y,z)  MoveRelative(x,y,z)
'  Home(x,y,z)
'  cmdPos(3)  encPos(3)  bHomed(3)
'  bTest
'  SetVelocityX
'  SetTriggers
'Properties that must be initialized:
'  MinX, MaxX, MinY, MaxY, MinZ, MaxZ
'  LandmarkX(8), LandMarkY(8), LandmarkZ(8)
'
'
'Use with 6K operating system v5.1 or v5.2.1 and com6srvr v2.4.0.0.
'Dependencies: ErrorMessage, Stopwatch.
'//////////////////////////////////////////////////////////////////


'Type declarations.  This one borrowed from Compumotor example.
'Note on Fast Status: Do not change the ordering of elements.
Private Type FastStatusInfo
    updateID As Integer               ' Reserved for internal use
    Counter As Integer                ' time frame counter (2ms per count)
    MotorPos(1 To 8) As Long          ' commanded position (counts)
    EncoderPos(1 To 8) As Long        ' actual position (counts)
    MotorVel(1 To 8) As Long          ' commanded velocity (counts/sec)
    AxisStatus(1 To 8) As Long        ' axis status (TAS)
    SysStatus As Long                 ' system status (TSS)
    ErrorStatus As Long               ' user status (TER)
    UserStatus As Long                ' user status (TUS)
    Timer As Long                     ' timer value (TIM - milliseconds)
    Limits As Long                    ' limit status (TLIM)
    ProgIn(0 To 3) As Long            ' programmable input status (TIN)
    ProgOut(0 To 3) As Long           ' programmable output status (TOUT)
    Triggers As Long                  ' trigger interrupt status (TTRIG)
    Analog(1 To 2) As Integer         ' lo-res analog input voltage (TANV)
    VarB(1 To 10) As Long             ' VARB1 - VARB10
    VarI(1 To 10) As Long             ' VARI1 - VARI10
    Reserved As Long                  ' Reserved for internal use
    CmdCount As Long                  ' Command Count (from communications port)
End Type
'Note on SendVariable packet: Do not change the ordering of these data elements.
Private Type SendVariableStructure
  Mask As Long
  Reserved1 As Long
  Reserved2 As Long
  Reserved3 As Long
  VarI(1 To 12) As Long
  VarR(1 To 12) As Double
  VarB(1 To 8) As Long
End Type
'Unused library function declaration.
Rem Declare Sub CopyMemory Lib "Kernel32" Alias "RtlMoveMemory" (destination As Any, _
    source As Any, ByVal numbytes As Long)


'Constants specific to Pogo.
Private Const PARKER_IP As String = "192.168.10.30"
Private Const PARKER_MASK As String = "255,255,255,0"
Private Const THISPC_IP As String = "192.168.10.31"
Private Const CBIGJOG As Long = 4000             'Jog button moves leadscrew 1 full rev.
Private Const CSMALLJOG As Long = 1000           'Jog button moves leadscrew 1/4 rev.
Private Const CVERYCLOSE As Long = 100           'When not to call WaitMotionStart.
Private Const CCMOTIONDUR As Double = 20         'How many seconds to wait for motion before timeout.
Private Const CCHOMEDUR As Double = 40           'How many seconds to wait for homing.
Private Const CCFSDUR As Double = 60             'How many seconds to wait for FastStatus update.
Private Const CUSEFSSTREAMING As Boolean = False 'Were unable to use RequestFastStatusUpdate to completely replace FSEnabled.
Private Const CFSUPDATEPERIOD As Integer = 10    'If used, update 100 times/s. Perf is bad if period >10. Cant be <10.
Private Const CMOVINGBIT As Integer = 1
Private Const CINTARGETZONEBIT As Integer = 24
Private Const CWATCHDOGTIMEOUT As Integer = 60   'Com6srvr watchdog timeout is 60s.
Private Const CWATCHDOGTICKER As Integer = 3     'Set watchdog with 3 heartbeats in 60s.

'Servo performance constants
#If (True) Then  'True for old posam#1, False for new posam#2.
Private Const VELO As String = "V25,25,12"            'Set velocity.
Private Const ACCE As String = "A25,25,12"            'Set acceleration.
Private Const DECE As String = "AD25,25,12"           'Set deceleration.
Private Const SGP As String = "SGP20,20,20"           'Set proportional gain.
Private Const SGI As String = "SGI1,1,1"              'Set integral gain.
Private Const SGILIM As String = "SGILIM0,0,0"        'Set ILIM gain.
Private Const SGV As String = "SGV1,1,1"              'Set velocity gain.
Private Const SGAF As String = "SGAF0,0,0"            'Set AF gain.
Private Const SGVF As String = "SGVF0,0,0"            'Set VF gain.
Private Const STRGTD As String = "STRGTD40,10,250"    'X&Y within 3cts, Z within 100cts.
Private Const STRGTV As String = "STRGTV.01,.01,.01"  'Sets the velocity target zone to <= 0.01 units/sec.
Private Const STRGTT As String = "STRGTT500,500,500"  'Sets the timeout period to 1000 milliseconds on all axes.
#Else
Private Const VELO As String = "V50,50,12"            'Set velocity.
Private Const ACCE As String = "A50,25,20"            'Set acceleration.
Private Const DECE As String = "AD50,25,20"           'Set deceleration.
Private Const SGP As String = "SGP30,30,30"           'Set proportional gain.
Private Const SGI As String = "SGI30,30,30"           'Set integral gain.
Private Const SGILIM As String = "SGILIM0,0,0"        'Set ILIM gain.
Private Const SGV As String = "SGV4,4,0"              'Set velocity gain.
Private Const SGAF As String = "SGAF4,4,0"            'Set AF gain.
Private Const SGVF As String = "SGVF4,4,0"            'Set VF gain.
Private Const STRGTD As String = "STRGTD10,10,200"    'X&Y within 3cts, Z within 100cts.
Private Const STRGTV As String = "STRGTV.01,.01,.01"  'Sets the velocity target zone to <= 0.01 units/sec.
Private Const STRGTT As String = "STRGTT500,500,500"  'Sets the timeout period to 1000 milliseconds on all axes.
#End If


' Fast Status packet size in bytes
Private Const FS_PKT_SIZE As Long = 280
' Send Variable bit masks for the SendVariable and SendVariablePacket Com6srvr Methods
Private Const VARI1 As Long = 1                 'Use as flag to kill loop.
Private Const VARI2 As Long = 2
Private Const VARI3 As Long = 4
Private Const VARI4 As Long = 8                 'Use as trigger counter.
Private Const VARI5 As Long = 16                'Use to count missed triggers.
Private Const VARI6 As Long = 32
Private Const VARI7 As Long = 64
Private Const VARI8 As Long = 128
Private Const VARI9 As Long = 256
Private Const VARI10 As Long = 512              'Use to check faststatus update success.
Private Const VARI11 As Long = 1024
Private Const VARI12 As Long = 2048
Private Const VAR1 As Long = 4096
Private Const VAR2 As Long = 8192               'Use to hold trigger position.
Private Const VAR3 As Long = 16384
Private Const VAR4 As Long = 32768
Private Const VAR5 As Long = 65536
Private Const VAR6 As Long = 131072
Private Const VAR7 As Long = 262144
Private Const VAR8 As Long = 524288
Private Const VAR9 As Long = 1048576
Private Const VAR10 As Long = 2097152
Private Const VAR11 As Long = 4194304
Private Const VAR12 As Long = 8388608
Private Const VARB1 As Long = 16777216
Private Const VARB2 As Long = 33554432
Private Const VARB3 As Long = 67108864
Private Const VARB4 As Long = 134217728
Private Const VARB5 As Long = 268435456
Private Const VARB6 As Long = 536870912
Private Const VARB7 As Long = 1073741824
Private Const VARB8 As Long = &H80000000
' SendVariable packet size in bytes
Private Const SV_PKT_SIZE As Long = 192

'Variables global for this form.
Private istat As Integer, lstat As Long
Private c6k As Object                       'Comm server object (Use Ethernet).
Private fsinfo As FastStatusInfo            'Fast status information.  Currently unused.
Private gConnected As Boolean               'Flag to indicate connection state.
Private sw As Stopwatch
Private lTriggers As Long                   'Number of triggers for FOTF.
Private lSimTrig As Long                    'For test mode. Simulated number of triggers tripped.
Private lPos(1 To 3) As Long                'Position of simulated axes (test mode).
Private lMinX As Long, lMaxX As Long        'X axis limits.
Private lMinY As Long, lMaxY As Long        'Y axis limits.
Private lMinZ As Long, lMaxZ As Long        'Z axis limits.

'Public variables.
Public bTest As Boolean                     'Running in test mode if true.



Private Sub Form_Load()
    '28 June 2004 CGL.
    'This form should be loaded at Pogo startup.
    'It allows user to run Pogo in test mode if there's an error.
    Dim sErr As String
    Set sw = New Stopwatch
    bTest = False             'Default, not running in test mode.
    sErr = InitializeServo    'Prepare 6K4 with absolute positioning.
    If (Len(sErr) > 0) Then
        'Log the error.  Run test mode.
        ErrorMessage.Log sErr
        Rem sErr = sErr & "Would you like to continue running Pogo in test mode?"
        Rem If (MsgBox(sErr, vbYesNo) = vbYes) Then bTest = True Else End
        bTest = True
    End If
End Sub


Private Function InitializeServo() As String
    '9 Nov 2004 CGL.
    'This code was based on from the Arrayer082 Servo6K class.
    'Return a zero-length string if all ok, else a descriptive error.
    Dim sErr As String, iErr As Integer
    
    'Create connection to 6K controller.
    sErr = ConnectToServer
    If (Len(sErr) > 0) Then
        InitializeServo = sErr & vbCrLf
        Exit Function
    End If
    
    'Set default tuning parameters, speed, position, homing profile, etc.
    SetServoParameters
    WatchdogOn True
    
    'Shall we use FastStatus?  It can work either way.
    c6k.FSUpdateRate = CFSUPDATEPERIOD
    c6k.FSEnabled = CUSEFSSTREAMING
    
    'Wait for servo drive to start up
    sw.Reset
    Do
        If Not CUSEFSSTREAMING Then c6k.RequestFastStatusUpdate
        If sw.Elapsed(CCMOTIONDUR) Then
            InitializeServo = "Error: Timeout waiting for servo drives to start."
            Exit Function
        End If
    Loop Until (c6k.AxisStatus(1) * c6k.AxisStatus(2) * c6k.AxisStatus(3)) <> 0
    
    'Synchronize the commanded & actual positions.
    lMinX = -999999: lMaxX = 999999  'Temporary limits.
    lMinY = -999999: lMaxY = 999999  'Temporary limits.
    lMinZ = -999999: lMaxZ = 999999  'Temporary limits
    iErr = ServoForm.MoveAbsolute(ServoForm.encPos(1), ServoForm.encPos(2), ServoForm.encPos(3))
    
    Exit Function
ErrorHandler:
    InitializeServo = "Error creating COM6SRVR.NET.  Perhaps Motion Planner is not installed." & vbCrLf
End Function


Private Sub WatchdogOn(ByVal bOn As Boolean)
    '9 Nov 2004 CGL.
    'Turn on/off ethernet watchdog.  This will allow c6k to reset itself if connection is lost.
    'Compumotor recommends CWATCHDOGTIMEOUT=100s, CWATCHDOGTICKER=20s.  100/20=5. Must be < 65.
    Dim iErr As Integer
    If bTest Then Exit Sub
    If bOn Then
        iErr = c6k.SetWatchdog(CWATCHDOGTIMEOUT, CWATCHDOGTICKER)  'Turn it on.
    Else
        iErr = c6k.SetWatchdog(0, 0)  'Turn it off.
    End If
    'This feature is optional so I will only log any errors.
    If (iErr < 0) Then ErrorMessage.Log "Error " & iErr & ": Unable to set ethernet watchdog."
End Sub


Public Function StillConnected() As Boolean
    '9 Nov 2004 CGL.
    'Use heartbeat from ethernet watchdog to see if we are connected.
    If bTest Then
        StillConnected = True
    Else
        StillConnected = Not c6k.IsWatchdogTimedOut
    End If
End Function


Private Function ConnectToServer() As String
    '28 June 2004 CGL.
    'Try connecting through ethernet.  If it fails, try RS232.  Use RS232 connection
    'to get MAC address, turn on ethernet interface, and update the ARP table.
    'Return a zero-length string if all ok, else a descriptive error.
    Dim txt As Variant
    Dim lstat As Long    'status of 6k Write function.
    Dim iPort As Variant 'COM port number.
    Dim sMAC As String   'MAC address
    
    'First try ethernet connection to 6K controller.
    On Error GoTo UnableToCreateObject
    Set c6k = CreateObject("COM6SRVR.NET")  'See COM6SRVR.EXE in Windows\System or \WINNT\System32.
    lstat = c6k.Connect(PARKER_IP)
    If (lstat = 1) Then Exit Function  'No problem, we're connected.
    
UnableToCreateObject:
    Set c6k = Nothing  'Release c6k.
    'Give user opportunity to setup via RS232.  Ask for port number.
    txt = "Unable to connect via ethernet.  Shall I try to configure the 6K4 via RS232? " & _
        "If so, specify the COM port number below and click the OK button.  If not, click Cancel."
    iPort = Val(InputBox(txt, "6K4 Connection", "1"))
    If (iPort < 1) Or (iPort > 4) Then
        ConnectToServer = "Unable to connect to 6K4. No RS232 specified by user."
        Exit Function
    End If
    
    'Now try RS232.
    On Error GoTo ErrorHandler
    Set c6k = CreateObject("COM6SRVR.RS232")
    lstat = c6k.Connect(iPort)  'For COM1, COM2, COM3, or COM4.
    txt = Replace(PARKER_IP, ".", ",")  'Replace periods with commas in IP address.
    lstat = c6k.Write("NTADDR" & txt & vbLf)  'Set IP address in 6K4.
    lstat = c6k.Write("NTMASK" & PARKER_MASK & vbLf)  'Set IP mask in 6K4.
    lstat = c6k.Write("NTFEN2" & vbLf) 'Enable ethernet.
    sw.Wait (0.1)
    'Get the MAC address of the 6K4 ethernet interface.
    c6k.Flush  'Flush out text buffer.
    lstat = c6k.Write("TNTMAC" & vbLf) 'Returns "*TNTMAC0,144,85,0,0,1 >"
    sw.Wait (0.1)
    txt = c6k.Read() 'Null if nothing there.
    If (Len(txt) < 1) Then GoTo ErrorHandler  'Didn't get the MAC address.
    txt = Replace(txt, "TNTMAC", "")  'Strip off junk.
    txt = Replace(txt, "*", "")       'Strip off junk.
    txt = Replace(txt, ">", "")       'Strip off junk.
    txt = Replace(txt, vbCr, "")      'Strip off junk.
    txt = Replace(txt, vbLf, "")      'Strip off junk.
    txt = MyParse(txt)
    If (UBound(txt) <> 5) Then GoTo ErrorHandler
    sMAC = Hex(txt(0)) & "-" & Hex(txt(1)) & "-" & Hex(txt(2)) & "-" & _
        Hex(txt(3)) & "-" & Hex(txt(4)) & "-" & Hex(txt(5))
    'Close RS232
    Set c6k = Nothing
    
    'May need to update ARP table.
    txt = "Pogo will now update your PC's ARP table with 6K4 MAC address " & sMAC
    txt = txt & ".  At the DOS prompt, you may type `ARP -A` to view the ARP table.  "
    txt = txt & "Close the DOS prompt window by typing `exit`."
    MsgBox txt
    Shell ("CMD /K ARP -S " & PARKER_IP & " " & sMAC & " " & THISPC_IP), vbNormalFocus
    '>ARP -S [6k IP] [6K Ethernet] [PC IP]
    '>ARP -S 192.168.10.30 FF-FF-FF-FF-FF-FF 192.168.10.31
    
    'Now try ethernet again
    txt = "(" & txt & ")  Was the ARP table addition sucessful?"
    If (MsgBox(txt, vbYesNo) = vbNo) Then GoTo ErrorHandler
    On Error GoTo ErrorHandler
    Set c6k = CreateObject("COM6SRVR.NET")
    lstat = c6k.Connect(PARKER_IP)
    If (lstat = 1) Then Exit Function  'No problem, we're connected.
    
ErrorHandler:
    ConnectToServer = "Unable to connect to 6K4. Perhaps Motion Planner is not installed." & vbCrLf
End Function


Private Sub SetServoParameters()
    '14 Oct 2004 CGL
    'Set default tuning parameters, speed, position, homing profile, etc.
    'These parameters assume the SM21-to-leadscrew couplings are bellows-type.
    'If not, or if system friction is high, reduce gains and velocities.
    Dim lstat As Long
    
    lstat = c6k.Write("DRIVE0000" & vbLf)        'Turn drives off.
    lstat = c6k.Write("COMEXC0" & vbLf)          'disable continuous command execution.
    lstat = c6k.Write("T2" & vbLf)               'Pause 2 sec.
    lstat = c6k.Write("MA111" & vbLf)            'Absolute positioning mode.
    lstat = c6k.Write("SFB1" & vbLf)             'Select feedback.
    'Set servo gain parameters.
    lstat = c6k.Write(SGP & vbLf)         'Set proportional gain.
    lstat = c6k.Write(SGI & vbLf)         'Set integral gain.
    lstat = c6k.Write(SGILIM & vbLf)      'Set ILIM gain.
    lstat = c6k.Write(SGV & vbLf)         'Set velocity gain.
    lstat = c6k.Write(SGAF & vbLf)        'Set AF gain.
    lstat = c6k.Write(SGVF & vbLf)        'Set VF gain.
    'Set target zone for end-of-motion.
    lstat = c6k.Write("LH3,3,3,3" & vbLf)    'Enable checking of end-of-travel limits.
    lstat = c6k.Write(STRGTD & vbLf)         'X&Y within 3cts, Z within 100cts.
    lstat = c6k.Write(STRGTV & vbLf)         'Sets the velocity target zone to <= 0.01 units/sec.
    lstat = c6k.Write(STRGTT & vbLf)         'Sets the timeout period to 1000 milliseconds on all axes.
    lstat = c6k.Write("sTRGTE111" & vbLf)    'Enables the target zone criterion for XYZ axes.
    'Set default motion parameters.
    lstat = c6k.Write("D0,0,0" & vbLf)           'Set distances to 0.
    lstat = c6k.Write(VELO & vbLf)               'Set velocities.
    lstat = c6k.Write(ACCE & vbLf)               'Set accelerations.
    lstat = c6k.Write(DECE & vbLf)               'Set decelerations.
    'Setup a precise homing profile.
    lstat = c6k.Write("HOMA10,10,5" & vbLf)      'Set homing acceleration.
    lstat = c6k.Write("HOMAA10,10,5" & vbLf)     'Set homing ave accel.
    lstat = c6k.Write("HOMAD10,10,1" & vbLf)     'Set homing deceleration.
    lstat = c6k.Write("HOMADA10,10,1" & vbLf)    'Set homing ave decel.
    lstat = c6k.Write("HOMBAC111" & vbLf)        'Enable backup to home switch
    lstat = c6k.Write("HOMEDG000" & vbLf)        'Positive edge of home
    lstat = c6k.Write("HOMDF1,1,1" & vbLf)       'Set final homing direction
    lstat = c6k.Write("HOMV10,10,5" & vbLf)      'Set homing velocity a little faster.
    lstat = c6k.Write("HOMVF.5,.5,.5" & vbLf)    'Set final homing velocity
    lstat = c6k.Write("DRIVE1110" & vbLf)        'Turn drives on.
    'Fire-on-the-fly (FOTF) progress & flags.
    lstat = c6k.Write("VARI1=0" & vbLf)          'VARI1 flag to kill the loop.
    lstat = c6k.Write("VARI4=0" & vbLf)          'VARI4 as a counter since the 6K4 array pointer wraps around the end of the array to the beginning
    lstat = c6k.Write("VARI5=0" & vbLf)          'VARI5 flag warns if printhead too fast for 6K4.
    'Outputs.
    lstat = c6k.Write("OUTFNC1-A" & vbLf)        'Set output #1 to default, programmable.
End Sub


Private Sub Form_Unload(iCancel As Integer)
    '23 June 2004
    'Disable servo motors.  There's a delay here to give it time.
    If bTest Then Exit Sub
    lstat = c6k.Write("!K" & vbLf)
    sw.Wait (0.25)
    lstat = c6k.Write("!2%K" & vbLf)          'Be sure to kill SetTriggers program.
    sw.Wait (0.25)
    lstat = c6k.Write("DRIVE0000" & vbLf)    'Turn drives off.
    lstat = c6k.Write("COMEXC0" & vbLf)      'Disable continuous command execution.
    lstat = c6k.Write("2%COMEXC0" & vbLf)    'Disable continuous command execution.
    lstat = c6k.Write("OUTFNC1-A" & vbLf)    'Set output #1 back to default, programmable.
    c6k.FSEnabled = False
    sw.Wait (0.25)
    Set c6k = Nothing
    Set sw = Nothing
End Sub


Private Function IsBitSet(TestValue As Long, TestBit As Long) As Boolean
    'TestBit in the Range 1..32 (6K Convention).
    Dim Pwr As Long
    ' return false if out of range
    If TestBit < 1 Or TestBit > 32 Then
        IsBitSet = False
        Exit Function
    End If
    ' If MSB set return True
    If TestBit = 32 Then
        If TestValue < 0 Then
            IsBitSet = True
        Else
            IsBitSet = False
        End If
        Exit Function
    End If
    'Comparison.
    Pwr = 2 ^ (TestBit - 1)
    IsBitSet = (TestValue And Pwr)
End Function


Private Function UnSignedLong(InData As Integer) As Long
    ' Converts a 16 bit signed integer into a 32 bit unsigned long
    If InData < 0 Then
        UnSignedLong = CLng(InData) + 65536
    Else
        UnSignedLong = CLng(InData)
    End If
End Function


Private Function SignedInt(InData As Long) As Integer
    ' Converts a 32 bit unsigned long into a 16 bit signed integer
    Dim ConversionValue As Long
    If InData > 32767 Then
        ConversionValue = InData - 65536
        SignedInt = CInt(ConversionValue)
    Else
        SignedInt = CInt(InData)
    End If
End Function



'Public properties.
'*********************

Public Property Get cmdPos(i As Integer) As Long
    '2 July 2004 CGL.
    'Get commanded position.  Axes X:1, Y:2, Z:3.
    If (i < 1) Then i = 1
    If (i > 3) Then i = 3
    If bTest Then
        cmdPos = lPos(i)
    Else
        MyFastStatusUpdate
        cmdPos = c6k.MotorPos(i)
    End If
    lblCommanded(i).Caption = Val(cmdPos)
    lblCommanded(i).Refresh
End Property

Public Property Get encPos(i As Integer) As Long
    '2 July 2004 CGL.
    'Get actual encoder position.  Axes X:1, Y:2, Z:3.
    If (i < 1) Then i = 1
    If (i > 3) Then i = 3
    If bTest Then
        encPos = lPos(i)
    Else
        MyFastStatusUpdate
        encPos = c6k.EncoderPos(i)
    End If
    lblActual(i).Caption = Val(encPos)
    lblActual(i).Refresh
End Property

Public Property Get bHomed(i As Integer) As Boolean
    '12 Jan 2003 CGL.
    'Is the machine homed?  Axes X:1, Y:2, Z:3.
    If (i < 1) Then i = 1
    If (i > 3) Then i = 3
    If bTest Then
        bHomed = True
    Else
        MyFastStatusUpdate
        bHomed = IsBitSet(c6k.AxisStatus(i), 5)
    End If
End Property

Public Property Let MinX(ByVal newvalue As Long)
    '3 Jun 2004
   lMinX = newvalue
End Property
Public Property Let MaxX(ByVal newvalue As Long)
    '3 Jun 2004
   lMaxX = newvalue
End Property

Public Property Let MinY(ByVal newvalue As Long)
    '3 Jun 2004
   lMinY = newvalue
End Property
Public Property Let MaxY(ByVal newvalue As Long)
    '3 Jun 2004
   lMaxY = newvalue
End Property

Public Property Let MinZ(ByVal newvalue As Long)
    '3 Jun 2004
   lMinZ = newvalue
End Property
Public Property Let MaxZ(ByVal newvalue As Long)
    '3 Jun 2004
   lMaxZ = newvalue
End Property



'Ordinary subroutines and functions.
'***********************************

Private Sub MyFastStatusUpdate()
    '29 Mar 2005 CGL.
    'Request fast status update. Ensure status is new by checking time frame counter.
    Dim myfsinfo() As Byte  'My quick fast status information data structure.
    Dim newTF As Byte       'Time frame counter (an integer, bytes 2 and 3 of myfsinfo).
    Dim oldTF As Byte       'Previous time frame counter.
    
    'Turn on FS polling. Alternative to using c6k.RequestFastStatusUpdate.
    sw.Reset
    Do
        c6k.FSEnabled = True
        'Check that FS polling is on.
        If (sw.Elapsed(CCFSDUR)) Then
            ErrorMessage.Display "Unable to enable FS in ServoForm.MyFastStatusUpdate.", 60
            c6k.FSEnabled = CUSEFSSTREAMING
            Exit Sub
        End If
    Loop Until (c6k.FSEnabled = True)
    
    'Get lower byte of time frame counter.
    myfsinfo = c6k.FastStatus
    If ((UBound(myfsinfo) + 1) <> FS_PKT_SIZE) Then ErrorMessage.Display "FastStatus error in ServoForm.MyFastStatusUpdate.", 0
    oldTF = myfsinfo(2)
     
    'See if the time frame counter has changed.
    sw.Reset
    Do
        'Get lower byte of time frame counter.
        myfsinfo = c6k.FastStatus
        If ((UBound(myfsinfo) + 1) <> FS_PKT_SIZE) Then ErrorMessage.Display "FastStatus error in ServoForm.MyFastStatusUpdate.", 0
        newTF = myfsinfo(2)
        'Check if it has changed since we last checked. If so, we are done with this loop.
        If (newTF <> oldTF) Then Exit Do
        'Check for timeout.
        If (sw.Elapsed(CCFSDUR)) Then  'Pick a timeout about 60s.
            ErrorMessage.Display "Timeout in ServoForm.MyFastStatusUpdate.", 60
            c6k.FSEnabled = CUSEFSSTREAMING
            Exit Sub
        End If
    Loop
    
    c6k.FSEnabled = CUSEFSSTREAMING
End Sub


Private Sub OldMyFastStatusUpdate()
    '25 Oct 2004 CGL.
    'Request fast status update. To test that it works, read & write to VarI10.
    'This function has been deprecated.
    Static x As Integer
    Dim i As Integer
    
    If Not CUSEFSSTREAMING Then c6k.FSEnabled = True 'Use this instead of c6k.RequestFastStatusUpdate
    x = x - 1
    If (x <= 1) Then x = 10

    'First attempt.
    lstat = c6k.SendVariable(VARI10, x)
    For i = 1 To 16384
        If (c6k.VarI(10) = x) Then
            If Not CUSEFSSTREAMING Then c6k.FSEnabled = False
            Exit Sub
        End If
    Next i
    
    'Unsuccessful
    ErrorMessage.Display "Timeout in ServoForm.MyFastStatusUpdate.", 10
    If Not CUSEFSSTREAMING Then c6k.FSEnabled = False
End Sub


Public Sub WaitForInTargetZone()
    '9 Feb 2004 CGL.
    'Wait for motion to stop -- servos must be in target zone.
    Dim bX As Boolean, bY As Boolean, bZ As Boolean
    Dim txt As String
    If bTest Then Exit Sub
    sw.Reset
    Do
        'Check for timeout.
        If (sw.Elapsed(CCMOTIONDUR)) Then
            txt = "Error: unable to settle into the "
            If Not bX Then txt = txt & "X"
            If Not bY Then txt = txt & "Y"
            If Not bZ Then txt = txt & "Z"
            txt = txt & " target zone(s)."
            ErrorMessage.Display txt, 15
            Exit Sub
        End If
        'Check if we are moving
        MyFastStatusUpdate
        bX = IsBitSet(c6k.AxisStatus(1), CINTARGETZONEBIT)
        bY = IsBitSet(c6k.AxisStatus(2), CINTARGETZONEBIT)
        bZ = IsBitSet(c6k.AxisStatus(3), CINTARGETZONEBIT)
    Loop Until (bX And bY And bZ)
End Sub


Public Sub WaitForMotionStart()
    '14 Jan 2005 CGL.
    WaitForMotionStatus True, CCMOTIONDUR
End Sub

Public Sub WaitForMotionStop()
    '14 Jan 2005 CGL.
    WaitForMotionStatus False, CCMOTIONDUR
End Sub

Public Sub WaitForMotionStopPatiently()
    '14 Jan 2005 CGL.
    WaitForMotionStatus False, (CCMOTIONDUR * 5)
End Sub

Private Sub WaitForMotionStatus(ByVal bMoving As Boolean, ByVal lTimeout As Long)
    '14 Jan 2005 CGL.
    'Wait for motion to start (bMoving=TRUE) or stop (bMoving=FALSE).
    Dim bX As Boolean, bY As Boolean, bZ As Boolean
    
    If bTest Then Exit Sub
    sw.Reset
    Do
        'Check for timeout.
        If (sw.Elapsed(lTimeout)) Then
            ErrorMessage.Display "Error: motion has not started.", 15
            Exit Sub
        End If
        'Check if we are moving
        MyFastStatusUpdate
        bX = IsBitSet(c6k.AxisStatus(1), CMOVINGBIT)
        bY = IsBitSet(c6k.AxisStatus(2), CMOVINGBIT)
        bZ = IsBitSet(c6k.AxisStatus(3), CMOVINGBIT)
        If bMoving Then
            'Exit when any one axis moves.
            If (bX Or bY Or bZ) Then Exit Do
        Else
            'Exit when all three axes are not moving.
            If ((Not bX) And (Not bY) And (Not bZ)) Then Exit Do
        End If
    Loop
End Sub


Public Function MoveRelative(ByVal x As Long, ByVal y As Long, ByVal z As Long) As Integer
    '13 Jan 2004 CGL.
    'Move carefully with relative coordinates--keep Z axis as high as possible.
    Dim i1 As Integer, i2 As Integer
    If (z >= 0) Then
        'New position is higher so move up vertically first.
        i1 = MoveXYZ(0, 0, z, True, True)  'Relative, Waiting.
        i2 = MoveXYZ(x, y, 0, True, True)
    Else
        'New position is lower so move horizontally first.
        i2 = MoveXYZ(x, y, 0, True, True)
        i1 = MoveXYZ(0, 0, z, True, True)
    End If
    ServoForm.Refresh
    MoveRelative = i1 + i1
End Function


Public Function MoveRelativeNoWait(ByVal x As Long, ByVal y As Long, ByVal z As Long) As Integer
    '13 Jan 2004 CGL.
    'Move carefully with relative coordinates
    'Keep Z axis as high as possible.
    'Don't wait for motion to end before exiting.
    Dim i1 As Integer, i2 As Integer
    If (z >= 0) Then
        'New position is higher so move up vertically first.
        i1 = MoveXYZ(0, 0, z, True, True)   'Relative, Wait.
        i2 = MoveXYZ(x, y, 0, True, False)  'Relative, No waiting.
    Else
        'New position is lower so move horizontally first.
        i2 = MoveXYZ(x, y, 0, True, True)
        i1 = MoveXYZ(0, 0, z, True, False)
    End If
    ServoForm.Refresh
    MoveRelativeNoWait = i1 + i1
End Function


Public Function MoveAbsolute(ByVal x As Long, ByVal y As Long, ByVal z As Long) As Integer
    '13 Jan 2004 CGL.
    'Move carefully with absolute coordinates--keep Z axis as high as possible.
    Dim i1 As Integer, i2 As Integer
    If (z >= cmdPos(3)) Then
        'New position is higher so move up vertically first.
        i1 = MoveXYZ(cmdPos(1), cmdPos(2), z, False, True)  'Absolute, Waiting.
        i2 = MoveXYZ(x, y, cmdPos(3), False, True)
    Else
        'New position is lower so move horizontally first.
        i2 = MoveXYZ(x, y, cmdPos(3), False, True)
        i1 = MoveXYZ(cmdPos(1), cmdPos(2), z, False, True)
    End If
    ServoForm.Refresh
    MoveAbsolute = i1 + i1
End Function


Private Function MoveXYZ(ByVal x As Long, ByVal y As Long, ByVal z As Long, _
    ByVal bRelative As Boolean, ByVal bWait As Boolean) As Integer
    '18 Oct 2004 CGL.
    'Here we take either absolute or relative coordinates.
    'If bWait=TRUE, wait until motion stops before exiting function.
    Dim aX As Long, aY As Long, aZ As Long  'absolute coordinates.
    Dim rX As Long, ry As Long, rz As Long  'relative coordinates.
    Dim bNotClose As Boolean
    Dim sErr As String
    Dim mousept0
    sErr = ""
    MoveXYZ = 0
    
    'Calc the new absolute & relative coordinates.
    If bRelative Then
        aX = cmdPos(1) + x: aY = cmdPos(2) + y: aZ = cmdPos(3) + z
        rX = x: ry = y: rz = z
    Else
        aX = x: aY = y: aZ = z
        rX = x - cmdPos(1): ry = y - cmdPos(2): rz = z - cmdPos(3)
    End If
    
    'Program execution control.
    WaitForMotionStop
    bNotClose = ((Abs(rX) > CVERYCLOSE) Or (Abs(ry) > CVERYCLOSE) Or (Abs(rz) > CVERYCLOSE))
    
    'Error checking.
    If (aX > lMaxX) Or (aX < lMinX) Then sErr = sErr & "X coordinate out of range." & vbCrLf
    If (aY > lMaxY) Or (aY < lMinY) Then sErr = sErr & "Y coordinate out of range." & vbCrLf
    If (aZ > lMaxZ) Or (aZ < lMinZ) Then sErr = sErr & "Z coordinate out of range." & vbCrLf
    If (Len(sErr) > 0) Then
        ErrorMessage.Display ("Errors:" & vbCrLf & sErr), 0
        MoveXYZ = 1
        Exit Function
    End If
    
    'Cause motion in three axes if not in test mode and not already there.
    If Not (rX = 0 And ry = 0 And rz = 0) Then
    mousept0 = Screen.MousePointer
    Screen.MousePointer = vbHourglass
        If Not bTest Then
            lstat = c6k.Write("D" & aX & "," & aY & "," & aZ & vbLf) 'Set distance.
            lstat = c6k.Write("GO111" & vbLf)                        'Command motion.
            If bWait Then
               If bNotClose Then WaitForMotionStart
               WaitForMotionStop
               'WaitForInTargetZone
           End If
        End If
    End If
    Screen.MousePointer = mousept0
    
    'Handle test mode.
    lPos(1) = aX
    lPos(2) = aY
    lPos(3) = aZ
    
    'Update coordinates on this panel.
    tbxPosition(1).Text = cmdPos(1)
    tbxPosition(2).Text = cmdPos(2)
    tbxPosition(3).Text = cmdPos(3)
    lblCommanded(1).Caption = cmdPos(1)
    lblCommanded(2).Caption = cmdPos(2)
    lblCommanded(3).Caption = cmdPos(3)
    lblActual(1).Caption = encPos(1)
    lblActual(2).Caption = encPos(2)
    lblActual(3).Caption = encPos(3)
End Function


Public Function MoveZigzag(ByVal x As Long, ByVal y As Long, ByVal reps As Long) As String
    '14 Jan 2005 CGL.
    'All motion should be handled by MoveXYZ, except Home function and this function.
    'The process of drying a slide with an N2 jet manifold using repeated calls to MoveXYZ is slow.
    'Move the servo in a reciprocating pattern using 6K Compiled Motion.
    'Usage: sErr = MoveZigzag(8333, 30000, 3)  to dry one slide.
    Dim i As Integer
    Dim aX As Long, aY As Long  'Extreme absolute coordinates.
    Dim txt As String
    Dim sErr As String
    Dim mousept0
    sErr = ""
    
    'Calculate most extreme coordinates and check limits.
    aX = cmdPos(1) - (x * reps)
    aY = cmdPos(2) - y
    If (aX < lMinX) Or (aY < lMinY) Or (reps < 1) Then
        sErr = sErr & "Coordinates out of range in ServoForm.MoveZigzag."
        ErrorMessage.Display (sErr), 0
        MoveZigzag = sErr
        Exit Function
    End If
    
    mousept0 = Screen.MousePointer
    Screen.MousePointer = vbHourglass
    WaitForMotionStop
    
    If Not bTest Then
        'Transmit and start the program.
        lstat = c6k.Write("PAB0" & vbLf)                  'Use relative coordinates.
        lstat = c6k.Write("PA10" & vbLf)                   'Default accel is 10. Make 7.
        lstat = c6k.Write("PV12" & vbLf)                   'Default velo is 10.
        lstat = c6k.Write("DEL ZIGZAG" & vbLf)            'Delete any old Zigzag program.
        lstat = c6k.Write("DEF ZIGZAG" & vbLf)            'Start the Zigzag program.
        lstat = c6k.Write(" PAXES1,2" & vbLf)             ''Use X&Y axes.
        lstat = c6k.Write(" L" & reps & vbLf)             ''Loop (reps) times.
        txt = "0," & (y)
        lstat = c6k.Write("  PLIN0" & txt & vbLf)         '''Move linear.
        txt = Int(-x / 2) & ",0," & Int(-x / 4)
        lstat = c6k.Write("  PARCM" & txt & vbLf)         '''Move CCW arc.
        txt = "0," & (-y)
        lstat = c6k.Write("  PLIN" & txt & vbLf)          '''Move linear.
        txt = Int(-x / 2) & ",0," & Int(-x / 4)
        lstat = c6k.Write("  PARCP" & txt & vbLf)         '''Move CW arc
        lstat = c6k.Write(" LN" & vbLf)                   ''End of loop.
        lstat = c6k.Write("END" & vbLf)                   'End of program.
        lstat = c6k.Write("PCOMP ZIGZAG" & vbLf)          'Compile profile.
        lstat = c6k.Write("PRUN ZIGZAG" & vbLf)           'Run motion profile.
        WaitForMotionStart
        WaitForMotionStopPatiently
    Else
        'Handle test mode
        sw.Wait (2)
        lPos(1) = aX
    End If
    
    'Update coordinates on this panel.
    For i = 1 To 3
        tbxPosition(i).Text = cmdPos(i)
        lblCommanded(i).Caption = cmdPos(i)
        lblActual(i).Caption = encPos(i)
    Next i
    ServoForm.Refresh
    Screen.MousePointer = mousept0
End Function


Private Sub btnImportant_Click(Index As Integer)
    '8 Aug 2004 CGL.
    'Handle button to move to one of eight pre-defined positions.
    Dim sErr As String
    sErr = MoveToImportantPos(Index)
End Sub


Public Function MoveToImportantPos(ByVal pos As String) As String
    '11 Aug 2004 CGL.
    'Move to one of eight pre-defined positions. Given as name or number.
    '(1 Laser, 2 InkjetPurging, 3 SolPurging, 4 Gloves, 5 Park.)
    Dim iErr As String, sErr As String
    Dim x As Variant
    Dim i As Integer  'Important position number.
        
    'Check if pos is given by name or by integer number.
    x = Switch(pos = "Laser", 1, pos = "InkjetPurging", 2, pos = "SolenoidPurging", 3, _
        pos = "Gloves", 4, pos = "Park", 5, pos = "User6", 6, pos = "User7", 7, pos = "User8", 8)
    If Not IsNull(x) Then i = Int(x) Else i = Int(pos)
    If (i < 1) Or (i > 8) Then
        sErr = "Error in ServoForm.MoveToImportantPos."
        ErrorMessage.Display sErr, 5
        MoveToImportantPos = sErr
        Exit Function
    End If
    
    'The coordinates are stored in the button tags as "X Y Z".
    x = Split(btnImportant(i).Tag)
    iErr = MoveAbsolute(Int(x(0)), Int(x(1)), Int(x(2)))
    If (iErr <> 0) Then sErr = "Error in ServoForm.MoveToImportantPos using MoveAbsolute."
    MoveToImportantPos = sErr
End Function


Public Function Home(bX As Boolean, bY As Boolean, bZ As Boolean) As Integer
    '18 Oct 2004 CGL.
    'Home the positioners.  6K command is HOMX0XX for Y axis.
    Dim txt As String
    Dim sCmd As String
    Dim mousept0
    Home = 0
    txt = ""
    sCmd = "HOM123X"
    
    'Check if they are already homed.
    If bHomed(1) And bX Then txt = txt & "The X axis has already been homed." & vbCrLf
    If bHomed(2) And bY Then txt = txt & "The Y axis has already been homed." & vbCrLf
    If bHomed(3) And bZ Then txt = txt & "The Z axis has already been homed." & vbCrLf
    If (Len(txt) > 0) Then
        txt = txt & "Would you still like to re-home?"
        If (MsgBox(txt, vbYesNo) = vbNo) Then Exit Function
    End If
    'Update display panel and test mode variables.
    If bX Then
        lPos(1) = 0
        lblCommanded(1).Caption = 0
        lblActual(1).Caption = 0
        tbxPosition(1).Text = 0
    End If
    If bY Then
        lPos(2) = 0
        lblCommanded(2).Caption = 0
        lblActual(2).Caption = 0
        tbxPosition(2).Text = 0
    End If
    If bZ Then
        lPos(3) = 0
        lblCommanded(3).Caption = 0
        lblActual(3).Caption = 0
        tbxPosition(3).Text = 0
    End If
    If bTest Then Exit Function
    
    'Home for real if not in test mode.
    If bX Then sCmd = Replace(sCmd, 1, "0") Else sCmd = Replace(sCmd, 1, "X")
    If bY Then sCmd = Replace(sCmd, 2, "0") Else sCmd = Replace(sCmd, 2, "X")
    If bZ Then sCmd = Replace(sCmd, 3, "0") Else sCmd = Replace(sCmd, 3, "X")
    mousept0 = Screen.MousePointer
    Screen.MousePointer = vbHourglass
    lstat = c6k.Write(sCmd & vbLf)      'Home axis positive.
    Rem While Not HomeSuccess: Wend     'Wait for not home success.
    Rem While HomeSuccess: Wend         'Wait for home success.
    WaitForMotionStart
    'WaitForMotionStop
    istat = WaitForHomeSuccess(bX, bY, bZ)
    Screen.MousePointer = mousept0
    'Update display panel again.
    lblActual(1).Caption = encPos(1)
    lblActual(2).Caption = encPos(2)
    lblActual(3).Caption = encPos(3)
End Function


Private Function WaitForHomeSuccess(bX As Boolean, bY As Boolean, bZ As Boolean) As Integer
    '6 July 2004 CGL.
    'Wait for homing motion to stop in specified axis or axes.
    If bTest Then Exit Function
    WaitForHomeSuccess = 1
    sw.Reset
    Do
        'Check for timeout.
        If (sw.Elapsed(CCHOMEDUR)) Then
            ErrorMessage.Display "Error: homing function timed out.", 15
            Exit Function
        End If
        'Check if we are moving
        MyFastStatusUpdate
        If (Not bX Or (IsBitSet(c6k.AxisStatus(1), 5))) And _
           (Not bY Or (IsBitSet(c6k.AxisStatus(2), 5))) And _
           (Not bZ Or (IsBitSet(c6k.AxisStatus(3), 5))) Then Exit Do
    Loop
    WaitForHomeSuccess = 0 'Exit with no error.
End Function


Public Sub SetVelocityX(sglVel As Single)
    '13 Jan 2003 CGL.
    'Set velocities for X axis.  Default was 10.
    'Use sglVel=0 to reset to default velocity.
    'First, check for error or reset.
    If bTest Then Exit Sub
    If (sglVel > 200) Then Exit Sub 'Invalid value, might be too fast.
    If (sglVel <= 0) Then      'Reset with a default value.
        lstat = c6k.Write(VELO & vbLf)
        Exit Sub
    End If
    'Otherwise continue with normal execution.
    lstat = c6k.Write("V" & Format(sglVel, "0.00") & vbLf)  'Set velocities.
End Sub




'Functions that allow for fire-on-the-fly printing.
'**************************************************

Public Function SetTriggers(ByVal lFirstXPos As Long, ByVal lSpacing As Long, ByVal lCount As Long) As Integer
    '14 Feb 2005 CGL.
    'Set lCount triggers at lSpacing using output bit #1.
    'Spacing is lSPacing encoder counts.
    'Use some 6K4 variables.
    'VARI1: 0=Keep going, 1=exit now.
    'VARI2: holds the trigger position in abs units of encoder counts.
    'VARI4: number of triggers activated.
    'VARI5: 1=moved past trigger position already error, 0=no error.
    'A PLCP program is autorun for .5ms of every 2ms.
    
    'Parameter error checking here.
    SetTriggers = 0
    If (lFirstXPos < lMinX) Or ((lCount * lSpacing + lFirstXPos) > lMaxX) Then
        ErrorMessage.Display "Error in Servo6k->SetTriggers: Triggers out of range.", 0
        SetTriggers = 1
        Exit Function
    End If
    
    'Test mode.
    lSimTrig = 0         'Reset the simulated number of triggers.
    lTriggers = lCount   'Remember how many triggers have been requested.
    If bTest Then Exit Function
    
    'Turn off watchdog because it might slow performance.
    WatchdogOn False
    
    'Reset 6K4 VAR variables as motion status flags.
    lstat = c6k.Write("VARI2=" & lFirstXPos & vbLf)    'VAR2 holds trigger position.
    lstat = c6k.Write("VARI1=0" & vbLf)                'VARI1 flag to kill the loop. Active=1.
    lstat = c6k.Write("VARI4=0" & vbLf)                'VARI4 as a counter since the 6K4 array pointer wraps around the end of the array to the beginning
    lstat = c6k.Write("VARI5=0" & vbLf)                'VARI5 flag warns if printhead too fast for 6K4.
    lstat = c6k.Write("OUT.1-0" & vbLf)                'Reset trigger line low.
    lstat = c6k.Write("OUTFNC1-A" & vbLf)
    lstat = c6k.Write("NTSFS" & vbLf)                  'Send faststatus packet so PC gets updated VARs.
    
    'Transmit the program.
    lstat = c6k.Write("DEL PLCP1" & vbLf)               'Delete any old PLCP1 program.
    lstat = c6k.Write("DEF PLCP1" & vbLf)               'Start the PLCP1 program.
    
    lstat = c6k.Write("OUT.1-0" & vbLf)                  'Toggle trigger output low.
    lstat = c6k.Write("IF(1PE>VARI2)" & vbLf)            'Check IF we're past trigger.
    lstat = c6k.Write(" OUT.1-1" & vbLf)                 ''Toggle trigger output high.
    lstat = c6k.Write(" VARI2=VARI2+" & lSpacing & vbLf) ''Increment trigger position.
    lstat = c6k.Write(" VARI4=VARI4+1" & vbLf)           ''Increment counter.
    lstat = c6k.Write("NIF" & vbLf)                      'End IF.
    
    lstat = c6k.Write("IF(1PE>VARI2)" & vbLf)            'Check IF we're past next trigger.
    lstat = c6k.Write(" VARI5=VARI5+1" & vbLf)           ''Set VARI5 flag as errror.
    lstat = c6k.Write(" VARI1=1" & vbLf)                 ''Set flag to kill 6K4 STRIG program main loop.
    lstat = c6k.Write("NIF" & vbLf)                      'End IF.
    
    lstat = c6k.Write("IF(VARI4>=" & lCount & ")" & vbLf) 'Check IF we're done.
    lstat = c6k.Write(" VARI1=1" & vbLf)                 ''Set flag to kill 6K4 STRIG program main loop.
    lstat = c6k.Write("NIF" & vbLf)                      'End IF.
    
    lstat = c6k.Write("END" & vbLf)                      'end PLCP1 program.
    lstat = c6k.Write("PCOMP PLCP1" & vbLf)              'Compile PLCP1 program.
    lstat = c6k.Write("SCANP PLCP1" & vbLf)              'Activate PLCP1 program.
    
End Function


Public Sub KillTriggersLoop()
    '8 Feb 2005 CGL.
    'Set VARI1 = 0, wait 250ms, then shut off continuous command execution.
    If bTest Then Exit Sub
    lstat = c6k.SendVariable(VARI1, 1)              'Set flag to kill 6K4 STRIG program main loop.
    EndTriggering
End Sub

Public Property Get TriggersTripped() As Long
    '14 Feb 2005 CGL.
    'Report number of 6K FOTF triggers tripped.
    'Handle test mode.
    If bTest Then
        lSimTrig = lSimTrig + 2
        TriggersTripped = lSimTrig
        Exit Property
    End If
    'Get real ansewr. The contents of VARI4: number of triggers tripped.
    MyFastStatusUpdate
    TriggersTripped = CLng(c6k.VarI(4))
End Property

Public Property Get TriggersMissed() As Long
    '7 Feb 2005 CGL.
    'Get the contents of VARI5: number of triggers missed.
    If bTest Then TriggersMissed = 0: Exit Property
    MyFastStatusUpdate
    TriggersMissed = CLng(c6k.VarI(5))
End Property

Public Property Get TriggeringDone() As Boolean
    '14 Feb 2005 CGL.
    'Tell if FOTF 6K triggering is done.  Less important, since Pogo needs to monitor PogoDIO PG output buffer.
    'Handle test mode.
    If bTest Then
        lSimTrig = lSimTrig + 2  'Arbitrary speed.
        TriggeringDone = (lSimTrig >= lTriggers)
        Exit Property
    End If
    'Get real answer. The contents of VARI1: 1=triggering is done.
    MyFastStatusUpdate
    TriggeringDone = (CLng(c6k.VarI(1)) = 1)
    If TriggeringDone Then EndTriggering
End Property


Public Sub EndTriggering()
    '14 Feb 2005 CGL.
    If bTest Then Exit Sub
    lstat = c6k.Write("!K" & vbLf)         'Kill all motion & deactivate PLCP1.
    lstat = c6k.Write("SCANP CLR" & vbLf)  'Deactivate PLCP1 program. Redundant.
    lstat = c6k.Write("OUT.1-0" & vbLf)    'Toggle trigger output low.
    WatchdogOn True      'We had turned this off in SetTriggers().
End Sub


'Subroutines for buttons on this form.
'**************************************************

Private Sub btnJog_Click(Index As Integer)
    '13 Jan 2003 CGL.
    'Jog buttons to move the servo positioners.
    'Handle X axis cases.
    If (Index = 1) Then istat = MoveRelative(-CBIGJOG, 0, 0)
    If (Index = 2) Then istat = MoveRelative(-CSMALLJOG, 0, 0)
    If (Index = 3) Then istat = Home(True, False, False)
    If (Index = 4) Then istat = MoveRelative(CSMALLJOG, 0, 0)
    If (Index = 5) Then istat = MoveRelative(CBIGJOG, 0, 0)
    'Handle Y axis cases.
    If (Index = 6) Then istat = MoveRelative(0, -CBIGJOG, 0)
    If (Index = 7) Then istat = MoveRelative(0, -CSMALLJOG, 0)
    If (Index = 8) Then istat = Home(False, True, False)
    If (Index = 9) Then istat = MoveRelative(0, CSMALLJOG, 0)
    If (Index = 10) Then istat = MoveRelative(0, CBIGJOG, 0)
    'Handle Z axis cases.
    If (Index = 11) Then istat = MoveRelative(0, 0, -CBIGJOG)
    If (Index = 12) Then istat = MoveRelative(0, 0, -CSMALLJOG)
    If (Index = 13) Then istat = Home(False, False, True)
    If (Index = 14) Then istat = MoveRelative(0, 0, CSMALLJOG)
    If (Index = 15) Then istat = MoveRelative(0, 0, CBIGJOG)
End Sub


Private Sub btnGoToCoordinates_Click()
    '13 Jan 2003 CGL.
    Dim x As Long, y As Long, z As Long
    x = Val(tbxPosition(1).Text)
    y = Val(tbxPosition(2).Text)
    z = Val(tbxPosition(3).Text)
    istat = MoveAbsolute(x, y, z)
End Sub


Private Sub btnClose_Click()
    '13 Jan 2003 CGL.
    Hide
End Sub


Property Let ButtonsEnabled(ByVal bEnabled As Boolean)
    '17 Nov 2004 CGL.
    'Activate or deactivate buttons on this form.
    For Each obj In ServoForm
        If (left(obj.Name, 3) = "btn") Then obj.Enabled = bEnabled
    Next
    ServoForm.Refresh
End Property

