VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Begin VB.Form SlideForm 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Array Slide"
   ClientHeight    =   8790
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   7095
   ControlBox      =   0   'False
   Icon            =   "SlideForm.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   8790
   ScaleWidth      =   7095
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton btnDecrementMax 
      Caption         =   "<<"
      Height          =   495
      Left            =   4680
      TabIndex        =   25
      Top             =   600
      Width           =   495
   End
   Begin VB.CommandButton btnIncrementMax 
      Caption         =   ">>"
      Height          =   495
      Left            =   6480
      TabIndex        =   24
      Top             =   600
      Width           =   495
   End
   Begin VB.CommandButton btnClear 
      Caption         =   "Clear Array"
      Height          =   495
      Left            =   5400
      TabIndex        =   23
      Top             =   6960
      Width           =   1575
   End
   Begin VB.TextBox tbxFilename 
      ForeColor       =   &H80000003&
      Height          =   735
      Left            =   4680
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   1  'Horizontal
      TabIndex        =   22
      Top             =   5880
      Width           =   2295
   End
   Begin VB.TextBox tbxY 
      Enabled         =   0   'False
      Height          =   405
      Left            =   4680
      TabIndex        =   14
      Text            =   "1"
      Top             =   2400
      Width           =   1215
   End
   Begin VB.TextBox tbxX 
      Enabled         =   0   'False
      Height          =   405
      Left            =   4680
      TabIndex        =   13
      Text            =   "1"
      Top             =   1560
      Width           =   1215
   End
   Begin VB.CommandButton btnLoad 
      Caption         =   "Load..."
      Height          =   495
      Left            =   5400
      TabIndex        =   10
      Top             =   7560
      Width           =   1575
   End
   Begin VB.TextBox tbxSeq 
      ForeColor       =   &H80000003&
      Height          =   735
      Left            =   4680
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   1  'Horizontal
      TabIndex        =   9
      Top             =   4800
      Width           =   2295
   End
   Begin VB.TextBox tbxDesc 
      Enabled         =   0   'False
      ForeColor       =   &H80000003&
      Height          =   735
      Left            =   4680
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   1  'Horizontal
      TabIndex        =   7
      Top             =   3720
      Width           =   2295
   End
   Begin VB.CommandButton btnIncrement 
      Caption         =   ">"
      Height          =   495
      Left            =   5880
      TabIndex        =   5
      Top             =   600
      Width           =   495
   End
   Begin VB.CommandButton btnDecrement 
      Caption         =   "<"
      Height          =   495
      Left            =   5280
      TabIndex        =   4
      Top             =   600
      Width           =   495
   End
   Begin VB.TextBox tbxDown 
      Height          =   375
      Left            =   6000
      TabIndex        =   3
      Text            =   "1"
      Top             =   120
      Width           =   975
   End
   Begin VB.CommandButton btnClose 
      Caption         =   "Close"
      Default         =   -1  'True
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   5400
      TabIndex        =   1
      Top             =   8160
      Width           =   1575
   End
   Begin VB.PictureBox pbxSlide 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00000000&
      DrawWidth       =   3
      ForeColor       =   &H00000000&
      Height          =   8580
      Left            =   120
      MousePointer    =   2  'Cross
      ScaleHeight     =   174.959
      ScaleMode       =   0  'User
      ScaleWidth      =   58.084
      TabIndex        =   0
      Top             =   120
      Width           =   4375
   End
   Begin MSComDlg.CommonDialog CommonDialog1Load 
      Left            =   4920
      Top             =   7560
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      CancelError     =   -1  'True
   End
   Begin VB.Label Label6 
      Caption         =   "File:"
      Height          =   255
      Left            =   4680
      TabIndex        =   21
      Top             =   5640
      Width           =   1335
   End
   Begin VB.Label lblBank 
      Caption         =   "X"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   255
      Index           =   6
      Left            =   5880
      TabIndex        =   20
      Top             =   3000
      Width           =   255
   End
   Begin VB.Label lblBank 
      Caption         =   "X"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   255
      Index           =   5
      Left            =   5640
      TabIndex        =   19
      Top             =   3000
      Width           =   255
   End
   Begin VB.Label lblBank 
      Caption         =   "X"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   255
      Index           =   4
      Left            =   5400
      TabIndex        =   18
      Top             =   3000
      Width           =   255
   End
   Begin VB.Label lblBank 
      Caption         =   "X"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   255
      Index           =   3
      Left            =   5160
      TabIndex        =   17
      Top             =   3000
      Width           =   255
   End
   Begin VB.Label lblBank 
      Caption         =   "X"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   255
      Index           =   2
      Left            =   4920
      TabIndex        =   16
      Top             =   3000
      Width           =   255
   End
   Begin VB.Label lblBank 
      Caption         =   "X"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   255
      Index           =   1
      Left            =   4680
      TabIndex        =   15
      Top             =   3000
      Width           =   255
   End
   Begin VB.Label Label5 
      Caption         =   "Spot #Y (vert.):"
      Height          =   255
      Left            =   4680
      TabIndex        =   12
      Top             =   2160
      Width           =   1575
   End
   Begin VB.Label Label4 
      Caption         =   "Spot #X (horiz.):"
      Height          =   255
      Left            =   4680
      TabIndex        =   11
      Top             =   1320
      Width           =   1575
   End
   Begin VB.Label Label3 
      Caption         =   "Sequence:"
      Height          =   255
      Left            =   4680
      TabIndex        =   8
      Top             =   4560
      Width           =   1455
   End
   Begin VB.Label Label2 
      Caption         =   "Description:"
      Height          =   255
      Left            =   4680
      TabIndex        =   6
      Top             =   3480
      Width           =   1575
   End
   Begin VB.Label Label1 
      Caption         =   "Down:"
      Height          =   255
      Left            =   4680
      TabIndex        =   2
      Top             =   120
      Width           =   615
   End
End
Attribute VB_Name = "SlideForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'SlideForm
'v0.1.5
'21 Jan 2004
'Copyright
'C Lausted, Institute for Systems Biology
'
'Slide lineup information is viewed and stored on this form.
'
'Dependencies: ConfigForm, PogoMisc.
'Dependencies: COMDLG32.OCX.
'
'Store data in iArray(1 to CCOLS, 1 to CROWS, 1 to CBASES).
'  Access monomer k from feature i,j with m=SlideForm.FeatureElement(i,j,k).
'  Array is resized in third (oligo length) dimension to save memory.
'  Array unfortunately cannot be resized in first two dimensions.
'  Get size of used array with iCols, iRows, and iDowns.
'  Element is integer ASCII value of symbol (A=65,C=67,G=71,T=84).
'  Convert elements from ASCII to Bank number with PogoMain.Sym2Bank.
'//////////////////////////////////////////////////////////////////////

Option Base 1

'Private arrays, global to this form.  A VB limitation.
Dim iArray() As Integer  'Inkjet lineup iArray(column, row, base).
Dim sDesc(CCOLS, CROWS) As String   'Inkjet lineup dDesc(column, row)
Dim sSeq(CCOLS, CROWS) As String    'Inkjet lineup dSeq(column, row)
'Public variables.
Public bLoaded As Integer  'Is a line-up file loaded in this slide form?
Public iCols As Integer    'How many columns are used?
Public iRows As Integer    'How many rows are used?
Public iDowns As Integer   'How many bases in the oligo?



Property Get FeatureElement(i As Integer, j As Integer, k As Integer) As Integer
    '21 Jan 2004 CGL.
    'Provide access to reagent symbol for element k of feature i,j.
    'Would error checking of array bounds slow this down?
    'This integer is ascii code for the one-character symbol.
    FeatureElement = iArray(i, j, k)
End Property


Private Sub Form_Load()
    '22 Dec 2003 CGL.
    'Array iArray is initially empty.
    bLoaded = False
    iCols = 0
    iRows = 0
    iDowns = 0
    'Set size of display picturebox.
    pbxSlide.ScaleWidth = CCOLS + 2
    pbxSlide.ScaleHeight = CROWS + 2
    pbxSlide.width = 4375
    pbxSlide.Height = 8580
    'Get inkjet reagent abbreviation.
    lblBank(1).Caption = left(ConfigForm.GetParam("ReagentBank1") & "?", 1)
    lblBank(2).Caption = left(ConfigForm.GetParam("ReagentBank2") & "?", 1)
    lblBank(3).Caption = left(ConfigForm.GetParam("ReagentBank3") & "?", 1)
    lblBank(4).Caption = left(ConfigForm.GetParam("ReagentBank4") & "?", 1)
    lblBank(5).Caption = left(ConfigForm.GetParam("ReagentBank5") & "?", 1)
    lblBank(6).Caption = left(ConfigForm.GetParam("ReagentBank6") & "?", 1)
    lblBank(1).ForeColor = MyColor(1)
    lblBank(2).ForeColor = MyColor(2)
    lblBank(3).ForeColor = MyColor(3)
    lblBank(4).ForeColor = MyColor(4)
    lblBank(5).ForeColor = MyColor(5)
    lblBank(6).ForeColor = MyColor(6)
End Sub


Private Sub Form_Activate()
    '29 Dec 2003 CGL.
    'Check if inkjet reagent assignments have changed.
    'If so warn user and repaint display with new colors.
    Dim i As Integer
    Dim s1 As String, s2 As String
    Dim txt As String
    Dim bChanged As Boolean
    bChanged = False
    For i = 1 To 6
        s1 = lblBank(i).Caption
        s2 = left(ConfigForm.GetParam("ReagentBank" & i) & "?", 1)
        txt = "Warning: the reagent in inkjet bank " & i & " has been changed "
        txt = txt & "from " & s1 & " to " & s2 & ".  "
        txt = txt & "Check that all necessary reagents are available."
        If Not (s1 Like s2) Then
            'Change detected.
            bChanged = True
            MsgBox txt
            lblBank(i).Caption = left(ConfigForm.GetParam("ReagentBank" & i) & "?", 1)
        End If
    Next i
    If bChanged Then Repaint
End Sub


Private Sub Form_Unload(iCancel As Integer)
    '22 Dec 2003 CGL.
    'Do nothing right now.
End Sub


Private Sub btnClose_Click()
    Hide
End Sub


Private Sub btnDecrement_Click()
    '22 Dec 2003 CGL.
    'Let user view next down.
    Dim z As Integer
    z = Val(tbxDown.Text)
    z = z - 1
    If (z < 1) Then z = 1
    If (z > iDowns) Then z = Max(iDowns, 1)
    tbxDown.Text = z
    Repaint
End Sub
Private Sub btnIncrement_Click()
    '22 Dec 2003 CGL.
    'Let user view previous down.
    Dim z As Integer
    z = Val(tbxDown.Text)
    z = z + 1
    If (z < 1) Then z = 1
    If (z > iDowns) Then z = Max(iDowns, 1)
    tbxDown.Text = z
    Repaint
End Sub
Private Sub btnDecrementMax_Click()
    '30 Dec 2003 CGL.
    'Let user view first down.
    tbxDown.Text = 1
    Repaint
End Sub
Private Sub btnIncrementMax_Click()
    '30 Dec 2003 CGL.
    'Let user view last down.
    tbxDown.Text = iDowns
    Repaint
End Sub



Private Sub btnLoad_Click()
    'Updated 22Dec2003 CGL.
    'Retrieve data from a lineup file.
    Dim err As Integer
    On Error GoTo UserCancelled
    
    'Use a dialog box to get the file name.
    CommonDialog1Load.DefaultExt = ".key"
    CommonDialog1Load.FilterIndex = 2
    CommonDialog1Load.Filter = "Array line-up key (*.key)|*.key|" & _
      "Comma separated variables (*.csv)|*.csv|" & _
      "Lombardi line-up file (*.lnp)|*.lnp"
    CommonDialog1Load.ShowOpen
    
    'Check if file exists.
    If (Len(dir(CommonDialog1Load.filename)) < 1) Then
        MsgBox "Error: File " & CommonDialog1Load.filename & " does not exist."
        Exit Sub
    End If
    
    'Determine the file type from the extension.
    Select Case right(("fooo" & CommonDialog1Load.filename), 4)
        Case ".key", ".KEY"
            Rem MsgBox "Key file not yet supported."
            LoadKEY CommonDialog1Load.filename
        Case ".csv", ".CSV"
            LoadCSV CommonDialog1Load.filename
        Case ".lnp", ".LNP"
            MsgBox "LNP file not yet supported."
        Case Else
            MsgBox "Error: File type not supported."
    End Select
UserCancelled:
End Sub


Private Sub LoadCSV(sFilename As String)
    'Updated 22Dec2003 CGL.
    'Load a CSV file.
    'Filename validity not checked.
    Dim x As Integer, y As Integer, z As Integer 'row, col, base.
    Dim MaxX As Integer, MaxY As Integer, MaxZ As Integer
    Dim sLine As String 'One line of text.
    Dim sOligo As Variant 'One dimensional array of oligo strings.
    Dim bBadSym As Boolean  'Note unidentified base symbols.
    
    Screen.MousePointer = vbHourglass
    ReDim iArray(1 To CCOLS, 1 To CROWS, 1 To CBASES) 'All elements rezeroed.
    FileNumber = FreeFile
    y = 0: MaxX = 0: MaxY = 0: MaxZ = 0
    bBadSym = False
    
    'Read the data into iArray().
    Open sFilename For Input As #FileNumber
    Do While Not EOF(FileNumber)
        Line Input #FileNumber, sLine
        sLine = Trim(sLine) & ","
        'Check if the line is a comment line.
        If (Not (left(sLine, 1) = "#")) And (Len(sLine) > 1) Then
            sOligo = Split(sLine, ",")
            y = y + 1
            'Step through each column in this row.
            For x = 1 To Min(UBound(sOligo) + 1, CCOLS)
                'Step through each base in this oligo.
                For z = 1 To Len(sOligo(x - 1))
                    'Convert char symbol (ACGT) to ASCII.
                    iArray(x, y, z) = Asc(Mid(sOligo(x - 1), z, 1))
                    'Check validity of symbol.
                    If (PogoMain.Sym2Bank(iArray(x, y, z)) = -1) Then bBadSym = True
                Next z
                z = z - 1 'Undo very last increment of z.
                If (z > MaxZ) Then MaxZ = z
                'Also save oligo desc and seq.
                sDesc(x, y) = "unknown"
                sSeq(x, y) = sOligo(x - 1)
            Next x
            x = x - 1 'Undo very last increment of x.
            If (x > MaxX) Then MaxX = x
        End If
    Loop
    MaxY = y
    Close #FileNumber
    Rem ReDim Preserve iArray(1 To maxx, 1 To maxy, 1 To maxz) 'Can only redim 3rd dimension.
    ReDim Preserve iArray(1 To CCOLS, 1 To CROWS, 1 To MaxZ)
    bLoaded = True
    iCols = MaxX
    iRows = MaxY
    iDowns = MaxZ
    
    'Color the picturebox display.
    tbxDown.Text = 1
    Repaint
    Screen.MousePointer = vbDefault
    tbxFilename.Text = sFilename
    
    'Note potential problems.
    If bBadSym Then MsgBox "WARNING! At least one unidentified symbol was encountered in this .csv file"
End Sub


Private Sub LoadKEY(sFilename As String)
    'Updated 30 Dec 2003 CGL.
    'Load a KEY file.
    'Filename validity not checked.
    'Key file has four fields: Row, Col, Desc, Seq.  Zero base.
    Dim x As Integer, y As Integer, z As Integer 'row, col, base.
    Dim MaxX As Integer, MaxY As Integer, MaxZ As Integer
    Dim sLine As String 'One line of text.
    Dim sFields As Variant  'One dimensional array of fields.
    Dim sOligo As String    'Oligo sequence.
    Dim bBadSym As Boolean  'Note unidentified base symbols.
    
    Screen.MousePointer = vbHourglass
    ReDim iArray(1 To CCOLS, 1 To CROWS, 1 To CBASES) 'All elements rezeroed.
    FileNumber = FreeFile
    y = 0: MaxX = 0: MaxY = 0: MaxZ = 0
    bBadSym = False
    
    'Read the data into iArray().
    Open sFilename For Input As #FileNumber
    Do While Not EOF(FileNumber)
        Line Input #FileNumber, sLine
        sLine = MyTrim(sLine) 'Remove unwanted spaces.
        'Check if the line is a comment line.
        If (left(sLine, 1) <> "#") And (left(sLine, 18) <> "num_rows_per_slide") And (Len(sLine) > 4) Then
            sFields = Split(sLine, Chr(32)) 'Chr(9) is tab, Chr(32) is space.
            'Check if there are four fields in this line.
            If (UBound(sFields) = 3) Then
                y = sFields(0) + 1
                x = sFields(1) + 1
                'Check that coordinates are in valid range.
                If (x >= 1) And (x <= CCOLS) And (y >= 1) And (y <= CROWS) Then
                    'Everything OK.  Use this data.
                    sDesc(x, y) = sFields(2)
                    sSeq(x, y) = sFields(3)
                    sOligo = sFields(3)
                    For z = 1 To Len(sOligo)
                        'Convert char symbol (ACGT) to ASCII.
                        iArray(x, y, z) = Asc(Mid(sOligo, z, 1))
                        'Check validity of symbol.
                        If (PogoMain.Sym2Bank(iArray(x, y, z)) = -1) Then bBadSym = True
                    Next z
                    z = z - 1 'Undo very last increment of z.
                    If (z > MaxZ) Then MaxZ = z
                    If (x > MaxX) Then MaxX = x
                    If (y > MaxY) Then MaxY = y
                End If
            End If
        End If
    Loop
    MaxY = y
    Close #FileNumber
    Rem ReDim Preserve iArray(1 To maxx, 1 To maxy, 1 To maxz) 'Can only redim 3rd dimension.
    ReDim Preserve iArray(1 To CCOLS, 1 To CROWS, 1 To MaxZ)
    bLoaded = True
    iCols = MaxX
    iRows = MaxY
    iDowns = MaxZ
    If (iDowns = 0) Then
        MsgBox "Error: no data found in the key file."
        iDowns = 1
    End If
    
    'Color the picturebox display.
    tbxDown.Text = 1
    Repaint
    Screen.MousePointer = vbDefault
    tbxFilename.Text = sFilename
    
    'Note potential problems.
    If bBadSym Then MsgBox "WARNING! At least one unidentified symbol was encountered in this .key file"
End Sub


Private Sub Repaint()
    'Updated 22Dec2003 CGL.
    Dim x As Integer, y As Integer, z As Integer
    Dim iBank As Integer 'Inkjet reagent bank 1..6.
    'Error checking.
    If Not bLoaded Then Exit Sub
    z = Val(tbxDown.Text)
    If (z < 1) Then z = 1: tbxDown.Text = z
    If (z > UBound(iArray, 3)) Then z = UBound(iArray, 3): tbxDown.Text = z
    'Update picture box.
    Screen.MousePointer = vbHourglass
    For x = 1 To UBound(iArray, 1)
        For y = 1 To UBound(iArray, 2)
            iBank = PogoMain.Sym2Bank(iArray(x, y, z))
            pbxSlide.PSet (x, y), MyColor(iBank)
        Next y
    Next x
    pbxSlide.Refresh
    Screen.MousePointer = vbDefault
End Sub


Private Sub pbxSlide_MouseDown(btn As Integer, shft As Integer, x As Single, y As Single)
    'Updated 30Dec2003 CGL.
    'This sub allows selecting a single microarray feature.
    Dim z As Integer
    'Check x,y,z.
    If Not bLoaded Then Exit Sub
    x = Int(x + 0.5): y = Int(y + 0.5)
    If (x < 1) Then x = 1 Else If (x > CCOLS) Then x = CCOLS
    If (y < 1) Then y = 1 Else If (y > CROWS) Then y = CROWS
    'Update display textboxes.
    tbxX.Text = x
    tbxY.Text = y
    tbxDesc.Text = sDesc(x, y)
    tbxSeq.Text = sSeq(x, y) & " (" & Len(sSeq(x, y)) & "mer)"
    SlideForm.Refresh
End Sub


Private Sub btnClear_Click()
    'Updated 23Dec2003 CGL.
    'Empty / unuse this array.
    Dim txt As String
    Dim x As Integer, y As Integer
    'First double check.
    txt = "Are you sure that you do not wish to use this array?"
    If (MsgBox(txt, vbYesNo) = vbNo) Then Exit Sub
    'Clear everything from array variables.
    ReDim iArray(1 To CCOLS, 1 To CROWS, 1 To 1)
    For x = 1 To CCOLS
        For y = 1 To CROWS
            sDesc(x, y) = "(not loaded)"
            sSeq(x, y) = "(not loaded)"
        Next y
    Next x
    'Redraw screen.
    tbxFilename.Text = "(none loaded)"
    Repaint
    pbxSlide_MouseDown btn:=0, shft:=0, x:=1, y:=1
    'Clear public variables
    bLoaded = False
    iCols = 0
    iRows = 0
    iDowns = 0
End Sub
