VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Stopwatch"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'This Stopwatch class allows for easy timing.
'7 Nov 2004
'Units are seconds.


Private Const lDay As Double = 86400  '86400 = 24hr * 60min * 60sec.
Private startTime As Double           'This is the important time (in seconds).


Private Sub Class_Initialize()
    '7 Nov 2004 CGL.
    'Object constructor.
    Reset
End Sub


Public Sub Reset()
    '7 Nov 2004 CGL.
    'Reset the timer.
    startTime = Timer
End Sub


Public Function SecondsElapsed() As Double
    '7 Nov 2004 CGL.
    'How many seconds have passed since the timer was reset?
    Dim curTime As Double
    
    curTime = Timer
    'Check if the time elapsed over midnight.
    If (curTime < startTime) Then curTime = curTime + lDay
    SecondsElapsed = (curTime - startTime)
End Function


Public Function Elapsed(ByVal elapsedTime) As Boolean
    '7 Nov 2004 CGL.
    'Has the time elapsed?
    Dim et As Double
    
    'Check that time specified is positive.
    et = Val(elapsedTime)
    If (et <= 0) Then Elapsed = True: Exit Function
    
    'Check if the time has elapsed.
    Elapsed = (SecondsElapsed > et)
End Function


Public Sub Wait(ByVal dSeconds As Double)
    '7 Nov 2004 CGL.
    Reset
    Do
        DoEvents
    Loop Until Elapsed(dSeconds)
End Sub

