VERSION 5.00
Begin VB.UserControl ctlPiezo192 
   BackColor       =   &H00E0E0E0&
   BackStyle       =   0  'Transparent
   ClientHeight    =   3090
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   4425
   ScaleHeight     =   206
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   295
   Begin VB.CommandButton btnPurgeBank 
      Caption         =   "Purge All"
      Height          =   375
      Index           =   0
      Left            =   2160
      TabIndex        =   4
      Top             =   2520
      Width           =   855
   End
   Begin VB.Frame fraMain 
      BackColor       =   &H00E0E0E0&
      Caption         =   "Working Nozzles"
      Height          =   3015
      Left            =   0
      TabIndex        =   5
      Top             =   0
      Width           =   4335
      Begin VB.CommandButton btnPurgeBank 
         Caption         =   "6"
         Height          =   375
         Index           =   6
         Left            =   1800
         TabIndex        =   9
         Top             =   2520
         Width           =   375
      End
      Begin VB.CommandButton btnCenter 
         Caption         =   "Center"
         Height          =   375
         Left            =   3120
         Style           =   1  'Graphical
         TabIndex        =   3
         Top             =   1680
         UseMaskColor    =   -1  'True
         Width           =   1095
      End
      Begin VB.CommandButton btnDropletPhotodiode 
         Caption         =   "Photodiode"
         Height          =   375
         Left            =   3120
         Style           =   1  'Graphical
         TabIndex        =   2
         Top             =   1320
         UseMaskColor    =   -1  'True
         Width           =   1095
      End
      Begin VB.TextBox tbxDrops 
         Height          =   285
         Left            =   3120
         TabIndex        =   6
         Text            =   "1"
         Top             =   2520
         Width           =   1095
      End
      Begin VB.PictureBox pbxMain 
         AutoRedraw      =   -1  'True
         BackColor       =   &H00000000&
         Height          =   2175
         Left            =   120
         ScaleHeight     =   141
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   189
         TabIndex        =   7
         Top             =   240
         Width           =   2895
      End
      Begin VB.CommandButton btnReset 
         Caption         =   "Reset"
         Height          =   375
         Left            =   3120
         TabIndex        =   1
         Top             =   960
         Width           =   1095
      End
      Begin VB.CommandButton btnTestNozzles 
         Caption         =   "Test Nozzles"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   735
         Left            =   3120
         TabIndex        =   0
         Top             =   240
         Width           =   1095
      End
      Begin VB.CommandButton btnPurgeBank 
         Caption         =   "5"
         Height          =   375
         Index           =   5
         Left            =   1440
         TabIndex        =   10
         Top             =   2520
         Width           =   375
      End
      Begin VB.CommandButton btnPurgeBank 
         Caption         =   "4"
         Height          =   375
         Index           =   4
         Left            =   1080
         TabIndex        =   11
         Top             =   2520
         Width           =   375
      End
      Begin VB.CommandButton btnPurgeBank 
         Caption         =   "3"
         Height          =   375
         Index           =   3
         Left            =   720
         TabIndex        =   12
         Top             =   2520
         Width           =   375
      End
      Begin VB.CommandButton btnPurgeBank 
         Caption         =   "2"
         Height          =   375
         Index           =   2
         Left            =   360
         TabIndex        =   13
         Top             =   2520
         Width           =   375
      End
      Begin VB.CommandButton btnPurgeBank 
         Caption         =   "1"
         Height          =   375
         Index           =   1
         Left            =   120
         TabIndex        =   14
         Top             =   2520
         Width           =   255
      End
      Begin VB.Line Line1 
         BorderColor     =   &H80000009&
         X1              =   3120
         X2              =   4200
         Y1              =   2160
         Y2              =   2160
      End
      Begin VB.Label Label1 
         BackStyle       =   0  'Transparent
         Caption         =   "Drops (x1000)"
         Height          =   255
         Left            =   3120
         TabIndex        =   8
         Top             =   2280
         Width           =   1095
      End
   End
End
Attribute VB_Name = "ctlPiezo192"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'Control ctlPiezo192.
'25 Oct 2004
'Copyright
'C Lausted, Institute for Systems Biology
'
'This tests and remembers the status of the piezo nozzles.
'Set X, Y, and Z coordinates before use.
'Set relative X coordinates of pzt banks before use.
'Usage:
'  bIsGood = ctlPiezo.GetNozzle(6,32)
'  ctlPiezo.ResetNozzles
'  ctlPiezo.TestNozzles
'  PurgeDrops -- Number of drops to use when purging a bank.
'
'Dependencies: ServoForm, PogoDIO, PogoMIO, ErrorMessage, Stopwatch.
'////////////////////////////////////////////////////////////////////


Option Base 1

'Constants.
Private Const CBANKS As Integer = 6           'This name conflicts with PogoMisc.
Private Const CNOZROWS As Integer = 32        'This is redundant, too.
Private Const CDRAWWIDTH As Integer = 3
Private Const CTOTALNOZZLES As Integer = 192  '= 6 * 32.
Private Const CNUMDROPSTEST As Integer = 100  'Number droplets to spew for testing.
Private Const CDOUBLECHECK As Boolean = False 'Test each nozzle twice or once.

'Globals.
Dim istat As Integer
Dim bGood(CBANKS, CNOZROWS) As Boolean  'TRUE if nozzle passes test.
Dim lX As Long, lY As Long, lZ As Long  'Coordinates for droplet testing.  A Property.
Dim lBankOffset(CBANKS) As Long         'Relative coordinates of piezo banks.  A Property.
Dim sw As Stopwatch



Private Sub UserControl_Initialize()
    '16 Jan 2004 CGL.
    pbxMain.ScaleWidth = CBANKS + 1
    pbxMain.ScaleHeight = CNOZROWS + 3
    pbxMain.DrawWidth = CDRAWWIDTH
    ResetNozzles
    Set sw = New Stopwatch
End Sub


Private Sub UserControl_Terminate()
    '16 Jan 2004 CGL.
    Set sw = Nothing
End Sub


Public Property Let ButtonsEnabled(newvalue As Boolean)
    '11 Aug 2004 CGL
    'Enable/disable all buttons shown.  Trouble using 'For Each' loop.
    btnTestNozzles.Enabled = newvalue
    btnReset.Enabled = newvalue
    btnDropletPhotodiode.Enabled = newvalue
    btnCenter.Enabled = newvalue
    btnPurgeBank(1).Enabled = newvalue
    btnPurgeBank(2).Enabled = newvalue
    btnPurgeBank(3).Enabled = newvalue
    btnPurgeBank(4).Enabled = newvalue
    btnPurgeBank(5).Enabled = newvalue
    btnPurgeBank(6).Enabled = newvalue
    btnPurgeBank(0).Enabled = newvalue
End Property


'Set coordinate properties.
'28 June 2004 CGL.
Property Let x(newvalue As Long)
    lX = newvalue
End Property
Property Let y(newvalue As Long)
    lY = newvalue
End Property
Property Let z(newvalue As Long)
    lZ = newvalue
End Property
Property Let BankOffset(iBank As Integer, newvalue As Long)
    lBankOffset(iBank) = newvalue
End Property


Private Sub btnTestNozzles_Click()
    '16 Jan 2004 CGL.
    TestNozzles (CBANKS)
End Sub


Private Sub btnReset_Click()
    '16 Jan 2004 CGL.
    Dim txt As String
    txt = "Are you sure you wish to reset all nozzles as working?"
    If (MsgBox(txt, vbYesNo) = vbYes) Then ResetNozzles
End Sub


Property Get Nozzle(iBank As Integer, iRow As Integer)
    '16 Jan 2004 CGL.
    'Report Is this nozzle working?
    If (iBank < 1 Or iBank > CBANKS) Then Nozzle = False: Exit Property
    If (iRow < 1 Or iRow > CNOZROWS) Then Nozzle = False: Exit Property
    Nozzle = bGood(iBank, iRow)
End Property


Public Function GetReport() As String
    '16 Jan 2004 CGL.
    'Return a full report in hexadecimal.
    Dim i As Integer, j As Integer, k As Integer
    Dim txt As String
    Dim lX As Long
    
    If ((CNOZROWS Mod 4) <> 0) Then Exit Function 'This algorithm won't work
    For i = 1 To CBANKS
        For j = 0 To (CNOZROWS - 1) Step 4
            lX = 0
            For k = 1 To 4
                lX = lX * 2 + Abs(bGood(i, j + k))  'A TRUE is (-1).
            Next k
            txt = txt & Hex(lX)
        Next j
        txt = txt & " "
    Next i
    GetReport = txt
End Function


Public Sub ResetNozzles()
    '16 Jan 2004 CGL.
    'Set all nozzles to working status.
    Dim i As Integer, j As Integer
    For i = 1 To CBANKS
        For j = 1 To CNOZROWS
            bGood(i, j) = True
        Next j
    Next i
    Refresh
End Sub


Public Sub Refresh()
    '16 Jan 2004 CGL.
    'Use colors to show which nozzles are working.
    Dim i As Integer, j As Integer
    Dim lColor
    For i = 1 To CBANKS
        For j = 1 To CNOZROWS
            If bGood(i, j) Then lColor = PogoMisc.MyColor(i) Else lColor = QBColor(8)
            pbxMain.PSet (i, j), lColor
        Next j
    Next i
    pbxMain.Refresh
End Sub


Public Sub TestNozzles(ByVal iBanks As Integer)
    '10 Feb 2005 CGL.
    'Test bank #1 to #iBanks.  Usually 6.
    'Fire each individual nozzle.
    'Save the good ones as a value of 1 in global intPrinthead array.
    'If new nozzle failures, set global lessNozzles to number.
    'If nozzles return online, set global moreNozzles to number
    'Assume print head is positioned with bank on in laser line.
    Dim i As Integer, j As Integer
    Dim bPass As Boolean, b1 As Boolean, b2 As Boolean
    Dim txt As String, sErr As String
    Dim mousept0
    
    'Set up necessary variables.
    lessNozzles = 0
    morenozzles = 0
    
    'Error checking.
    If (iBanks < 1 Or iBanks > CBANKS) Then iBanks = CBANKS
        
    'Now for the real test.
    mousept0 = Screen.MousePointer
    Screen.MousePointer = vbHourglass
    PogoDIO.NozzlesAllOff
    
    'Fire each sequentially.  We start positioned at bank 1.
    istat = ServoForm.MoveAbsolute(lX, lY, lZ)
    For i = 1 To iBanks
        If (i > 1) Then istat = ServoForm.MoveRelative((-lBankOffset(i) + lBankOffset(i - 1)), 0, 0)
        For j = 1 To CNOZROWS
            'Select nozzle.
            PogoDIO.NozzlesAllOff
            PogoDIO.Nozzle(i, j) = True
            'Test once.
            PogoMIO.ResetDropletDetector
            sw.Wait (0.001)
            sErr = PogoDIO.Spew(CNUMDROPSTEST)
            If (sErr <> "") Then GoTo ErrorHandler
            sw.Wait (0.001)
            b1 = PogoMIO.ReadDropletDetector
            'Test again.
            If CDOUBLECHECK Then
                PogoMIO.ResetDropletDetector
                sw.Wait (0.001)
                sErr = PogoDIO.Spew(CNUMDROPSTEST)
                If (sErr <> "") Then GoTo ErrorHandler
                sw.Wait (0.001)
                b2 = PogoMIO.ReadDropletDetector
            Else
                b2 = b1
            End If
            'Record results
            bPass = (b1 And b2)
            If (bPass And Not bGood(i, j)) Then morenozzles = morenozzles + 1
            If (Not bPass And bGood(i, j)) Then lessNozzles = lessNozzles + 1
            bGood(i, j) = bPass
        Next j
    Next i
    istat = ServoForm.MoveAbsolute(lX, lY, lZ)
    PogoMIO.ResetDropletDetector
    
    Refresh
    
    'Note the addition or loss of nozzles.
    ErrorMessage.Log ("Nozzle status " & GetReport)
    txt = ""
    If (morenozzles > 0) Then txt = txt & morenozzles & " new online; "
    If (lessNozzles > 0) Then txt = txt & lessNozzles & " new offline."
    If (Len(txt) > 0) Then ErrorMessage.Display txt, 2

ErrorHandler:
    Screen.MousePointer = mousept0
    Beep
End Sub


Private Sub btnDropletPhotodiode_Click()
    '8 Aug 2004 CGL
    'Reset the droplet detecter indicator LED off.
    'If it was on, flash the color of the button red, briefly.
    Dim x As Long, txt As String
    If PogoMIO.ReadDropletDetector Then
        x = btnDropletPhotodiode.BackColor
        txt = btnDropletPhotodiode.Caption
        btnDropletPhotodiode.BackColor = vbRed
        btnDropletPhotodiode.Caption = "resetting..."
        Refresh
        PogoMIO.ResetDropletDetector
        PogoMain.sw.Wait (0.25)
        btnDropletPhotodiode.BackColor = x
        btnDropletPhotodiode.Caption = txt
        Refresh
    End If
End Sub


Private Sub btnCenter_Click()
    '10 Feb 2005 CGL
    'Center pzt bank 1 in the middle of the laser.
    'Move left to right in increments of 100 and Take the average position.
    Dim txt As String, sErr As String
    Dim rDrop As Boolean, lColor As Long
    Dim meanPos As Long, cntPos As Long
    Dim i As Integer, j As Integer, incr As Integer
    Dim mousept0
    
    incr = 100
    meanPos = 0: cntPos = 0
    txt = "Have you set the z axis and moved the x axis slightly left of the detector?"
    If MsgBox(txt, vbYesNo) = vbNo Then Exit Sub
    
    'Set up some nozzles of bank 1 to fire.
    mousept0 = Screen.MousePointer
    Screen.MousePointer = vbHourglass
    PogoDIO.NozzlesAllOff
    For j = 2 To 30 Step 4
        PogoDIO.Nozzle(1, j) = True
    Next j
    
    'Sweep left to right.  30 steps.
    lColor = btnCenter.BackColor
    For i = 1 To 30
        PogoMIO.ResetDropletDetector
        sErr = PogoDIO.Spew(5)
        If (sErr <> "") Then GoTo ErrorHandler
        rDrop = PogoMIO.ReadDropletDetector
        If rDrop Then
            'Flash of light observed.  Flash the button red.  Do averaging with sum/count.
            meanPos = meanPos + i
            cntPos = cntPos + 1
            btnCenter.BackColor = vbRed: btnCenter.Caption = "+": btnCenter.Refresh
        Else
            'No flash of light observed.  Turn button gray again.
            btnCenter.BackColor = lColor: btnCenter.Caption = "-": btnCenter.Refresh
        End If
        istat = ServoForm.MoveRelative(incr, 0, 0)
        If (cntPos > 3) And (rDrop = False) Then Exit For
    Next i
    'Reset droplet detecter and button.
    btnCenter.BackColor = lColor: btnCenter.Caption = "Center": btnCenter.Refresh
    PogoMIO.ResetDropletDetector
    
    'Move to center position and report to user.
    If (cntPos > 0) Then
        meanPos = Int(incr * meanPos / cntPos)
        istat = ServoForm.MoveRelative((meanPos - (incr * i)), 0, 0)
        MsgBox "Centered at x=" & ServoForm.cmdPos(1) & " z=" & ServoForm.cmdPos(3)
    Else
        istat = ServoForm.MoveRelative((-incr * i), 0, 0)
        MsgBox "Error finding center position"
    End If

ErrorHandler:
    Screen.MousePointer = mousept0
End Sub


Public Property Get PurgeDrops() As Integer
    '28 July 2004
    'Number of drops to jet when purging a bank.
    Dim i As Integer
    'Enforce number of drops range from 1*1000 to 1000*1000.
    i = Int(Val(tbxDrops.Text))
    If (i < 1 Or i > 1000) Then i = 1  'TODO: make this a Const.
    tbxDrops.Text = i
    tbxDrops.Refresh
    PurgeDrops = i
End Property
Public Property Let PurgeDrops(ByVal i As Integer)
    If (i < 1 Or i > 1000) Then i = 1  'TODO: make this a Const.
    tbxDrops.Text = i
    tbxDrops.Refresh
End Property


Private Sub btnPurgeBank_Click(Index As Integer)
    '10 Feb 2005 CGL.
    'Shoot lots of drops from all 32 nozzles of this bank.
    'If Index=0, then do all six banks.
    'Shoot through laser so user can see it working.
    Dim iDrops As Integer, i As Integer, j As Integer
    Dim iFirstBank As Integer, iLastBank As Integer
    Dim mousept0
    Dim sErr As String
    
    'Error checking.  Which bank or banks to jet from?
    If (Index < 0 Or Index > CBANKS) Then
        ErrorMessage.Display "Error in ctlPiezo192.btnPurgeBank.", 0
        Exit Sub
    End If
    If (Index = 0) Then
        iFirstBank = 1: iLastBank = CBANKS
    Else
        iFirstBank = Index: iLastBank = Index
    End If
    
    'Slow things down a bit to avoid PogoDIO DIG_Trigger_Error.
    sw.Wait (0.07)
    'Fire the drops.
    mousept0 = Screen.MousePointer
    Screen.MousePointer = vbHourglass
    For i = iFirstBank To iLastBank
        'Move to line of laser.
        istat = ServoForm.MoveAbsolute(lX - lBankOffset(i), lY, lZ)
        'Turn the 32 nozzles on.
        PogoDIO.NozzlesAllOff
        For j = 1 To CNOZROWS
            PogoDIO.Nozzle(i, j) = True
        Next j
        'Spew each 1000 drops as 10 * 100.  Total number from 10^3 to 10^6.
        For j = 1 To (PurgeDrops * 10)
            sErr = PogoDIO.Spew(100)
            If (sErr <> "") Then GoTo ErrorHandler
        Next j
    Next i
ErrorHandler:
    Screen.MousePointer = mousept0
End Sub


Public Sub PurgeAllNozzles(ByVal i As Integer)
    '10 Feb 2005 CGL.
    'Shoot i*1000 drops from every nozzle.
    'Do not move print head to the laser or anywhere.
    Dim sErr As String
    Dim mousept0
    Dim j As Integer
    
    mousept0 = Screen.MousePointer
    Screen.MousePointer = vbHourglass
    PogoDIO.NozzlesAllOn
    
    'Spew each 1000 drops as 10 * 100.  Total number from 10^3 to 10^6.
    For j = 1 To (i * 10)
        sErr = PogoDIO.Spew(100)
        If (sErr <> "") Then Exit For
        sw.Wait (0.02)  'Slow things down a bit to avoid overheating.
    Next j
    
    PogoDIO.NozzlesAllOff
    Screen.MousePointer = mousept0
End Sub
